/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatSentIdleStateHandler
extends IdleStateHandler {
    private static final Logger log = LogManager.getLogger((String)HeartbeatSentIdleStateHandler.class.getName());
    private final int writerIdleTime;
    private static final ByteBuf HEARTBEAT_SEQUENCE = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"ping", (Charset)CharsetUtil.UTF_8));

    public HeartbeatSentIdleStateHandler(int writerIdleTime) {
        super(0L, (long)writerIdleTime, 0L, TimeUnit.SECONDS);
        this.writerIdleTime = writerIdleTime;
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) {
        IdleStateEvent event = evt;
        if (event.state() == IdleState.WRITER_IDLE && ctx.channel().isWritable()) {
            ctx.writeAndFlush((Object)HEARTBEAT_SEQUENCE.duplicate());
            log.info(() -> "WRITER_IDLE(" + this.writerIdleTime + ") hearbeat sent " + ctx);
        }
    }
}

