/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.ws.rs;

import io.netty.handler.codec.http.HttpMethod;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.annotation.Controller;
import org.summerboot.jexpress.boot.annotation.Ping;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.ws.rs.BootController;
import org.summerboot.jexpress.nio.server.ws.rs.JaxRsRequestProcessor;
import org.summerboot.jexpress.util.ReflectionUtil;

public class JaxRsRequestProcessorManager {
    private static final Map<String, List<ProcessorMeta>> duplicatedProcessors = new HashMap<String, List<ProcessorMeta>>();
    private static Map<HttpMethod, Map<String, RequestProcessor>> processorMapString;
    private static Map<HttpMethod, Map<String, RequestProcessor>> processorMapRegex;

    private static boolean addProcessor(String key, Method m, Object instance) {
        List<ProcessorMeta> processors = duplicatedProcessors.get(key);
        if (processors == null) {
            processors = new ArrayList<ProcessorMeta>();
            duplicatedProcessors.put(key, processors);
        }
        boolean a = key.equals(Ping.class.getName());
        boolean b = m.getDeclaringClass().equals(BootController.class);
        if (processors.isEmpty() || key.equals(Ping.class.getName()) && !m.getDeclaringClass().equals(BootController.class)) {
            processors.add(new ProcessorMeta(key, m, instance));
            return true;
        }
        return false;
    }

    private static void checkDuplicated(StringBuilder errors) {
        for (String key : duplicatedProcessors.keySet()) {
            List<ProcessorMeta> processors = duplicatedProcessors.get(key);
            if (processors == null || processors.size() < 2) continue;
            errors.append("\n\n! Duplicated URI ").append(key);
            for (ProcessorMeta p : processors) {
                errors.append("\n\t").append("@ ").append(p.c.getName()).append(".").append(p.m.getName()).append("()");
            }
        }
    }

    public static void registerControllers(@Controller Map<String, Object> controllers, StringBuilder memo) {
        if (controllers == null || controllers.isEmpty()) {
            return;
        }
        duplicatedProcessors.clear();
        HashSet<String> declareRoles = new HashSet<String>();
        HashMap<HttpMethod, Map<String, RequestProcessor>> stringMap = new HashMap<HttpMethod, Map<String, RequestProcessor>>();
        HashMap<HttpMethod, Map<String, RequestProcessor>> regexMap = new HashMap<HttpMethod, Map<String, RequestProcessor>>();
        StringBuilder errors = new StringBuilder();
        Object loadBalancingEndpoint = null;
        StringBuilder sb = new StringBuilder();
        sb.append("Conflict of @Ping annotaion, should be only one @Ping in a @Controller class @GET method, but found multiple:");
        for (String name : controllers.keySet()) {
            Object javaInstance = controllers.get(name);
            Class<?> controllerClass = javaInstance.getClass();
            String rootPath = null;
            Path pathRoot = controllerClass.getAnnotation(Path.class);
            if (pathRoot != null) {
                rootPath = pathRoot.value().trim();
            }
            List<Method> methods = ReflectionUtil.getDeclaredAndSuperClassesMethods(controllerClass, true);
            for (Method javaMethod : methods) {
                HEAD amh;
                PATCH ampc;
                OPTIONS amo;
                DELETE amd;
                PUT ampt;
                POST amp;
                Object path;
                Path pathAnnotation = javaMethod.getAnnotation(Path.class);
                if (pathAnnotation == null || (path = StringUtils.isBlank((CharSequence)rootPath) ? pathAnnotation.value().trim() : rootPath + pathAnnotation.value().trim()) == null) continue;
                HashSet<HttpMethod> httpMethods = new HashSet<HttpMethod>();
                GET amg = javaMethod.getAnnotation(GET.class);
                if (amg != null) {
                    httpMethods.add(HttpMethod.GET);
                    Ping ping = javaMethod.getAnnotation(Ping.class);
                    if (ping != null) {
                        boolean isNew = JaxRsRequestProcessorManager.addProcessor(Ping.class.getName(), javaMethod, javaInstance);
                        if (!isNew) continue;
                        loadBalancingEndpoint = path;
                        sb.append("\n\t").append(javaMethod.getDeclaringClass().getName()).append(".").append(javaMethod.getName()).append("()");
                        memo.append("\n\t- ").append("* GET").append(" ").append((String)path).append(" (").append(javaMethod.getDeclaringClass().getName()).append(".").append(javaMethod.getName()).append(" )");
                        continue;
                    }
                }
                if ((amp = javaMethod.getAnnotation(POST.class)) != null) {
                    httpMethods.add(HttpMethod.POST);
                }
                if ((ampt = javaMethod.getAnnotation(PUT.class)) != null) {
                    httpMethods.add(HttpMethod.PUT);
                }
                if ((amd = javaMethod.getAnnotation(DELETE.class)) != null) {
                    httpMethods.add(HttpMethod.DELETE);
                }
                if ((amo = javaMethod.getAnnotation(OPTIONS.class)) != null) {
                    httpMethods.add(HttpMethod.OPTIONS);
                }
                if ((ampc = javaMethod.getAnnotation(PATCH.class)) != null) {
                    httpMethods.add(HttpMethod.PATCH);
                }
                if ((amh = javaMethod.getAnnotation(HEAD.class)) != null) {
                    httpMethods.add(HttpMethod.HEAD);
                }
                if (httpMethods.isEmpty()) continue;
                for (HttpMethod httpMethod : httpMethods) {
                    String key;
                    boolean isNew;
                    JaxRsRequestProcessor processor;
                    try {
                        processor = new JaxRsRequestProcessor(javaInstance, javaMethod, httpMethod, (String)path, declareRoles);
                        memo.append("\n\t- ").append(httpMethod).append(" ").append((String)path).append(" (").append(javaMethod.getDeclaringClass().getName()).append(".").append(javaMethod.getName()).append(" )");
                    }
                    catch (Throwable ex) {
                        errors.append("failed to create processor for ").append(controllerClass.getName()).append(".").append(javaMethod.getName()).append("\n\t").append(ex);
                        continue;
                    }
                    HashMap<HttpMethod, Map<String, RequestProcessor>> rootMap = processor.isUsingPathParam() || processor.isUsingMatrixPara() ? regexMap : stringMap;
                    TreeMap<String, JaxRsRequestProcessor> subMap = (TreeMap<String, JaxRsRequestProcessor>)rootMap.get(httpMethod);
                    if (subMap == null) {
                        subMap = new TreeMap<String, JaxRsRequestProcessor>(Comparator.comparingInt(String::length).reversed().thenComparing(Function.identity()));
                        rootMap.put(httpMethod, subMap);
                    }
                    if (!(isNew = JaxRsRequestProcessorManager.addProcessor(httpMethod + " " + (key = processor.getDeclaredPath()), javaMethod, javaInstance))) continue;
                    subMap.put(key, processor);
                }
            }
        }
        JaxRsRequestProcessorManager.checkDuplicated(errors);
        String error2 = errors.toString();
        if (!error2.isBlank()) {
            System.err.println("Invalid Java methods: \n" + errors);
            System.exit(1);
        }
        if (loadBalancingEndpoint != null) {
            System.setProperty("pingURI", loadBalancingEndpoint);
        }
        memo.append("\n\t- * DeclareRoles=").append(declareRoles);
        processorMapString = stringMap;
        processorMapRegex = regexMap;
    }

    public static RequestProcessor getRequestProcessor(HttpMethod httptMethod, String httpRequestPath) {
        if (processorMapString == null) {
            return null;
        }
        RequestProcessor processor = null;
        Map<String, RequestProcessor> subMap = processorMapString.get(httptMethod);
        if (subMap != null) {
            processor = subMap.get(httpRequestPath);
        }
        if (processor == null && (subMap = processorMapRegex.get(httptMethod)) != null) {
            for (RequestProcessor p : subMap.values()) {
                if (!p.matches(httpRequestPath)) continue;
                processor = p;
                break;
            }
        }
        return processor;
    }

    private static <T> T create(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                boolean flag = method.isAnnotationPresent(GET.class);
                return null;
            }
        });
    }

    private static class ProcessorMeta {
        final String url;
        final Class c;
        final Method m;
        final Object instance;

        public ProcessorMeta(String url, Method m, Object instance) {
            this.url = url;
            this.c = m.getDeclaringClass();
            this.m = m;
            this.instance = instance;
        }
    }
}

