/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security.auth;

import com.google.inject.Singleton;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.security.Key;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.security.JwtUtil;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.security.auth.Authenticator;
import org.summerboot.jexpress.security.auth.AuthenticatorListener;
import org.summerboot.jexpress.security.auth.Caller;
import org.summerboot.jexpress.security.auth.User;
import org.summerboot.jexpress.util.FormatterUtil;

@Singleton
public abstract class BootAuthenticator<T>
implements Authenticator {
    protected AuthenticatorListener listener;
    protected AuthConfig authCfg = AuthConfig.cfg;

    @Override
    public void setListener(AuthenticatorListener listener) {
        this.listener = listener;
    }

    @Override
    public String login(String uid, String pwd, Object metaData, int validForMinutes, ServiceContext context) throws NamingException {
        context.privacyReqContent(true);
        context.timestampPOI("ldap.begin");
        Caller caller = this.authenticate(uid, pwd, metaData, this.listener, context);
        context.timestampPOI("ldap.end");
        if (caller == null) {
            context.status(HttpResponseStatus.UNAUTHORIZED);
            return null;
        }
        JwtBuilder builder = this.toJwt(caller);
        Key signingKey = this.authCfg.getJwtSigningKey();
        String token = JwtUtil.createJWT(signingKey, builder, TimeUnit.MINUTES, validForMinutes);
        if (this.listener != null) {
            this.listener.onLoginSuccess(caller.getUid(), token);
        }
        context.caller(caller).status(HttpResponseStatus.CREATED).privacyRespHeader(true);
        return token;
    }

    protected abstract Caller authenticate(String var1, String var2, T var3, AuthenticatorListener var4, ServiceContext var5) throws NamingException;

    @Override
    public JwtBuilder toJwt(Caller caller) {
        Set<String> keys;
        String groupsCsv;
        String jti = caller.getTenantId() + "." + caller.getId() + "_" + caller.getUid() + "_" + System.currentTimeMillis();
        String issuer = this.authCfg.getJwtIssuer();
        String userName = caller.getUid();
        Set<String> groups = caller.getGroups();
        String audience = groupsCsv = groups == null || groups.size() < 1 ? null : groups.stream().collect(Collectors.joining(","));
        Claims claims = Jwts.claims();
        claims.setId(jti).setIssuer(issuer).setSubject(userName).setAudience(audience);
        if (caller.getId() != null) {
            claims.put((Object)"callerId", (Object)caller.getId());
        }
        if (caller.getTenantId() != null) {
            claims.put((Object)"tenantId", (Object)caller.getTenantId());
        }
        if (caller.getTenantName() != null) {
            claims.put((Object)"tenantName", (Object)caller.getTenantName());
        }
        if ((keys = caller.propKeySet()) != null) {
            for (String key : keys) {
                Object v = caller.getProp(key, Object.class);
                claims.put((Object)key, v);
            }
        }
        JwtBuilder builder = Jwts.builder().setClaims(claims);
        return builder;
    }

    @Override
    public Caller fromJwt(Claims claims) {
        Set keys;
        String userName = claims.getSubject();
        String audience = claims.getAudience();
        Long userId = (Long)claims.get("callerId", Long.class);
        Long tenantId = (Long)claims.get("tenantId", Long.class);
        String tenantName = (String)claims.get("tenantName", String.class);
        User caller = new User(tenantId, tenantName, userId, userName);
        String userGroups = audience;
        if (StringUtils.isNotBlank((CharSequence)userGroups)) {
            String[] groups = FormatterUtil.parseCsv(userGroups);
            for (String group : groups) {
                caller.addGroup(group);
            }
        }
        if ((keys = claims.keySet()) != null) {
            for (String key : keys) {
                Object v = claims.get((Object)key);
                caller.putProp(key, v);
            }
        }
        caller.remove("aud");
        caller.remove("exp");
        caller.remove("jti");
        caller.remove("iat");
        caller.remove("iss");
        caller.remove("nbf");
        caller.remove("sub");
        caller.remove("callerId");
        caller.remove("tenantId");
        caller.remove("tenantName");
        return caller;
    }

    @Override
    public String getBearerToken(HttpHeaders httpRequestHeaders) {
        String authToken = httpRequestHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        if (StringUtils.isBlank((CharSequence)authToken) || !authToken.startsWith("Bearer ")) {
            return null;
        }
        String[] a = authToken.split(" ");
        if (a.length < 2) {
            return null;
        }
        authToken = a[1];
        if (StringUtils.isBlank((CharSequence)authToken)) {
            return null;
        }
        return authToken;
    }

    public Caller verifyBearerToken(HttpHeaders httpRequestHeaders, AuthTokenCache cache, Integer errorCode, ServiceContext context) {
        String authToken = this.getBearerToken(httpRequestHeaders);
        return this.verifyToken(authToken, cache, errorCode, context);
    }

    public Caller verifyToken(String authToken, AuthTokenCache cache, Integer errorCode, ServiceContext context) {
        errorCode = errorCode == null ? this.overrideVerifyTokenErrorCode() : errorCode;
        Caller caller = null;
        if (authToken == null) {
            Err e = new Err(errorCode != null ? errorCode : 41, null, "Missing AuthToken", null);
            context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
        } else {
            try {
                Claims claims = (Claims)JwtUtil.parseJWT(this.authCfg.getJwtParser(), authToken).getBody();
                String jti = claims.getId();
                context.callerId(jti);
                if (cache != null && cache.isBlacklist(jti)) {
                    Err e = new Err(errorCode != null ? errorCode : 43, null, "AuthToken has been logout", null);
                    context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
                } else {
                    caller = this.fromJwt(claims);
                    if (this.listener != null && !this.listener.verify(caller, claims)) {
                        Err e = new Err(errorCode != null ? errorCode : 42, null, "Rejected AuthToken", null);
                        context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
                        caller = null;
                    }
                }
            }
            catch (ExpiredJwtException ex) {
                Err e = new Err(errorCode != null ? errorCode : 43, null, "Expired AuthToken", null);
                context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
            }
            catch (JwtException ex) {
                Err e = new Err(errorCode != null ? errorCode : 42, null, "Invalid AuthToken - " + ex.getMessage(), null);
                context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
            }
        }
        context.caller(caller);
        return caller;
    }

    protected Integer overrideVerifyTokenErrorCode() {
        return null;
    }

    @Override
    public void logout(HttpHeaders httpRequestHeaders, AuthTokenCache cache, ServiceContext context) {
        String authToken = this.getBearerToken(httpRequestHeaders);
        this.logout(authToken, cache, context);
    }

    @Override
    public void logout(String authToken, AuthTokenCache cache, ServiceContext context) {
        try {
            Claims claims = (Claims)JwtUtil.parseJWT(this.authCfg.getJwtParser(), authToken).getBody();
            String jti = claims.getId();
            String uid = claims.getSubject();
            Date exp = claims.getExpiration();
            long expireInMilliseconds = exp.getTime() - System.currentTimeMillis();
            if (cache != null) {
                cache.blacklist(jti, authToken, expireInMilliseconds);
            }
            if (this.listener != null) {
                this.listener.onLogout(jti, authToken, expireInMilliseconds);
            }
        }
        catch (ExpiredJwtException claims) {
        }
        catch (JwtException ex) {
            context.status(HttpResponseStatus.FORBIDDEN);
            return;
        }
        context.status(HttpResponseStatus.NO_CONTENT);
    }
}

