/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.persistence.PersistenceException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpTimeoutException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.nio.server.BootHttpRequestHandler;
import org.summerboot.jexpress.nio.server.NioExceptionHandler;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;

@Singleton
public class BootNioExceptionHandler
implements NioExceptionHandler {
    @Inject
    protected HealthInspector healthInspector;
    @Inject
    protected PostOffice po;

    @Override
    public void onActionNotFound(ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        Err e = new Err(44, null, "path not found: " + httptMethod + " " + httpRequestPath, null);
        context.error(e).status(HttpResponseStatus.NOT_FOUND);
    }

    @Override
    public void onNamingException(NamingException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        if (ex instanceof AuthenticationException) {
            Err e = new Err(47, null, "Authentication failed", null);
            context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        } else {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            if (cause == null) {
                cause = ex;
            }
            if (cause instanceof UnknownHostException) {
                HealthMonitor.setHealthStatus(false, ex.toString(), this.healthInspector);
                this.nakFatal(context, HttpResponseStatus.SERVICE_UNAVAILABLE, 52, "LDAP " + cause.getClass().getSimpleName() + ": " + cause.getMessage(), ex, BootHttpRequestHandler.cmtpCfg.getEmailToAppSupport(), httptMethod + " " + httpRequestPath);
            } else {
                Err e = new Err(52, null, cause.getClass().getSimpleName() + ": " + cause.getMessage(), (Throwable)ex);
                context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    @Override
    public void onPersistenceException(PersistenceException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
        if (cause == null) {
            cause = ex;
        }
        if (cause instanceof ConnectException) {
            HealthMonitor.setHealthStatus(false, ex.toString(), this.healthInspector);
            this.nakFatal(context, HttpResponseStatus.SERVICE_UNAVAILABLE, 54, "DB " + cause.getClass().getSimpleName() + ": " + cause.getMessage(), ex, BootHttpRequestHandler.cmtpCfg.getEmailToAppSupport(), httptMethod + " " + httpRequestPath);
        } else {
            Err e = new Err(54, null, cause.getClass().getSimpleName() + ": " + cause.getMessage(), (Throwable)ex);
            context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public void onHttpConnectTimeoutException(HttpConnectTimeoutException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        this.nak(context, HttpResponseStatus.GATEWAY_TIMEOUT, 24, ex.getMessage());
        context.level(Level.WARN);
    }

    @Override
    public void onHttpTimeoutException(HttpTimeoutException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        this.nak(context, HttpResponseStatus.GATEWAY_TIMEOUT, 22, ex.getMessage());
        context.level(Level.WARN);
    }

    @Override
    public void onRejectedExecutionException(Throwable ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        this.nak(context, HttpResponseStatus.SERVICE_UNAVAILABLE, 23, ex.getMessage());
        context.level(Level.WARN);
    }

    @Override
    public void onIOException(Throwable ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        HealthMonitor.setHealthStatus(false, ex.toString(), this.healthInspector);
        this.nakFatal(context, HttpResponseStatus.SERVICE_UNAVAILABLE, 20, "IO issue: " + ex.getClass().getSimpleName() + ": " + ex.getMessage(), ex, BootHttpRequestHandler.cmtpCfg.getEmailToAppSupport(), httptMethod + " " + httpRequestPath);
    }

    @Override
    public void onInterruptedException(InterruptedException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        Thread.currentThread().interrupt();
        this.nakFatal(context, HttpResponseStatus.INTERNAL_SERVER_ERROR, 21, "Service Interrupted", ex, BootHttpRequestHandler.cmtpCfg.getEmailToDevelopment(), httptMethod + " " + httpRequestPath);
    }

    @Override
    public void onUnexpectedException(Throwable ex, RequestProcessor processor, ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        this.nakFatal(context, HttpResponseStatus.INTERNAL_SERVER_ERROR, 9, "Unexpected Failure/Bug?", ex, BootHttpRequestHandler.cmtpCfg.getEmailToDevelopment(), httptMethod + " " + httpRequestPath);
    }

    protected void nak(ServiceContext context, HttpResponseStatus httpResponseStatus, int appErrorCode, String errorMessage) {
        Err e = new Err(appErrorCode, null, errorMessage, null);
        context.status(httpResponseStatus).error(e);
    }

    protected void nakError(ServiceContext context, HttpResponseStatus httpResponseStatus, int appErrorCode, String errorMessage, Throwable ex) {
        Err e = new Err(appErrorCode, null, errorMessage, ex);
        context.status(httpResponseStatus).error(e);
    }

    protected void nakFatal(ServiceContext context, HttpResponseStatus httpResponseStatus, int appErrorCode, String errorMessage, Throwable ex, Collection<String> emailTo, String content) {
        this.nakError(context, httpResponseStatus, appErrorCode, errorMessage, ex);
        context.level(Level.FATAL);
        if (this.po != null) {
            String briefContent = "caller=" + context.callerId() + ", request#" + context.hit() + ": " + content;
            this.po.sendAlertAsync(emailTo, errorMessage, briefContent, ex, true);
        }
    }
}

