/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.util.List;
import java.util.Map;
import org.summerboot.jexpress.nio.server.NioLifecycle;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.util.FormatterUtil;

public class BootNioLifecycleHandler
implements NioLifecycle {
    @Override
    public boolean preProcess(RequestProcessor processor, HttpHeaders httpRequestHeaders, String httpRequestPath, ServiceContext context) throws Exception {
        return true;
    }

    @Override
    public void afterService(RequestProcessor processor, ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        this.protectAuthToken(processor, httpRequestHeaders);
    }

    protected void protectAuthToken(RequestProcessor processor, HttpHeaders httpRequestHeaders) {
        if (httpRequestHeaders.contains((CharSequence)HttpHeaderNames.AUTHORIZATION)) {
            httpRequestHeaders.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)"***");
        }
    }

    @Override
    public String beforeSendingError(String errorContent) {
        return FormatterUtil.protectContent(errorContent, "UnknownHostException", ":", null, " ***");
    }

    @Override
    public String beforeLogging(String log) {
        return log;
    }

    @Override
    public void afterLogging(HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestUri, String httpPostRequestBody, ServiceContext context, long queuingTime, long processTime, long responseTime, long responseContentLength, String logContent, Throwable ioEx) throws Exception {
    }
}

