/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootGuiceModule;
import org.summerboot.jexpress.boot.ScanedGuiceModule;
import org.summerboot.jexpress.boot.SummerApplication;
import org.summerboot.jexpress.boot.SummerInitializer;
import org.summerboot.jexpress.boot.SummerRunner;
import org.summerboot.jexpress.boot.SummerSingularity;
import org.summerboot.jexpress.boot.annotation.Controller;
import org.summerboot.jexpress.boot.annotation.Order;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.i18n.I18n;
import org.summerboot.jexpress.integration.quartz.QuartzUtil;
import org.summerboot.jexpress.nio.grpc.GRPCServerConfig;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.ws.rs.JaxRsRequestProcessorManager;
import org.summerboot.jexpress.security.EncryptorUtil;
import org.summerboot.jexpress.security.JwtUtil;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

public abstract class SummerBigBang
extends SummerSingularity {
    private final Module userOverrideModule;
    protected Injector guiceInjector;
    protected List<SummerInitializer> summerInitializers = new ArrayList<SummerInitializer>();
    protected List<SummerRunner> summerRunners = new ArrayList<SummerRunner>();
    protected Scheduler scheduler;
    protected int schedulerTriggers = 0;

    protected SummerBigBang(Class callerClass, Module userOverrideModule, String ... args) {
        super(callerClass, args);
        this.userOverrideModule = userOverrideModule;
        this.singularity();
        this.aParallelUniverse(args);
    }

    public Injector getGuiceInjector() {
        return this.guiceInjector;
    }

    private void singularity() {
        this.guiceInjector = null;
        this.summerInitializers.clear();
        this.summerRunners.clear();
        this.schedulerTriggers = 0;
    }

    private <T extends SummerApplication> T aParallelUniverse(String ... args) {
        this.bigBang_LetThereBeCLI(args);
        this.bigBang_AndThereWasCLI();
        this.loadBootConfigFiles(ConfigUtil.ConfigLoadMode.app_run);
        for (SummerInitializer summerInitializer : this.summerInitializers) {
            summerInitializer.initApp(this.userSpecifiedConfigDir);
        }
        this.genesis(this.primaryClass, this.userSpecifiedImplTags);
        return (T)((SummerApplication)this);
    }

    protected void bigBang_LetThereBeCLI(String[] args) {
        Object validOptions;
        this.memo.append(BootConstant.BR).append("\t- CLI.init: args=").append(Arrays.asList(args));
        Option arg = Option.builder((String)BootConstant.CLI_USAGE).desc("Usage/Help").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)BootConstant.CLI_VERSION).desc("check application version").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)BootConstant.CLI_CONFIG_MONITOR_INTERVAL).desc("configuration monitoring interval in second (default " + this.userSpecifiedCfgMonitorIntervalSec + " seconds)").hasArg().argName("second").build();
        this.cliOptions.addOption(arg);
        arg = new Option(BootConstant.CLI_I8N, true, "language <en | fr-CA>");
        arg.setRequired(false);
        this.cliOptions.addOption(arg);
        if (this.availableImplTagOptions != null && !this.availableImplTagOptions.isEmpty()) {
            validOptions = FormatterUtil.toCSV(this.availableImplTagOptions);
            arg = Option.builder((String)BootConstant.CLI_USE_IMPL).desc("launch application with selected implementations, valid values <" + (String)validOptions + ">").hasArgs().argName("items").build();
            arg.setArgs(-2);
            arg.setRequired(false);
            this.cliOptions.addOption(arg);
        }
        arg = Option.builder((String)BootConstant.CLI_CONFIG_DOMAIN).desc("Start the program using the configuration in the ../" + BootConstant.DIR_STANDALONE + "_<domain_name> directory. For example, if you specify -" + BootConstant.CLI_CONFIG_DOMAIN + " foo, the program will load the configuration files from the ../" + BootConstant.DIR_STANDALONE + "_foo directory. If this option is not specified, the program will start using the default configuration files.").hasArg().argName("domain suffix").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)BootConstant.CLI_CONFIG_DIR).desc("the path to load the configuration files, or load from current folder when not specified").hasArg().argName("path").build();
        this.cliOptions.addOption(arg);
        if (this.scanedJExpressConfigs != null && !this.scanedJExpressConfigs.isEmpty()) {
            validOptions = FormatterUtil.toCSV(this.scanedJExpressConfigs.keySet());
            arg = Option.builder((String)BootConstant.CLI_CONFIG_DEMO).desc("Show specified configuration template (" + (String)validOptions + "), or when specified with -" + BootConstant.CLI_CONFIG_DOMAIN + " just dump all available configuration templates to the specified folder").hasArgs().argName("config").optionalArg(true).build();
            this.cliOptions.addOption(arg);
        }
        if (!this.availableUniqueTagOptions.isEmpty()) {
            arg = Option.builder((String)BootConstant.CLI_LIST_UNIQUE).desc("Show list of: " + this.availableUniqueTagOptions).hasArg().argName("item").build();
            this.cliOptions.addOption(arg);
        }
        arg = Option.builder((String)BootConstant.CLI_ADMIN_PWD_FILE).desc("Specify an application configuration password in a file which contains a line: APP_ROOT_PASSWORD=<base64 encoded password>" + BootConstant.BR + "Note: Unlike the -" + BootConstant.CLI_ADMIN_PWD + " opton, this option protects the app config password from being exposed via ps command.").hasArg().argName("file").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)BootConstant.CLI_ADMIN_PWD).desc("Specify an application config password instead of the default one." + BootConstant.BR + "Note: This option exposes the app config password via ps command").hasArg().argName("password").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)BootConstant.CLI_JWT).desc("generate JWT root signing key with the specified algorithm <HS256, HS384, HS512>").hasArg().argName("algorithm").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)BootConstant.CLI_ENCRYPT).desc("Encrypt config file content with all \"DEC(plain text)\":" + BootConstant.BR + BootConstant.BR + "\t -" + BootConstant.CLI_ENCRYPT + " -" + BootConstant.CLI_CONFIG_DOMAIN + " <domain> -" + BootConstant.CLI_ADMIN_PWD_FILE + " <path>" + BootConstant.BR + BootConstant.BR + "\t or" + BootConstant.BR + BootConstant.BR + "\t -" + BootConstant.CLI_ENCRYPT + " -" + BootConstant.CLI_CONFIG_DOMAIN + " <domain> -" + BootConstant.CLI_ADMIN_PWD + " <password>").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)BootConstant.CLI_DECRYPT).desc("Decrypt config file content with all \"ENC(encrypted text)\" using password:" + BootConstant.BR + BootConstant.BR + BootConstant.BR + "\t -" + BootConstant.CLI_DECRYPT + " -" + BootConstant.CLI_CONFIG_DOMAIN + " <path> -" + BootConstant.CLI_ADMIN_PWD + " <password>").build();
        this.cliOptions.addOption(arg);
        this.summerInitializers.addAll(this.scanImplementation_SummerInitializer());
        for (SummerInitializer summerInitializer : this.summerInitializers) {
            summerInitializer.initCLI(this.cliOptions);
        }
        try {
            DefaultParser parser = new DefaultParser();
            this.cli = parser.parse(this.cliOptions, args);
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
            this.cliHelpFormatter.printHelp(this.appVersion, this.cliOptions);
            System.exit(1);
        }
    }

    protected List<SummerInitializer> scanImplementation_SummerInitializer() {
        ArrayList<SummerInitializer> summerCLIs = new ArrayList<SummerInitializer>();
        Set<Class<SummerInitializer>> summerCLI_ImplClasses = ReflectionUtil.getAllImplementationsByInterface(SummerInitializer.class, this.callerRootPackageNames);
        TreeSet<Integer> orderSet = new TreeSet<Integer>();
        HashMap<Integer, ArrayList<SummerInitializer>> orderMapping = new HashMap<Integer, ArrayList<SummerInitializer>>();
        for (Class<SummerInitializer> c : summerCLI_ImplClasses) {
            SummerInitializer instance;
            int order = 0;
            Order o = c.getAnnotation(Order.class);
            if (o != null) {
                order = o.value();
            }
            try {
                Constructor<SummerInitializer> cc = c.getConstructor(new Class[0]);
                cc.setAccessible(true);
                instance = cc.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new InaccessibleObjectException("Failed to call default constructor of " + c.getName());
            }
            orderSet.add(order);
            ArrayList<SummerInitializer> sameOoderCLIs = (ArrayList<SummerInitializer>)orderMapping.get(order);
            if (sameOoderCLIs == null) {
                sameOoderCLIs = new ArrayList<SummerInitializer>();
                orderMapping.put(order, sameOoderCLIs);
            }
            sameOoderCLIs.add(instance);
        }
        Iterator<Class<SummerInitializer>> iterator = orderSet.iterator();
        while (iterator.hasNext()) {
            int order = (Integer)((Object)iterator.next());
            summerCLIs.addAll((Collection)orderMapping.get(order));
        }
        return summerCLIs;
    }

    protected boolean runCLI_Utils() {
        boolean continueCLI = true;
        if (this.cli.hasOption(BootConstant.CLI_USAGE)) {
            continueCLI = false;
            this.cliHelpFormatter.printHelp(this.appVersion, this.cliOptions);
        }
        if (this.cli.hasOption(BootConstant.CLI_VERSION)) {
            continueCLI = false;
            System.out.println(this.appVersion);
        }
        if (this.cli.hasOption(BootConstant.CLI_JWT)) {
            continueCLI = false;
            String algorithm = this.cli.getOptionValue(BootConstant.CLI_JWT);
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forName((String)algorithm);
            String jwt = JwtUtil.buildSigningKey(signatureAlgorithm);
            System.out.println(jwt);
        }
        if (this.cli.hasOption(BootConstant.CLI_LIST_UNIQUE)) {
            continueCLI = false;
            String tag = this.cli.getOptionValue(BootConstant.CLI_LIST_UNIQUE);
            StringBuilder sb = new StringBuilder();
            String error2 = this.scanAnnotation_Unique(this.callerRootPackageNames, sb, tag);
            if (error2 != null) {
                System.out.println(error2);
            } else {
                System.out.println(sb);
            }
        }
        return continueCLI;
    }

    protected void bigBang_AndThereWasCLI() {
        if (!this.runCLI_Utils()) {
            System.exit(0);
        }
        if (this.cli.hasOption(BootConstant.CLI_ADMIN_PWD_FILE)) {
            String adminPwdFile = this.cli.getOptionValue(BootConstant.CLI_ADMIN_PWD_FILE);
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(adminPwdFile);){
                props.load(is);
            }
            catch (Throwable ex) {
                throw new RuntimeException("failed to load " + adminPwdFile, ex);
            }
            String adminPwd = props.getProperty("APP_ROOT_PASSWORD");
            adminPwd = SecurityUtil.base64Decode(adminPwd);
            EncryptorUtil.init(adminPwd);
        } else if (this.cli.hasOption(BootConstant.CLI_ADMIN_PWD)) {
            String adminPwd = this.cli.getOptionValue(BootConstant.CLI_ADMIN_PWD);
            EncryptorUtil.init(adminPwd);
        }
        if (this.cli.hasOption(BootConstant.CLI_CONFIG_MONITOR_INTERVAL)) {
            String cmi = this.cli.getOptionValue(BootConstant.CLI_CONFIG_MONITOR_INTERVAL);
            this.userSpecifiedCfgMonitorIntervalSec = Integer.parseInt(cmi);
        }
        if (this.cli.hasOption(BootConstant.CLI_CONFIG_DEMO) && !this.cli.hasOption(BootConstant.CLI_CONFIG_DIR) && !this.cli.hasOption(BootConstant.CLI_CONFIG_DOMAIN)) {
            Class c;
            String cfgName = this.cli.getOptionValue(BootConstant.CLI_CONFIG_DEMO);
            if (cfgName == null) {
                String validOptions = FormatterUtil.toCSV(this.scanedJExpressConfigs.keySet());
                System.err.println("Missing config option, valid values <" + validOptions + ">");
                System.exit(1);
            }
            if ((c = ((SummerSingularity.ConfigMetadata)this.scanedJExpressConfigs.get((Object)cfgName)).cfgClass) == null) {
                String validOptions = FormatterUtil.toCSV(this.scanedJExpressConfigs.keySet());
                System.err.println(cfgName + "is an invalid config option, valid values <" + validOptions + ">");
                System.exit(1);
            }
            String t = BootConfig.generateTemplate(c);
            System.out.println(t);
            System.exit(0);
        }
        log.trace(() -> I18n.info.launching.format(this.userSpecifiedResourceBundle, new String[0]) + ", cmi=" + this.userSpecifiedCfgMonitorIntervalSec + ", StartCommand>" + this.jvmStartCommand);
        if (this.cli.hasOption(BootConstant.CLI_ENCRYPT)) {
            int updated = this.loadBootConfigFiles(ConfigUtil.ConfigLoadMode.cli_encrypt);
            System.out.println(BootConstant.BR + "\t " + updated + " config items have been encrypted in " + this.userSpecifiedConfigDir.getAbsolutePath());
            System.exit(0);
        } else if (this.cli.hasOption(BootConstant.CLI_DECRYPT)) {
            if (this.cli.hasOption(BootConstant.CLI_ADMIN_PWD_FILE)) {
                System.err.println(BootConstant.BR + "\t error: -" + BootConstant.CLI_ADMIN_PWD_FILE + " is not allowed for decryption, please private password with -" + BootConstant.CLI_ADMIN_PWD + " option when decrypt data");
                System.exit(1);
            }
            int updated = this.loadBootConfigFiles(ConfigUtil.ConfigLoadMode.cli_decrypt);
            System.out.println(BootConstant.BR + "\t " + updated + " config items have been decrypted in " + this.userSpecifiedConfigDir.getAbsolutePath());
            System.exit(0);
        }
        if (this.cli.hasOption(BootConstant.CLI_USE_IMPL)) {
            this.userSpecifiedImplTags.clear();
            String[] mockItemList = this.cli.getOptionValues(BootConstant.CLI_USE_IMPL);
            HashSet<String> mockInputValues = new HashSet<String>(Arrays.asList(mockItemList));
            mockInputValues.remove("");
            if (this.availableImplTagOptions.containsAll(mockInputValues)) {
                this.userSpecifiedImplTags.addAll(mockInputValues);
            } else {
                HashSet<String> invalidOptions = new HashSet<String>(mockInputValues);
                invalidOptions.removeAll(this.availableImplTagOptions);
                System.out.println("invalid -" + BootConstant.CLI_USE_IMPL + " value: " + FormatterUtil.toCSV(invalidOptions) + ", valid -" + BootConstant.CLI_USE_IMPL + " values: " + FormatterUtil.toCSV(this.availableImplTagOptions));
                System.exit(1);
            }
        }
        if (this.cli.hasOption(BootConstant.CLI_CONFIG_DEMO)) {
            int i = 0;
            for (String cfgName : this.scanedJExpressConfigs.keySet()) {
                Class c = ((SummerSingularity.ConfigMetadata)this.scanedJExpressConfigs.get((Object)cfgName)).cfgClass;
                try {
                    ConfigUtil.createConfigFile(c, this.userSpecifiedConfigDir, cfgName, true);
                }
                catch (IOException ex) {
                    System.out.println(ex + BootConstant.BR + "\tFailed to generate config file (" + cfgName + ") in " + this.userSpecifiedConfigDir.getAbsolutePath());
                    ex.printStackTrace();
                    System.exit(1);
                }
                ++i;
            }
            System.out.println("Total generated " + i + " configuration files in " + this.userSpecifiedConfigDir.getAbsolutePath());
            System.exit(0);
        }
        if (this.cli.hasOption(BootConstant.CLI_I8N)) {
            String language = this.cli.getOptionValue(BootConstant.CLI_I8N);
            this.userSpecifiedResourceBundle = Locale.forLanguageTag(language);
        } else {
            this.userSpecifiedResourceBundle = null;
        }
        I18n.init(this.getAddtionalI18n());
    }

    protected abstract Class getAddtionalI18n();

    protected int loadBootConfigFiles(ConfigUtil.ConfigLoadMode mode) {
        LinkedHashMap<String, JExpressConfig> configs = new LinkedHashMap<String, JExpressConfig>();
        int updated = 0;
        switch (mode) {
            case app_run: {
                if (!this.hasControllers) {
                    this.memo.append(BootConstant.BR).append("\t- cfg.loading.skip: no @Controller found, skip=").append(NioConfig.class.getSimpleName());
                    this.scanedJExpressConfigs.remove(NioConfig.class.getSimpleName());
                }
                if (this.hasGRPCImpl) break;
                this.memo.append(BootConstant.BR).append("\t- cfg.loading.skip: no gRPC Server stub found, skip=").append(GRPCServerConfig.class.getSimpleName());
                this.scanedJExpressConfigs.remove(GRPCServerConfig.class.getSimpleName());
            }
        }
        try {
            for (SummerSingularity.ConfigMetadata registeredAppConfig : this.scanedJExpressConfigs.values()) {
                if (this.isUserSpecifiedImplTags(registeredAppConfig.checkImplTagUsed) ^ registeredAppConfig.loadWhenImplTagUsed) continue;
                JExpressConfig instance = registeredAppConfig.instance;
                if (instance == null) {
                    instance = BootConfig.instance(registeredAppConfig.cfgClass);
                }
                this.memo.append(BootConstant.BR).append("\t- cfg.loading=").append(instance).append(", info=").append(registeredAppConfig);
                if (instance == null) continue;
                configs.put(registeredAppConfig.configFileName, instance);
            }
            updated = ConfigUtil.loadConfigs(mode, log, this.userSpecifiedResourceBundle, this.userSpecifiedConfigDir.toPath(), configs, this.userSpecifiedCfgMonitorIntervalSec, this.userSpecifiedConfigDir);
        }
        catch (Throwable ex) {
            log.fatal(I18n.info.unlaunched.format(this.userSpecifiedResourceBundle, new String[0]), ex);
            System.exit(1);
        }
        return updated;
    }

    protected boolean isUserSpecifiedImplTags(String mockItemName) {
        return this.userSpecifiedImplTags.contains(mockItemName);
    }

    protected void genesis(Class primaryClass, Set<String> userSpecifiedImplTags) {
        Module applicationModule;
        BootGuiceModule defaultModule = new BootGuiceModule(this, primaryClass, userSpecifiedImplTags, this.memo);
        ScanedGuiceModule scanedModule = new ScanedGuiceModule(this.scanedServiceBindingMap, userSpecifiedImplTags, this.channelHandlerNames, this.memo);
        Module bootModule = Modules.override((Module[])new Module[]{defaultModule}).with(new Module[]{scanedModule});
        Module module = applicationModule = this.userOverrideModule == null ? bootModule : Modules.override((Module[])new Module[]{bootModule}).with(new Module[]{this.userOverrideModule});
        if (this.userOverrideModule == null) {
            this.memo.append(BootConstant.BR).append("\t- init default Ioc @Conponent");
        } else {
            this.memo.append(BootConstant.BR).append("\t- init user overridden Ioc @Conponent via").append(this.userOverrideModule.getClass().getName());
        }
        this.guiceInjector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{applicationModule});
        this.scanImplementation_SummerRunner(this.guiceInjector);
        this.schedulerTriggers = this.scanAnnotation_Scheduled(this.guiceInjector, this.callerRootPackageNames);
    }

    @Inject
    protected void onGuiceInjectorCreated_ControllersInjected(@Controller Map<String, Object> controllers) {
        String pingURL = JaxRsRequestProcessorManager.registerControllers(controllers, this.memo);
        BackOffice.agent.setPingURL(pingURL);
    }

    protected void scanImplementation_SummerRunner(Injector injector) {
        Set<Class<SummerRunner>> summerRunner_ImplClasses = ReflectionUtil.getAllImplementationsByInterface(SummerRunner.class, this.callerRootPackageNames);
        TreeSet<Integer> orderSet = new TreeSet<Integer>();
        HashMap<Integer, ArrayList<SummerRunner>> orderMapping = new HashMap<Integer, ArrayList<SummerRunner>>();
        for (Class<SummerRunner> c : summerRunner_ImplClasses) {
            int order = 0;
            Order o = c.getAnnotation(Order.class);
            if (o != null) {
                order = o.value();
            }
            SummerRunner instance = (SummerRunner)injector.getInstance(c);
            orderSet.add(order);
            ArrayList<SummerRunner> sameOoderRunners = (ArrayList<SummerRunner>)orderMapping.get(order);
            if (sameOoderRunners == null) {
                sameOoderRunners = new ArrayList<SummerRunner>();
                orderMapping.put(order, sameOoderRunners);
            }
            sameOoderRunners.add(instance);
        }
        Iterator<Class<SummerRunner>> iterator = orderSet.iterator();
        while (iterator.hasNext()) {
            int order = (Integer)((Object)iterator.next());
            this.summerRunners.addAll((Collection)orderMapping.get(order));
        }
    }

    protected int scanAnnotation_Scheduled(Injector injector, String ... rootPackageNames) {
        int triggers = 0;
        Set<Class<Job>> classes = ReflectionUtil.getAllImplementationsByInterface(Job.class, rootPackageNames);
        if (!classes.isEmpty() && this.scheduler == null) {
            this.scheduler = (Scheduler)injector.getInstance(Scheduler.class);
        }
        for (Class<Job> c : classes) {
            try {
                triggers += QuartzUtil.addQuartzJob(this.scheduler, c);
            }
            catch (SchedulerException ex) {
                throw new RuntimeException("Filed to addQuartzJob for " + c, ex);
            }
        }
        return triggers;
    }
}

