/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.instrumentation;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.Timeout;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.util.BeanUtil;

public class HealthMonitor {
    private static final Logger log = LogManager.getLogger((String)HealthMonitor.class.getName());
    protected static NioConfig nioCfg = NioConfig.cfg;
    public static final String PROMPT = "\tSelf Inspection Result: ";
    private static PostOffice postOffice;
    private static boolean healthOk;
    private static boolean paused;
    private static String statusReason;
    private static boolean serviceAvaliable;

    public static void setPostOffice(PostOffice po) {
        postOffice = po;
    }

    private static void startHealthInspectionSingleton(int inspectionIntervalSeconds, HealthInspector healthInspector) {
        if (healthInspector == null || inspectionIntervalSeconds < 1) {
            log.debug(() -> "HealthInspection Skipped: healthInspector=" + healthInspector + ", inspectionIntervalSeconds=" + inspectionIntervalSeconds);
            return;
        }
        long i = HealthInspector.healthInspectorCounter.incrementAndGet();
        if (i > 1L) {
            log.debug(() -> "Duplicated HealthInspection Rejected: total=" + i);
            return;
        }
        long timeoutMs = BackOffice.agent.getProcessTimeoutMilliseconds();
        String timeoutDesc = BackOffice.agent.getProcessTimeoutAlertMessage();
        Runnable asyncTask = () -> {
            HealthInspector.healthInspectorCounter.incrementAndGet();
            try {
                boolean inspectionFailed;
                do {
                    StringBuilder sb = new StringBuilder();
                    sb.append(BootConstant.BR).append(PROMPT);
                    List<Err> errors = null;
                    try (Timeout a2 = Timeout.watch(healthInspector.getClass().getName() + ".ping()", timeoutMs).withDesc(timeoutDesc);){
                        errors = healthInspector.ping(new Object[0]);
                    }
                    catch (Throwable a2) {
                        // empty catch block
                    }
                    boolean bl = inspectionFailed = errors != null && !errors.isEmpty();
                    if (inspectionFailed) {
                        Object inspectionReport;
                        try {
                            inspectionReport = BeanUtil.toJson(errors, true, true);
                        }
                        catch (Throwable ex) {
                            inspectionReport = "total " + ex;
                        }
                        sb.append((String)inspectionReport);
                        sb.append(BootConstant.BR).append(", will inspect again in ").append(inspectionIntervalSeconds).append(" seconds");
                        log.warn((CharSequence)sb);
                        if (postOffice != null) {
                            postOffice.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Health Inspection Failed", sb.toString(), null, true);
                        }
                        try {
                            TimeUnit.SECONDS.sleep(inspectionIntervalSeconds);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    sb.append("passed");
                    HealthMonitor.setHealthStatus(true, sb.toString(), null);
                } while (inspectionFailed);
            }
            finally {
                HealthInspector.healthInspectorCounter.set(0L);
            }
        };
        if (i <= 1L) {
            try {
                BackOffice.execute(asyncTask);
            }
            catch (RejectedExecutionException ex2) {
                log.debug(() -> "Duplicated HealthInspection Rejected: " + ex2);
            }
        } else {
            log.debug("HealthInspection Skipped");
        }
    }

    public static void setHealthStatus(boolean newStatus, String reason, HealthInspector healthInspector) {
        HealthMonitor.setHealthStatus(newStatus, reason, healthInspector, nioCfg.getHealthInspectionIntervalSeconds());
    }

    public static void setHealthStatus(boolean newStatus, String reason, HealthInspector healthInspector, int healthInspectionIntervalSeconds) {
        boolean serviceStatusChanged = healthOk != newStatus;
        healthOk = newStatus;
        HealthMonitor.updateServiceStatus(serviceStatusChanged, reason);
        if (!healthOk && healthInspector != null) {
            HealthMonitor.startHealthInspectionSingleton(healthInspectionIntervalSeconds, healthInspector);
        }
    }

    public static void setPauseStatus(boolean newStatus, String reason) {
        boolean serviceStatusChanged = paused != newStatus;
        paused = newStatus;
        HealthMonitor.updateServiceStatus(serviceStatusChanged, reason);
    }

    private static void updateServiceStatus(boolean serviceStatusChanged, String reason) {
        statusReason = reason;
        boolean bl = serviceAvaliable = healthOk && !paused;
        if (serviceStatusChanged) {
            String content = "\n\t server status changed: paused=" + paused + ", OK=" + healthOk + ", serviceAvaliable=" + serviceAvaliable + "\n\t reason: " + reason;
            log.log(healthOk ? Level.WARN : Level.FATAL, content);
            if (postOffice != null) {
                postOffice.sendAlertAsync(SMTPClientConfig.cfg.getEmailToAppSupport(), "Service Status Changed", content, null, false);
            }
        }
    }

    public static boolean isServicePaused() {
        return paused;
    }

    public static boolean isServiceStatusOk() {
        return healthOk;
    }

    public static boolean isServiceAvaliable() {
        return serviceAvaliable;
    }

    public static String getServiceStatusReason() {
        return statusReason;
    }

    static {
        healthOk = true;
        paused = false;
        serviceAvaliable = true;
    }
}

