/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.quartz;

import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.listeners.JobListenerSupport;

public class FixedDelayJobListener
extends JobListenerSupport {
    public static final String FIXED_DELAY_VALUE = "FIXED_DELAY_VALUE";
    public static final String FIXED_DELAY_DESC = "FIXED_DELAY_DESC";
    private static final String JOB_LISTENER_NAME = FixedDelayJobListener.class.getSimpleName();

    public String getName() {
        return JOB_LISTENER_NAME;
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exception) {
        Date nextFireTime = context.getNextFireTime();
        if (nextFireTime != null) {
            return;
        }
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap jobData = jobDetail.getJobDataMap();
        if (!jobData.containsKey((Object)FIXED_DELAY_VALUE)) {
            return;
        }
        TriggerKey currentTriggerKey = context.getTrigger().getKey();
        try {
            SimpleTrigger st;
            Scheduler scheduler = context.getScheduler();
            if (scheduler.isShutdown()) {
                return;
            }
            Trigger currentTrigger = context.getTrigger();
            if (currentTrigger instanceof SimpleTrigger && ((st = (SimpleTrigger)currentTrigger).getRepeatInterval() != 0L || st.getRepeatCount() != 0 || st.getTimesTriggered() != 1 || st.getNextFireTime() != null)) {
                return;
            }
            long fixedDelay = (Long)jobData.getWrappedMap().get(FIXED_DELAY_VALUE);
            String desc = (String)jobData.getWrappedMap().get(FIXED_DELAY_DESC);
            Date nextTime = new Date(System.currentTimeMillis() + fixedDelay);
            JobKey jobKey = jobDetail.getKey();
            Trigger nextTrigger = TriggerBuilder.newTrigger().forJob(jobKey).withDescription(desc).withIdentity(currentTriggerKey).startAt(nextTime).build();
            scheduler.rescheduleJob(currentTriggerKey, nextTrigger);
            this.getLog().info(desc + " scheduled@" + nextTime);
        }
        catch (SchedulerException ex) {
            this.getLog().error("failed to reschedule the job with triger: {}", (Object)currentTriggerKey, (Object)ex);
        }
    }
}

