/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.quartz;

import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class GuiceJobFactory
extends SimpleJobFactory
implements JobFactory {
    private final Injector injector;
    private final Map<Class, Job> singletonJobs = new HashMap<Class, Job>();

    public GuiceJobFactory(Injector injector) {
        this.injector = injector;
    }

    public Job newJob(TriggerFiredBundle triggerFiredBundle, Scheduler scheduler) throws SchedulerException {
        Job job;
        Class jobClass = triggerFiredBundle.getJobDetail().getJobClass();
        if (jobClass.isAnnotationPresent(Singleton.class)) {
            job = this.singletonJobs.get(jobClass);
            if (job == null) {
                job = this.newInstance(triggerFiredBundle, scheduler, jobClass);
                this.singletonJobs.put(jobClass, job);
            }
        } else {
            job = this.newInstance(triggerFiredBundle, scheduler, jobClass);
        }
        return job;
    }

    protected Job newInstance(TriggerFiredBundle triggerFiredBundle, Scheduler scheduler, Class<? extends Job> jobClass) throws SchedulerException {
        Job job = super.newJob(triggerFiredBundle, scheduler);
        if (job == null) {
            try {
                job = jobClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new SchedulerException("Failed to create instance for " + jobClass, (Throwable)ex);
            }
        }
        if (job != null && this.injector != null) {
            this.injector.injectMembers((Object)job);
        }
        return job;
    }
}

