/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.Inject;
import com.google.inject.Module;
import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.quartz.SchedulerException;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.SummerBigBang;
import org.summerboot.jexpress.boot.SummerRunner;
import org.summerboot.jexpress.boot.config.ConfigChangeListener;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.boot.instrumentation.Timeout;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgr;
import org.summerboot.jexpress.i18n.I18n;
import org.summerboot.jexpress.integration.quartz.QuartzUtil;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import org.summerboot.jexpress.nio.grpc.GRPCServer;
import org.summerboot.jexpress.nio.grpc.GRPCServerConfig;
import org.summerboot.jexpress.nio.grpc.StatusReporter;
import org.summerboot.jexpress.nio.server.NioChannelInitializer;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioServer;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.util.ApplicationUtil;
import org.summerboot.jexpress.util.BeanUtil;

public abstract class SummerApplication
extends SummerBigBang {
    @Inject
    protected ConfigChangeListener configChangeListener;
    @Inject
    protected InstrumentationMgr instrumentationMgr;
    @Inject
    protected HealthInspector healthInspector;
    protected NioServer httpServer;
    protected List<GRPCServer> gRPCServerList = new ArrayList<GRPCServer>();
    @Inject
    protected PostOffice postOffice;
    private boolean memoLogged = false;

    public static <T extends SummerApplication> T run() {
        Module userOverrideModule = null;
        return SummerApplication.run(userOverrideModule);
    }

    public static void run(Class callerClass, String[] args) {
        Module userOverrideModule = null;
        SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Module userOverrideModule) {
        StackTraceElement[] stackTrace;
        String[] mainCommand = ApplicationUtil.getApplicationArgs();
        int size = mainCommand.length;
        String[] args = size > 0 ? new String[size - 1] : ApplicationUtil.EMPTY_ARGS;
        String mainClassName = mainCommand[0];
        for (int i = 1; i < size; ++i) {
            args[i - 1] = mainCommand[i];
        }
        Class<?> callerClass = null;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            try {
                callerClass = Class.forName(stackTraceElement.getClassName());
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            try {
                callerClass = Class.forName(mainClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            throw new RuntimeException("Failed to find the caller class");
        }
        return SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(String[] args) {
        Module userOverrideModule = null;
        return SummerApplication.run(userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Module userOverrideModule, String[] args) {
        StackTraceElement[] stackTrace;
        Class<?> callerClass = null;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            try {
                callerClass = Class.forName(stackTraceElement.getClassName());
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            throw new RuntimeException("Failed to find the caller class");
        }
        return SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Class callerClass, Module userOverrideModule, String argsStr) {
        String[] args = argsStr.split(" ");
        return SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Class callerClass, Module userOverrideModule, String[] args) {
        SummerApplication app = new SummerApplication(callerClass, userOverrideModule, args){};
        app.start();
        return (T)app;
    }

    public static <T extends SummerApplication> T unittest(Class callerClass, Module userOverrideModule, String argsStr) {
        String[] args = argsStr.split(" ");
        return SummerApplication.unittest(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T unittest(Class callerClass, Module userOverrideModule, String ... args) {
        SummerApplication app = new SummerApplication(callerClass, userOverrideModule, args){};
        app.traceConfig();
        return (T)app;
    }

    private SummerApplication(Class callerClass, Module userOverrideModule, String ... args) {
        super(callerClass, userOverrideModule, args);
    }

    public List<GRPCServer> getgRPCServers() {
        return this.gRPCServerList;
    }

    @Override
    protected Class getAddtionalI18n() {
        return null;
    }

    protected void traceConfig() {
        if (!this.memoLogged) {
            this.memo.append(BootConstant.BR).append("\t- sys.prop.").append(BootConstant.SYS_PROP_LOGID).append(" = ").append(System.getProperty(BootConstant.SYS_PROP_LOGID));
            this.memo.append(BootConstant.BR).append("\t- sys.prop.").append(BootConstant.SYS_PROP_LOGFILEPATH).append(" = ").append(System.getProperty(BootConstant.SYS_PROP_LOGFILEPATH));
            this.memo.append(BootConstant.BR).append("\t- sys.prop.").append(BootConstant.SYS_PROP_LOGFILENAME).append(" = ").append(System.getProperty(BootConstant.SYS_PROP_LOGFILENAME));
            this.memo.append(BootConstant.BR).append("\t- sys.prop.").append(BootConstant.SYS_PROP_SERVER_NAME).append(" = ").append(System.getProperty(BootConstant.SYS_PROP_SERVER_NAME));
            this.memo.append(BootConstant.BR).append("\t- sys.prop.").append(BootConstant.SYS_PROP_APP_PACKAGE_NAME).append(" = ").append(System.getProperty(BootConstant.SYS_PROP_APP_PACKAGE_NAME));
            this.memo.append(BootConstant.BR).append("\t- start: PostOffice=").append(this.postOffice.getClass().getName());
            this.memo.append(BootConstant.BR).append("\t- start: HealthInspector=").append(this.healthInspector.getClass().getName());
            this.memo.append(BootConstant.BR).append("\t- start: InstrumentationMgr=").append(this.instrumentationMgr.getClass().getName());
            this.memoLogged = true;
        }
        log.trace(() -> this.memo.toString());
    }

    public void start() {
        this.traceConfig();
        if (this.configChangeListener != null) {
            ConfigUtil.setConfigChangeListener(this.configChangeListener);
        }
        SMTPClientConfig smtpCfg = SMTPClientConfig.cfg;
        if (this.postOffice != null) {
            HealthMonitor.setPostOffice(this.postOffice);
            this.postOffice.setAppVersion(this.appVersion);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.postOffice != null) {
                    this.postOffice.sendAlertSync(smtpCfg.getEmailToAppSupport(), "Shutdown at " + OffsetDateTime.now() + " - " + this.appVersion, "EOM", null, false);
                }
            }, "ShutdownHook.BootApp"));
        }
        try {
            Timeout a;
            if (this.instrumentationMgr != null) {
                this.instrumentationMgr.start("SummerBoot.jExpress 2.3.12");
            }
            SummerRunner.RunnerContext context = new SummerRunner.RunnerContext(this.cli, this.userSpecifiedConfigDir, this.guiceInjector, this.healthInspector, this.postOffice);
            for (SummerRunner summerRunner : this.summerRunners) {
                summerRunner.run(context);
            }
            if (this.schedulerTriggers > 0) {
                this.scheduler.start();
                StringBuilder sb = new StringBuilder();
                sb.append("Scheduled jobs next fire time by ").append(this.schedulerTriggers).append(" triggers: ");
                QuartzUtil.getNextFireTimes(this.scheduler, sb);
                log.info(() -> sb.toString());
            }
            long timeoutMs = BackOffice.agent.getProcessTimeoutMilliseconds();
            String timeoutDesc = BackOffice.agent.getProcessTimeoutAlertMessage();
            StringBuilder sb = new StringBuilder();
            sb.append(BootConstant.BR).append("\tSelf Inspection Result: ");
            if (this.healthInspector != null) {
                a = Timeout.watch(this.healthInspector.getClass().getName() + ".ping()", timeoutMs).withDesc(timeoutDesc);
                try {
                    Object inspectionReport;
                    List<Err> errors = this.healthInspector.ping(log);
                    if (errors == null || errors.isEmpty()) {
                        sb.append("passed");
                        log.info((CharSequence)sb);
                    }
                    try {
                        inspectionReport = BeanUtil.toJson(errors, true, true);
                    }
                    catch (Throwable ex) {
                        inspectionReport = "total " + errors.size();
                    }
                    sb.append((String)inspectionReport);
                    HealthMonitor.setHealthStatus(false, sb.toString(), this.healthInspector);
                }
                finally {
                    if (a != null) {
                        a.close();
                    }
                }
            } else {
                sb.append("skipped");
                log.warn((CharSequence)sb);
            }
            log.trace("hasGRPCImpl.bs=" + this.gRPCBindableServiceImplClasses);
            log.trace("hasGRPCImpl.ssd=" + this.gRPCServerServiceDefinitionImplClasses);
            if (this.hasGRPCImpl) {
                ServerInterceptor serverInterceptor = (ServerInterceptor)this.guiceInjector.getInstance(ServerInterceptor.class);
                GRPCServerConfig gRPCCfg = GRPCServerConfig.cfg;
                List<InetSocketAddress> bindingAddresses = gRPCCfg.getBindingAddresses();
                NIOStatusListener nioListener = (NIOStatusListener)this.guiceInjector.getInstance(NIOStatusListener.class);
                for (InetSocketAddress bindingAddress : bindingAddresses) {
                    String host = bindingAddress.getAddress().getHostAddress();
                    int port = bindingAddress.getPort();
                    try (Timeout a2 = Timeout.watch("starting gRPCServer at " + host + ":" + port, timeoutMs).withDesc(timeoutDesc);){
                        BindableService impl;
                        GRPCServer gRPCServer = new GRPCServer(host, port, gRPCCfg.getKmf(), gRPCCfg.getTmf(), serverInterceptor, gRPCCfg.getTpe(), nioListener);
                        ServerBuilder serverBuilder = gRPCServer.getServerBuilder();
                        for (Class c : this.gRPCBindableServiceImplClasses) {
                            impl = (BindableService)this.guiceInjector.getInstance(c);
                            serverBuilder.addService(impl);
                            if (!(impl instanceof StatusReporter)) continue;
                            ((StatusReporter)impl).setCounter(gRPCServer.getServiceCounter());
                        }
                        for (Class c : this.gRPCServerServiceDefinitionImplClasses) {
                            impl = (ServerServiceDefinition)this.guiceInjector.getInstance(c);
                            serverBuilder.addService((ServerServiceDefinition)impl);
                        }
                        if (gRPCCfg.isAutoStart()) {
                            gRPCServer.start();
                        }
                        this.gRPCServerList.add(gRPCServer);
                    }
                }
            }
            log.trace("hasControllers=" + this.hasControllers);
            if (this.hasControllers && NioConfig.cfg.isAutoStart()) {
                a = Timeout.watch("starting Web Server", timeoutMs).withDesc(timeoutDesc);
                try {
                    NioChannelInitializer channelInitializer = (NioChannelInitializer)((Object)this.guiceInjector.getInstance(NioChannelInitializer.class));
                    NIOStatusListener nioListener = (NIOStatusListener)this.guiceInjector.getInstance(NIOStatusListener.class);
                    this.httpServer = new NioServer(channelInitializer.init(this.guiceInjector, this.channelHandlerNames), nioListener);
                    this.httpServer.bind(NioConfig.cfg);
                }
                finally {
                    if (a != null) {
                        a.close();
                    }
                }
            }
            log.info(() -> I18n.info.launched.format(this.userSpecifiedResourceBundle, this.appVersion + " pid#" + BootConstant.PID));
            String fullConfigInfo = sb.toString();
            if (this.postOffice != null) {
                this.postOffice.sendAlertAsync(smtpCfg.getEmailToAppSupport(), "Started at " + OffsetDateTime.now(), fullConfigInfo, null, false);
            }
        }
        catch (BindException ex) {
            log.fatal(ex + BootConstant.BR + BackOffice.agent.getPortInUseAlertMessage());
            System.exit(1);
        }
        catch (Throwable ex) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            if (cause instanceof BindException) {
                log.fatal(ex + BootConstant.BR + BackOffice.agent.getPortInUseAlertMessage());
            } else {
                log.fatal(I18n.info.unlaunched.format(this.userSpecifiedResourceBundle, new String[0]), ex);
            }
            System.exit(1);
        }
    }

    public void shutdown() {
        if (this.gRPCServerList != null && !this.gRPCServerList.isEmpty()) {
            for (GRPCServer gRPCServer : this.gRPCServerList) {
                gRPCServer.shutdown();
            }
        }
        if (this.httpServer != null) {
            this.httpServer.shutdown();
        }
        if (this.instrumentationMgr != null) {
            this.instrumentationMgr.shutdown();
        }
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown();
            }
            catch (SchedulerException ex) {
                log.warn("Failed to shoutdown scheduler", (Throwable)ex);
            }
        }
    }
}

