/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.nio.server.ErrorAuditor;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioCounter;
import org.summerboot.jexpress.nio.server.NioHttpUtil;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ProcessorSettings;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.nio.server.ws.rs.JaxRsRequestProcessorManager;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.TimeUtil;

@ChannelHandler.Sharable
public abstract class NioServerHttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest>
implements ErrorAuditor {
    protected Logger log = LogManager.getLogger(this.getClass());
    protected ZoneId zoneId = ZoneId.systemDefault();
    protected static NioConfig nioCfg = NioConfig.cfg;
    protected String protectedContectReplaceWith = "***";
    private final String me = ", hdl=" + this.toString();

    public NioServerHttpRequestHandler() {
        super(FullHttpRequest.class, false);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.log.trace(() -> evt + " - " + this.info(ctx));
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        long tc = NioCounter.COUNTER_ACTIVE_CHANNEL.incrementAndGet();
        this.log.trace(() -> tc + " - " + this.info(ctx));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        NioCounter.COUNTER_ACTIVE_CHANNEL.decrementAndGet();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable ex) {
        if (ex instanceof DecoderException) {
            this.log.warn(ctx.channel().remoteAddress() + ": " + ex);
        } else {
            this.log.warn(ctx.channel().remoteAddress() + ": " + ex, ex);
        }
        if (ex instanceof OutOfMemoryError) {
            ctx.close();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.log.trace(() -> this.info(ctx));
        ctx.flush();
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        long start = System.currentTimeMillis();
        if (!req.decoderResult().isSuccess()) {
            NioHttpUtil.sendError(ctx, HttpResponseStatus.BAD_REQUEST, BootErrorCode.NIO_REQUEST_BAD_ENCODING, "failed to decode request", null);
            return;
        }
        NioCounter.COUNTER_HIT.incrementAndGet();
        long hitIndex = NioCounter.COUNTER_BIZ_HIT.incrementAndGet();
        String txId = BootConstant.APP_ID + "-" + hitIndex;
        long dataSize = req.content().capacity();
        HttpMethod httpMethod = req.method();
        String httpRequestUri = req.uri();
        boolean isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
        String requestMetaInfo = this.requestMetaInfo(ctx, txId, httpMethod, httpRequestUri, isKeepAlive, dataSize);
        this.log.debug(() -> requestMetaInfo);
        HttpHeaders requestHeaders = req.headers();
        String httpPostRequestBody = HttpMethod.POST.equals((Object)httpMethod) || HttpMethod.PUT.equals((Object)httpMethod) || HttpMethod.PATCH.equals((Object)httpMethod) || HttpMethod.DELETE.equals((Object)httpMethod) ? NioHttpUtil.getHttpPostBodyString(req) : null;
        ReferenceCountUtil.release((Object)req);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(httpRequestUri, StandardCharsets.UTF_8);
        Runnable asyncTask = () -> {
            block53: {
                long queuingTime = System.currentTimeMillis() - start;
                ServiceContext context = ServiceContext.build(ctx, txId, hitIndex, start, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody).responseHeaders(nioCfg.getServerDefaultResponseHeaders()).clientAcceptContentType(requestHeaders.get((CharSequence)HttpHeaderNames.ACCEPT));
                String acceptCharset = requestHeaders.get((CharSequence)HttpHeaderNames.ACCEPT_CHARSET);
                if (StringUtils.isNotBlank((CharSequence)acceptCharset)) {
                    context.charsetName(acceptCharset);
                }
                long responseContentLength = -1L;
                Throwable ioEx = null;
                long processTime = -1L;
                ProcessorSettings processorSettings = null;
                processorSettings = this.service(ctx, requestHeaders, httpMethod, queryStringDecoder.path(), queryStringDecoder.parameters(), httpPostRequestBody, context);
                processTime = System.currentTimeMillis() - start;
                responseContentLength = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this, processorSettings);
                context.poi("service.end");
                NioCounter.COUNTER_SENT.incrementAndGet();
                long responseTime = System.currentTimeMillis() - start;
                String report = null;
                try {
                    boolean overtime = responseTime > nioCfg.getBizTimeoutWarnThresholdMs();
                    HttpResponseStatus status = context.status();
                    Level level = context.level();
                    if ((overtime || status.code() >= 400) && level.isLessSpecificThan(Level.WARN)) {
                        level = Level.WARN;
                    }
                    if (this.log.isEnabled(level)) {
                        ProcessorSettings.LogSettings logSettings;
                        Object caller = context.caller();
                        ServiceError error2 = context.error();
                        int errorCount = 0;
                        if (error2 != null) {
                            errorCount = error2.getErrors() == null ? 1 : Math.max(1, error2.getErrors().size());
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append("request_").append(txId).append(".caller=").append((Object)(caller == null ? context.callerId() : caller));
                        sb.append("\n\t").append(requestMetaInfo).append("\n\tresponse_").append(txId).append("=").append(status).append(", error=").append(errorCount).append(", FullHttpRequest.t0=").append(TimeUtil.toOffsetDateTime(start, this.zoneId)).append(", queuing=").append(queuingTime).append("ms, process=").append(processTime);
                        if (overtime) {
                            sb.append("ms, response.ot=");
                        } else {
                            sb.append("ms, response=");
                        }
                        sb.append(responseTime).append("ms, cont.len=").append(responseContentLength).append("bytes");
                        context.reportPOI(nioCfg, sb);
                        this.verboseClientServerCommunication(nioCfg, requestHeaders, httpPostRequestBody, context, sb);
                        context.reportMemo(sb);
                        context.reportError(sb);
                        sb.append(BootConstant.BR);
                        report = sb.toString();
                        if (processorSettings != null && (logSettings = processorSettings.getLogSettings()) != null) {
                            List<String> protectedJsonArrayFields;
                            List<String> protectedJsonStringFields;
                            List<String> protectedJsonNumberFields = logSettings.getProtectedJsonNumberFields();
                            if (protectedJsonNumberFields != null) {
                                for (Object protectedJsonNumberField : protectedJsonNumberFields) {
                                    report = FormatterUtil.protectJsonNumber(report, (String)protectedJsonNumberField, this.protectedContectReplaceWith);
                                }
                            }
                            if ((protectedJsonStringFields = logSettings.getProtectedJsonStringFields()) != null) {
                                for (Object protectedJsonStringField : protectedJsonStringFields) {
                                    report = FormatterUtil.protectJsonString(report, (String)protectedJsonStringField, this.protectedContectReplaceWith);
                                }
                            }
                            if ((protectedJsonArrayFields = logSettings.getProtectedJsonArrayFields()) != null) {
                                for (String protectedJsonArrayField : protectedJsonArrayFields) {
                                    report = FormatterUtil.protectJsonArray(report, protectedJsonArrayField, this.protectedContectReplaceWith);
                                }
                            }
                        }
                        report = this.beforeLogging(report, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, ioEx);
                        this.log.log(level, report);
                    }
                }
                catch (Throwable ex) {
                    this.log.fatal("logging failed \n{}", report, (Object)ex);
                }
                try {
                    this.afterLogging(report, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, ioEx);
                }
                catch (Throwable ex) {
                    this.log.error("afterLogging failed", ex);
                }
                break block53;
                catch (Throwable ex) {
                    ioEx = ex;
                    Err<String> e = new Err<String>(BootErrorCode.NIO_UNEXPECTED_SERVICE_FAILURE, null, null, ex, "Failed to send context to client");
                    context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR).level(Level.FATAL);
                    responseContentLength = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this, processorSettings);
                    NioCounter.COUNTER_SENT.incrementAndGet();
                    responseTime = System.currentTimeMillis() - start;
                    report = null;
                    try {
                        boolean overtime = responseTime > nioCfg.getBizTimeoutWarnThresholdMs();
                        HttpResponseStatus status = context.status();
                        Level level = context.level();
                        if ((overtime || status.code() >= 400) && level.isLessSpecificThan(Level.WARN)) {
                            level = Level.WARN;
                        }
                        if (this.log.isEnabled(level)) {
                            ProcessorSettings.LogSettings logSettings;
                            Object caller = context.caller();
                            ServiceError error3 = context.error();
                            int errorCount = 0;
                            if (error3 != null) {
                                errorCount = error3.getErrors() == null ? 1 : Math.max(1, error3.getErrors().size());
                            }
                            StringBuilder sb = new StringBuilder();
                            sb.append("request_").append(txId).append(".caller=").append((Object)(caller == null ? context.callerId() : caller));
                            sb.append("\n\t").append(requestMetaInfo).append("\n\tresponse_").append(txId).append("=").append(status).append(", error=").append(errorCount).append(", FullHttpRequest.t0=").append(TimeUtil.toOffsetDateTime(start, this.zoneId)).append(", queuing=").append(queuingTime).append("ms, process=").append(processTime);
                            if (overtime) {
                                sb.append("ms, response.ot=");
                            } else {
                                sb.append("ms, response=");
                            }
                            sb.append(responseTime).append("ms, cont.len=").append(responseContentLength).append("bytes");
                            context.reportPOI(nioCfg, sb);
                            this.verboseClientServerCommunication(nioCfg, requestHeaders, httpPostRequestBody, context, sb);
                            context.reportMemo(sb);
                            context.reportError(sb);
                            sb.append(BootConstant.BR);
                            report = sb.toString();
                            if (processorSettings != null && (logSettings = processorSettings.getLogSettings()) != null) {
                                List<String> protectedJsonArrayFields;
                                Object protectedJsonNumberField;
                                Object protectedJsonStringFields;
                                List<String> protectedJsonNumberFields = logSettings.getProtectedJsonNumberFields();
                                if (protectedJsonNumberFields != null) {
                                    protectedJsonStringFields = protectedJsonNumberFields.iterator();
                                    while (protectedJsonStringFields.hasNext()) {
                                        protectedJsonNumberField = (String)protectedJsonStringFields.next();
                                        report = FormatterUtil.protectJsonNumber(report, (String)protectedJsonNumberField, this.protectedContectReplaceWith);
                                    }
                                }
                                if ((protectedJsonStringFields = logSettings.getProtectedJsonStringFields()) != null) {
                                    protectedJsonNumberField = protectedJsonStringFields.iterator();
                                    while (protectedJsonNumberField.hasNext()) {
                                        String protectedJsonStringField = (String)protectedJsonNumberField.next();
                                        report = FormatterUtil.protectJsonString(report, protectedJsonStringField, this.protectedContectReplaceWith);
                                    }
                                }
                                if ((protectedJsonArrayFields = logSettings.getProtectedJsonArrayFields()) != null) {
                                    for (String protectedJsonArrayField : protectedJsonArrayFields) {
                                        report = FormatterUtil.protectJsonArray(report, protectedJsonArrayField, this.protectedContectReplaceWith);
                                    }
                                }
                            }
                            report = this.beforeLogging(report, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, ioEx);
                            this.log.log(level, report);
                        }
                    }
                    catch (Throwable ex2) {
                        this.log.fatal("logging failed \n{}", report, (Object)ex2);
                    }
                    try {
                        this.afterLogging(report, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, ioEx);
                    }
                    catch (Throwable ex3) {
                        this.log.error("afterLogging failed", ex3);
                    }
                    catch (Throwable throwable) {
                        NioCounter.COUNTER_SENT.incrementAndGet();
                        long responseTime2 = System.currentTimeMillis() - start;
                        String report2 = null;
                        try {
                            boolean overtime = responseTime2 > nioCfg.getBizTimeoutWarnThresholdMs();
                            HttpResponseStatus status = context.status();
                            Level level = context.level();
                            if ((overtime || status.code() >= 400) && level.isLessSpecificThan(Level.WARN)) {
                                level = Level.WARN;
                            }
                            if (this.log.isEnabled(level)) {
                                ProcessorSettings.LogSettings logSettings;
                                Object caller = context.caller();
                                ServiceError error4 = context.error();
                                int errorCount = 0;
                                if (error4 != null) {
                                    errorCount = error4.getErrors() == null ? 1 : Math.max(1, error4.getErrors().size());
                                }
                                StringBuilder sb = new StringBuilder();
                                sb.append("request_").append(txId).append(".caller=").append((Object)(caller == null ? context.callerId() : caller));
                                sb.append("\n\t").append(requestMetaInfo).append("\n\tresponse_").append(txId).append("=").append(status).append(", error=").append(errorCount).append(", FullHttpRequest.t0=").append(TimeUtil.toOffsetDateTime(start, this.zoneId)).append(", queuing=").append(queuingTime).append("ms, process=").append(processTime);
                                if (overtime) {
                                    sb.append("ms, response.ot=");
                                } else {
                                    sb.append("ms, response=");
                                }
                                sb.append(responseTime2).append("ms, cont.len=").append(responseContentLength).append("bytes");
                                context.reportPOI(nioCfg, sb);
                                this.verboseClientServerCommunication(nioCfg, requestHeaders, httpPostRequestBody, context, sb);
                                context.reportMemo(sb);
                                context.reportError(sb);
                                sb.append(BootConstant.BR);
                                report2 = sb.toString();
                                if (processorSettings != null && (logSettings = processorSettings.getLogSettings()) != null) {
                                    List<String> protectedJsonArrayFields;
                                    List<String> protectedJsonStringFields;
                                    List<String> protectedJsonNumberFields = logSettings.getProtectedJsonNumberFields();
                                    if (protectedJsonNumberFields != null) {
                                        for (Object protectedJsonNumberField : protectedJsonNumberFields) {
                                            report2 = FormatterUtil.protectJsonNumber(report2, (String)protectedJsonNumberField, this.protectedContectReplaceWith);
                                        }
                                    }
                                    if ((protectedJsonStringFields = logSettings.getProtectedJsonStringFields()) != null) {
                                        for (String protectedJsonStringField : protectedJsonStringFields) {
                                            report2 = FormatterUtil.protectJsonString(report2, protectedJsonStringField, this.protectedContectReplaceWith);
                                        }
                                    }
                                    if ((protectedJsonArrayFields = logSettings.getProtectedJsonArrayFields()) != null) {
                                        for (String protectedJsonArrayField : protectedJsonArrayFields) {
                                            report2 = FormatterUtil.protectJsonArray(report2, protectedJsonArrayField, this.protectedContectReplaceWith);
                                        }
                                    }
                                }
                                report2 = this.beforeLogging(report2, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime2, responseContentLength, ioEx);
                                this.log.log(level, report2);
                            }
                        }
                        catch (Throwable ex4) {
                            this.log.fatal("logging failed \n{}", report2, (Object)ex4);
                        }
                        try {
                            this.afterLogging(report2, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime2, responseContentLength, ioEx);
                        }
                        catch (Throwable ex5) {
                            this.log.error("afterLogging failed", ex5);
                        }
                        throw throwable;
                    }
                }
            }
        };
        try {
            nioCfg.getBizExecutor().execute(asyncTask);
        }
        catch (RejectedExecutionException ex) {
            long queuingTime = System.currentTimeMillis() - start;
            ServiceContext context = ServiceContext.build(ctx, txId, hitIndex, start, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody).responseHeaders(nioCfg.getServerDefaultResponseHeaders()).clientAcceptContentType(requestHeaders.get((CharSequence)HttpHeaderNames.ACCEPT));
            Err<String> e = new Err<String>(BootErrorCode.NIO_TOO_MANY_REQUESTS, null, null, (Throwable)ex, "Too many request, try again later");
            context.error(e).status(HttpResponseStatus.TOO_MANY_REQUESTS).level(Level.FATAL);
            long responseContentLength = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this, null);
            StringBuilder sb = new StringBuilder();
            sb.append("request_").append(txId).append("=").append(ex.toString()).append("ms\n\t").append(requestMetaInfo).append("\n\tresponse#").append(txId).append("=").append(context.status()).append(", errorCode=").append(e.getErrorCode()).append(", queuing=").append(queuingTime).append("ms, cont.len=").append(responseContentLength).append("\n\t1req.headers=").append(requestHeaders).append("\n\t4resp.body=").append(context.txt());
            this.log.fatal(sb.toString());
        }
        catch (Throwable ex) {
            long queuingTime = System.currentTimeMillis() - start;
            ServiceContext context = ServiceContext.build(ctx, txId, hitIndex, start, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody).responseHeaders(nioCfg.getServerDefaultResponseHeaders()).clientAcceptContentType(requestHeaders.get((CharSequence)HttpHeaderNames.ACCEPT));
            Err<String> e = new Err<String>(BootErrorCode.NIO_UNEXPECTED_EXECUTOR_FAILURE, null, null, ex, "NIO unexpected executor failure");
            context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR).level(Level.FATAL);
            long responseContentLength = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this, null);
            StringBuilder sb = new StringBuilder();
            sb.append("request_").append(txId).append("=").append(ex.toString()).append("ms\n\t").append(requestMetaInfo).append("\n\tresponse#").append(txId).append("=").append(context.status()).append(", errorCode=").append(e.getErrorCode()).append(", queuing=").append(queuingTime).append("ms, cont.len=").append(responseContentLength).append("\n\t1req.headers=").append(requestHeaders).append("\n\t4resp.body=").append(context.txt());
            this.log.fatal(sb.toString());
        }
    }

    private String info(ChannelHandlerContext ctx) {
        return ", chn=" + ctx.channel() + ", ctx=" + ctx.hashCode() + this.me;
    }

    private String requestMetaInfo(ChannelHandlerContext ctx, String hitIndex, HttpMethod httpMethod, String httpRequestUri, boolean isKeepAlive, long dataSize) {
        return "request_" + hitIndex + "=" + httpMethod + " " + httpRequestUri + ", dataSize=" + dataSize + ", KeepAlive=" + isKeepAlive + ", chn=" + ctx.channel() + ", ctx=" + ctx.hashCode() + this.me;
    }

    private void verboseClientServerCommunication(NioConfig cfg, HttpHeaders httpHeaders, String httpPostRequestBody, ServiceContext context, StringBuilder sb) {
        boolean isInFilter = false;
        Object caller = context.caller();
        switch (cfg.getFilterUserType()) {
            case ignore: {
                isInFilter = true;
                break;
            }
            case uid: {
                if (!StringUtils.isNotBlank((CharSequence)context.callerId())) break;
                isInFilter = cfg.getFilterCallerNameSet().contains(context.callerId());
                break;
            }
            case id: {
                if (caller == null || caller.getId() == null) break;
                Long target2 = caller.getId().longValue();
                Set<Long> s = cfg.getFilterCallerIdSet();
                if (s == null) {
                    isInFilter = target2 >= cfg.getFilterCallerIdFrom() && target2 <= cfg.getFilterCallerIdTo();
                    break;
                }
                isInFilter = s.contains(target2);
                break;
            }
            case group: {
                if (caller == null) break;
                isInFilter = cfg.getFilterCallerNameSet().stream().anyMatch(target -> caller.isInGroup((String)target));
                break;
            }
            case role: {
                if (caller == null) break;
                isInFilter = cfg.getFilterCallerNameSet().stream().anyMatch(target -> caller.isInRole((String)target));
            }
        }
        if (!isInFilter) {
            return;
        }
        isInFilter = false;
        Set<Long> s = cfg.getFilterCodeSet();
        block8 : switch (cfg.getFilterCodeType()) {
            case all: {
                isInFilter = true;
                break;
            }
            case ignore: {
                isInFilter = false;
                break;
            }
            case HttpStatusCode: {
                long target3 = context.status().code();
                if (s == null) {
                    isInFilter = target3 >= cfg.getFilterCodeRangeFrom() && target3 <= cfg.getFilterCodeRangeTo();
                    break;
                }
                isInFilter = s.contains(target3);
                break;
            }
            case AppErrorCode: {
                ServiceError e = context.error();
                if (e == null) break;
                for (Err j : e.getErrors()) {
                    String errorCode = j.getErrorCode();
                    try {
                        long target4 = Integer.parseInt(errorCode);
                        isInFilter = s == null ? target4 >= cfg.getFilterCodeRangeFrom() && target4 <= cfg.getFilterCodeRangeTo() : s.contains(target4);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!isInFilter) continue;
                    break block8;
                }
                break;
            }
        }
        if (!isInFilter) {
            return;
        }
        sb.append("\n\t1.client_req.headers=").append(context.logRequestHeader() && cfg.isVerboseReqHeader() ? httpHeaders : "***");
        sb.append("\n\t2.client_req.body=").append(context.logRequestBody() && cfg.isVerboseReqContent() ? httpPostRequestBody : "***");
        sb.append("\n\t3.server_resp.headers=").append(context.logResponseHeader() && cfg.isVerboseRespHeader() ? context.responseHeaders() : "***");
        sb.append("\n\t4.server_resp.body=").append(context.logResponseBody() && cfg.isVerboseRespContent() ? context.txt() : "***");
    }

    protected abstract ProcessorSettings service(ChannelHandlerContext var1, HttpHeaders var2, HttpMethod var3, String var4, Map<String, List<String>> var5, String var6, ServiceContext var7);

    protected abstract String beforeLogging(String var1, HttpHeaders var2, HttpMethod var3, String var4, String var5, ServiceContext var6, long var7, long var9, long var11, long var13, Throwable var15) throws Exception;

    protected abstract void afterLogging(String var1, HttpHeaders var2, HttpMethod var3, String var4, String var5, ServiceContext var6, long var7, long var9, long var11, long var13, Throwable var15) throws Exception;

    protected RequestProcessor getRequestProcessor(HttpMethod httptMethod, String httpRequestPath) {
        return JaxRsRequestProcessorManager.getRequestProcessor(httptMethod, httpRequestPath);
    }
}

