/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioHttpUtil;
import org.summerboot.jexpress.nio.server.ResponseEncoder;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.security.auth.Caller;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ServiceContext {
    private static final NioConfig nioCfg = NioConfig.cfg;
    private final SocketAddress localIP;
    private final SocketAddress remoteIP;
    private final HttpMethod requesMethod;
    private final String requesURI;
    private final HttpHeaders requestHeaders;
    private final String requestBody;
    private final String txId;
    private final long hit;
    private final long startTs;
    private Caller caller;
    private String callerId;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private boolean autoConvertBlank200To204 = true;
    private HttpHeaders responseHeaders;
    private ResponseEncoder responseEncoder = null;
    private String contentType;
    private String clientAcceptContentType;
    private String charsetName;
    private byte[] data;
    private String txt = "";
    private File file;
    private boolean downloadMode = true;
    private String redirect;
    private final List<POI> poi = new ArrayList<POI>();
    private List<Memo> memo;
    private Map<String, Object> attributes;
    private ServiceError serviceError;
    private Throwable cause;
    private Level level = Level.INFO;
    private boolean logRequestHeader = true;
    private boolean logResponseHeader = true;
    private boolean logRequestBody = true;
    private boolean logResponseBody = true;

    public static ServiceContext build(long hit) {
        return ServiceContext.build(BootConstant.APP_ID + "-" + hit, hit);
    }

    public static ServiceContext build(String txId, long hit) {
        return new ServiceContext(null, txId, hit, System.currentTimeMillis(), null, null, null, null);
    }

    public static ServiceContext build(ChannelHandlerContext ctx, String txId, long hit, long startTs, HttpHeaders requestHeaders, HttpMethod requesMethod, String requesURI, String requestBody) {
        return new ServiceContext(ctx, txId, hit, startTs, requestHeaders, requesMethod, requesURI, requestBody);
    }

    public String toString() {
        return "ServiceContext{status=" + this.status + ", responseHeaders=" + this.responseHeaders + ", contentType=" + this.contentType + ", data=" + this.data + ", txt=" + this.txt + ", errors=" + this.serviceError + ", level=" + this.level + ", logReqHeader=" + this.logRequestHeader + ", logRespHeader=" + this.logResponseHeader + ", logReqContent=" + this.logRequestBody + ", logRespContent=" + this.logResponseBody + "}";
    }

    private ServiceContext(ChannelHandlerContext ctx, String txId, long hit, long startTs, HttpHeaders requestHeaders, HttpMethod requesMethod, String requesURI, String requestBody) {
        if (ctx != null && ctx.channel() != null) {
            this.localIP = ctx.channel().localAddress();
            this.remoteIP = ctx.channel().remoteAddress();
        } else {
            this.localIP = null;
            this.remoteIP = null;
        }
        this.txId = txId;
        this.hit = hit;
        this.startTs = startTs;
        this.requestHeaders = requestHeaders;
        this.requesMethod = requesMethod;
        this.requesURI = requesURI;
        this.requestBody = requestBody;
        this.poi.add(new POI("service.begin"));
    }

    public Object attribute(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public ServiceContext attribute(String key, Object value) {
        if (this.attributes == null) {
            if (key == null || value == null) {
                return this;
            }
            this.attributes = new HashMap<String, Object>();
        }
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        return this;
    }

    public SocketAddress localIP() {
        return this.localIP;
    }

    public SocketAddress remoteIP() {
        return this.remoteIP;
    }

    public long startTimestamp() {
        return this.startTs;
    }

    public ServiceContext reset() {
        this.status = HttpResponseStatus.OK;
        this.autoConvertBlank200To204 = true;
        this.data = null;
        this.txt = "";
        this.file = null;
        this.redirect = null;
        this.serviceError = null;
        this.cause = null;
        this.level = Level.INFO;
        this.logRequestHeader = false;
        this.logResponseHeader = false;
        this.logRequestBody = false;
        this.logResponseBody = false;
        return this;
    }

    public String txId() {
        return this.txId;
    }

    public long hit() {
        return this.hit;
    }

    public HttpMethod method() {
        return this.requesMethod;
    }

    public String uri() {
        return this.requesURI;
    }

    public String requestBody() {
        return this.requestBody;
    }

    public HttpResponseStatus status() {
        return this.status;
    }

    public ServiceContext status(HttpResponseStatus status) {
        return this.status(status, null);
    }

    public ServiceContext status(HttpResponseStatus status, Boolean autoConvertBlank200To204) {
        this.status = status;
        if (autoConvertBlank200To204 != null) {
            this.autoConvertBlank200To204 = autoConvertBlank200To204;
        }
        return this;
    }

    public HttpHeaders requestHeaders() {
        return this.requestHeaders;
    }

    public HttpHeaders responseHeaders() {
        return this.responseHeaders;
    }

    public ServiceContext responseHeaders(HttpHeaders headers) {
        if (headers == null || headers.isEmpty()) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders(true);
        }
        this.responseHeaders.set(headers);
        return this;
    }

    public ServiceContext responseHeader(String key, Object value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders(true);
        }
        if (value == null) {
            this.responseHeaders.remove(key);
        } else {
            this.responseHeaders.set(key, value);
        }
        return this;
    }

    public ServiceContext responseHeader(String key, Iterable<?> values) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders(true);
        }
        if (values == null) {
            this.responseHeaders.remove(key);
        } else {
            this.responseHeaders.set(key, values);
        }
        return this;
    }

    public ServiceContext responseHeaders(Map<String, Iterable<?>> hs) {
        if (hs == null) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders(true);
        }
        hs.keySet().stream().filter(key -> StringUtils.isNotBlank((CharSequence)key)).forEachOrdered(key -> {
            Iterable values = (Iterable)hs.get(key);
            if (values == null) {
                this.responseHeaders.remove(key);
            } else {
                this.responseHeaders.set(key, values);
            }
        });
        return this;
    }

    public ResponseEncoder responseEncoder() {
        return this.responseEncoder;
    }

    public ServiceContext responseEncoder(ResponseEncoder responseEncoder) {
        this.responseEncoder = responseEncoder;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public ServiceContext contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String clientAcceptContentType() {
        return this.clientAcceptContentType;
    }

    public ServiceContext clientAcceptContentType(String clientAcceptContentType) {
        this.clientAcceptContentType = clientAcceptContentType;
        return this;
    }

    public String charsetName() {
        return this.charsetName;
    }

    public ServiceContext charsetName(String charsetName) {
        this.charsetName = charsetName;
        return this;
    }

    public String redirect() {
        return this.redirect;
    }

    public ServiceContext redirect(String redirect) {
        return this.redirect(redirect, HttpResponseStatus.TEMPORARY_REDIRECT);
    }

    public ServiceContext redirect(String redirect, HttpResponseStatus status) {
        this.redirect = redirect;
        this.txt = null;
        this.file = null;
        this.status = status;
        this.responseHeader(HttpHeaderNames.LOCATION.toString(), redirect);
        return this;
    }

    public String txt() {
        return this.txt;
    }

    public ServiceContext txt(String txt) {
        this.txt = txt;
        return this;
    }

    public byte[] data() {
        return this.data;
    }

    public ServiceContext data(byte[] data) {
        this.data = data;
        return this;
    }

    public File file() {
        return this.file;
    }

    public boolean isDownloadMode() {
        return this.downloadMode;
    }

    public ServiceContext downloadMode(boolean downloadMode) {
        this.downloadMode = downloadMode;
        return this;
    }

    public boolean precheckFolder(File folder) {
        String realPath;
        this.file = null;
        String filePath = folder.getAbsolutePath();
        try {
            realPath = this.file.getAbsoluteFile().toPath().normalize().toString();
        }
        catch (Throwable ex) {
            Err<CallSite> e = new Err<CallSite>(BootErrorCode.NIO_REQUEST_BAD_DOWNLOAD, null, null, ex, (CallSite)((Object)("Invalid file path: " + filePath)));
            this.status(HttpResponseStatus.BAD_REQUEST).error(e);
            return false;
        }
        this.memo("folder.view", filePath);
        if (!folder.exists()) {
            Err<CallSite> e = new Err<CallSite>(BootErrorCode.FILE_NOT_FOUND, null, null, null, (CallSite)((Object)("File not exists: " + filePath)));
            this.status(HttpResponseStatus.NOT_FOUND).error(e);
            return false;
        }
        if (!NioHttpUtil.sanitizePath(filePath) || !filePath.equals(realPath) || !folder.isDirectory() || folder.isFile() || folder.isHidden() || !folder.canRead()) {
            Err<CallSite> e = new Err<CallSite>(BootErrorCode.FILE_NOT_ACCESSABLE, null, null, null, (CallSite)((Object)("Malicious file reqeust: " + filePath)));
            this.status(HttpResponseStatus.FORBIDDEN).error(e);
            return false;
        }
        return true;
    }

    public boolean precheckFile(File file, boolean isDownloadMode) {
        String realPath;
        this.file = null;
        String filePath = file.getAbsolutePath();
        this.memo("file." + (isDownloadMode ? "download" : "view"), filePath);
        try {
            realPath = file.getAbsoluteFile().toPath().normalize().toString();
        }
        catch (Throwable ex) {
            Err<CallSite> e = new Err<CallSite>(BootErrorCode.NIO_REQUEST_BAD_DOWNLOAD, null, null, ex, (CallSite)((Object)("Invalid file path: " + filePath)));
            this.status(HttpResponseStatus.BAD_REQUEST).error(e);
            return false;
        }
        if (!file.exists()) {
            Err<CallSite> e = new Err<CallSite>(BootErrorCode.FILE_NOT_FOUND, null, null, null, (CallSite)((Object)("File not exists: " + filePath)));
            this.status(HttpResponseStatus.NOT_FOUND).error(e);
            return false;
        }
        if (!NioHttpUtil.sanitizePath(filePath) || !filePath.equals(realPath) || file.isDirectory() || !file.isFile() || file.isHidden() || !file.canRead()) {
            Err<CallSite> e = new Err<CallSite>(BootErrorCode.FILE_NOT_ACCESSABLE, null, null, null, (CallSite)((Object)("Malicious file reqeust: " + filePath)));
            this.status(HttpResponseStatus.FORBIDDEN).error(e);
            return false;
        }
        return true;
    }

    private File buildErrorFile(HttpResponseStatus status, boolean isDownloadMode) {
        int errorCode = status.code();
        String errorFileName = errorCode + (isDownloadMode ? ".txt" : ".html");
        String errorPageFolderName = nioCfg.getErrorPageFolderName();
        File errorFile = StringUtils.isBlank((CharSequence)errorPageFolderName) ? new File(nioCfg.getDocrootDir() + File.separator + errorFileName).getAbsoluteFile() : new File(nioCfg.getDocrootDir() + File.separator + errorPageFolderName + File.separator + errorFileName).getAbsoluteFile();
        if (!errorFile.exists()) {
            errorFile.getParentFile().mkdirs();
            String title = BackOffice.agent.getVersionShort();
            String errorDesc = status.reasonPhrase();
            StringBuilder sb = new StringBuilder();
            Path errorFilePath = errorFile.getAbsoluteFile().toPath();
            try (InputStream ioStream = this.getClass().getClassLoader().getResourceAsStream("org/summerboot/jexpress/template/HttpErrorTemplate" + (isDownloadMode ? ".txt" : ".html"));
                 InputStreamReader isr = new InputStreamReader(ioStream);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line).append(BootConstant.BR);
                }
                String errorFileContent = sb.toString().replace("${title}", title).replace("${code}", "" + errorCode).replace("${desc}", errorDesc);
                Files.writeString(errorFilePath, (CharSequence)errorFileContent, new OpenOption[0]);
            }
            catch (IOException ex) {
                String message = title + ": errCode=" + errorCode + ", desc=" + errorDesc;
                Err<CallSite> e = new Err<CallSite>(BootErrorCode.FILE_NOT_FOUND, null, null, (Throwable)ex, (CallSite)((Object)("Failed to generate error page:" + errorFile.getName() + ", " + message)));
                this.error(e);
            }
        }
        return errorFile;
    }

    public ServiceContext file(String fileName, boolean isDownloadMode) {
        Object targetFileName = NioConfig.cfg.getDocrootDir() + File.separator + fileName;
        targetFileName = ((String)targetFileName).replace('/', File.separatorChar);
        File targetFile = new File((String)targetFileName).getAbsoluteFile();
        return this.file(targetFile, isDownloadMode);
    }

    public ServiceContext file(File file, boolean isDownloadMode) {
        long fileLength;
        this.downloadMode = isDownloadMode;
        if (!this.precheckFile(file, this.downloadMode)) {
            file = this.buildErrorFile(this.status, this.downloadMode);
        }
        this.txt = null;
        this.redirect = null;
        this.file = file;
        this.contentType = NioHttpUtil.getFileContentType(file);
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders(true);
        }
        if ((fileLength = file.length()) > Integer.MAX_VALUE) {
            this.responseHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(fileLength));
        } else {
            this.responseHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (int)fileLength);
        }
        this.responseHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.contentType);
        if (this.downloadMode) {
            String fileName = file.getName();
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8").replace("+", "%20");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.responseHeaders.set((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)("attachment;filename=" + fileName + ";filename*=UTF-8''" + fileName));
        }
        return this;
    }

    public <T extends Caller> T caller() {
        return (T)this.caller;
    }

    public <T extends Caller> ServiceContext caller(T caller) {
        this.caller = caller;
        return this;
    }

    public String callerId() {
        return this.callerId;
    }

    public ServiceContext callerId(String callerId) {
        this.callerId = callerId;
        return this;
    }

    public ServiceError error() {
        return this.serviceError;
    }

    public ServiceContext error(Err error2) {
        if (this.serviceError == null) {
            this.serviceError = new ServiceError(this.txId);
        }
        if (error2 == null) {
            return this;
        }
        this.serviceError.addError(error2);
        Throwable t = error2.getCause();
        if (t != null) {
            this.cause = t;
        }
        if (error2.getCause() != null) {
            this.level = Level.ERROR;
        }
        return this;
    }

    public ServiceContext errors(Collection<Err> es) {
        if (es == null || es.isEmpty()) {
            if (this.serviceError != null && this.serviceError.getErrors() != null) {
                this.serviceError.getErrors().clear();
                this.serviceError = null;
            }
            return this;
        }
        if (this.serviceError == null) {
            this.serviceError = new ServiceError(this.txId);
        }
        this.serviceError.addErrors(es);
        for (Err e : es) {
            Throwable t = e.getCause();
            if (t != null) {
                this.cause = t;
            }
            if (this.cause == null) continue;
            this.level = Level.ERROR;
        }
        return this;
    }

    public ServiceContext cause(Throwable cause) {
        this.cause = cause;
        if (cause != null) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)cause);
            if (root == null || root.equals(cause)) {
                if (this.level.isLessSpecificThan(Level.WARN)) {
                    this.level = Level.WARN;
                }
            } else if (this.level.isLessSpecificThan(Level.ERROR)) {
                this.level = Level.ERROR;
            }
        }
        return this;
    }

    public Throwable cause() {
        return this.cause;
    }

    public Level level() {
        return this.level;
    }

    public ServiceContext level(Level level) {
        this.level = level;
        return this;
    }

    public ServiceContext logRequestHeader(boolean enabled) {
        this.logRequestHeader = enabled;
        return this;
    }

    public boolean logRequestHeader() {
        return this.logRequestHeader;
    }

    public ServiceContext logRequestBody(boolean enabled) {
        this.logRequestBody = enabled;
        return this;
    }

    public boolean logRequestBody() {
        return this.logRequestBody;
    }

    public ServiceContext logResponseHeader(boolean enabled) {
        this.logResponseHeader = enabled;
        return this;
    }

    public boolean logResponseHeader() {
        return this.logResponseHeader;
    }

    public ServiceContext logResponseBody(boolean enabled) {
        this.logResponseBody = enabled;
        return this;
    }

    public boolean logResponseBody() {
        return this.logResponseBody;
    }

    public ServiceContext poi(String marker) {
        this.poi.add(new POI(marker));
        return this;
    }

    public List<POI> poi() {
        return this.poi;
    }

    public ServiceContext memo(String id, String desc) {
        if (this.memo == null) {
            this.memo = new ArrayList<Memo>();
        }
        this.memo.add(new Memo(id, desc));
        return this;
    }

    public List<Memo> memo() {
        return this.memo;
    }

    public boolean autoConvertBlank200To204() {
        return this.autoConvertBlank200To204;
    }

    public ServiceContext reportError(StringBuilder sb) throws JsonProcessingException {
        if (this.serviceError == null) {
            return this;
        }
        List<Err> errors = this.serviceError.getErrors();
        if (errors != null && !errors.isEmpty()) {
            sb.append("\n\n\tErrors: ");
            for (Err error2 : errors) {
                sb.append("\n\t ").append(error2.toStringEx(false));
            }
        }
        return this;
    }

    public ServiceContext reportMemo(StringBuilder sb) {
        if (this.memo == null || this.memo.isEmpty()) {
            return this;
        }
        sb.append("\n\n\tMemo: ");
        this.memo.forEach(m -> sb.append("\n\t\t").append(m.id).append("=").append(m.desc));
        return this;
    }

    public ServiceContext reportPOI(StringBuilder sb) {
        return this.reportPOI(null, sb);
    }

    public ServiceContext reportPOI(NioConfig cfg, StringBuilder sb) {
        if (this.poi == null || this.poi.isEmpty()) {
            sb.append("\n\tPOI: n/a");
            return this;
        }
        NioConfig.VerboseTargetPOIType filterType = cfg == null ? NioConfig.VerboseTargetPOIType.all : cfg.getFilterPOIType();
        sb.append("\n\tPOI: ");
        switch (filterType) {
            case all: {
                this.poi.forEach(p -> sb.append(p.name).append("=").append(p.ts - this.startTs).append("ms, "));
                break;
            }
            case filter: {
                Set<String> poiSet = cfg.getFilterPOISet();
                this.poi.stream().filter(p -> poiSet.contains(p.name)).forEachOrdered(p -> sb.append(p.name).append("=").append(p.ts - this.startTs).append("ms, "));
                break;
            }
            case ignore: {
                sb.append("off");
            }
        }
        return this;
    }

    public static class POI {
        public final String name;
        public final long ts = System.currentTimeMillis();

        public POI(String name) {
            this.name = name;
        }
    }

    public static class Memo {
        public final String id;
        public final String desc;

        public Memo(String id, String desc) {
            this.id = id;
            this.desc = desc;
        }
    }
}

