/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.util.BeanUtil;

public class ServiceError {
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The index of requests received by current server since start")
    private final String ref;
    @JsonIgnore
    private Object attachedData;
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED, description="The optional error list")
    private List<Err> errors;

    public ServiceError(String ref) {
        this.ref = ref;
    }

    public ServiceError(int errorCode, String errorTag, String errorDesc, Throwable ex) {
        this("" + errorCode, errorTag, errorDesc, ex);
    }

    public ServiceError(String errorCode, String errorTag, String errorDesc, Throwable ex) {
        this.ref = null;
        if (this.errors == null) {
            this.errors = new ArrayList<Err>();
        }
        this.errors.add(new Err<Object>(errorCode, errorTag, errorDesc, ex, null));
    }

    public String toString() {
        return "ServiceError{ref=" + this.ref + ", attachedData=" + this.attachedData + ", errors=" + this.errors + "}";
    }

    public String toJson() {
        try {
            return BeanUtil.toJson(this, true, true);
        }
        catch (JsonProcessingException ex) {
            return this.toString();
        }
    }

    public String toXML() {
        try {
            return BeanUtil.toXML(this);
        }
        catch (JsonProcessingException ex) {
            return this.toString();
        }
    }

    public String getRef() {
        return this.ref;
    }

    public Object getAttachedData() {
        return this.attachedData;
    }

    public void setAttachedData(Object attachedData) {
        this.attachedData = attachedData;
    }

    public List<Err> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Err> errors) {
        this.errors = errors;
    }

    public void addErrors(Err ... error2) {
        if (this.errors == null) {
            this.errors = new ArrayList<Err>();
        }
        this.errors.addAll(Arrays.asList(error2));
    }

    public void addErrors(Collection<Err> es) {
        if (es == null || es.isEmpty()) {
            return;
        }
        if (this.errors == null) {
            this.errors = new ArrayList<Err>();
        }
        this.errors.addAll(es);
    }

    @JsonIgnore
    public void addError(Err error2) {
        if (error2 == null) {
            return;
        }
        if (this.errors == null) {
            this.errors = new ArrayList<Err>();
        }
        this.errors.add(error2);
    }

    public void addError(int errorCode, String errorTag, String errorDesc, Throwable ex) {
        this.addError(errorCode, errorTag, errorDesc, ex, null);
    }

    public void addError(int errorCode, String errorTag, String errorDesc, Throwable ex, String internalInfo) {
        if (this.errors == null) {
            this.errors = new ArrayList<Err>();
        }
        this.errors.add(new Err<String>(errorCode, errorTag, errorDesc, ex, internalInfo));
    }
}

