/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.boot.config.NamedDefaultThreadFactory;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.util.ApplicationUtil;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.ReflectionUtil;
import org.summerboot.jexpress.util.concurrent.EmptyBlockingQueue;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public abstract class BootConfig
implements JExpressConfig {
    private static final Map<Class, JExpressConfig> cache = new HashMap<Class, JExpressConfig>();
    protected static String BR = System.lineSeparator();
    protected static final String DESC_KMF = "Path to key store file. Use SSL/TLS when keystore is provided, otherwise use plain socket";
    protected static final String DESC_TMF = "Path to trust store file. Auth the remote peer certificate when a truststore is provided, otherwise blindly trust all remote peer certificate";
    public static final String DESC_PLAINPWD = "plain text inside DEC() will be automatically encrypted by app root password when the application starts or is running";
    protected static final String FILENAME_KEYSTORE = "tls_keystore.p12";
    protected static final String FILENAME_TRUSTSTORE_4SERVER = "tls_truststore_4server.p12";
    protected static final String FILENAME_TRUSTSTORE_4CLIENT = "tls_truststore_4client.p12";
    @JsonIgnore
    protected Logger logger;
    protected boolean generateTemplate = false;
    protected final Properties props = new Properties();
    protected File cfgFile;
    protected String configName = this.getClass().getSimpleName();
    protected static final int CPU_CORE = Runtime.getRuntime().availableProcessors();

    public static <T extends JExpressConfig> T instance(Class<T> implclass) {
        JExpressConfig instance = cache.get(implclass);
        if (instance != null) {
            return (T)instance;
        }
        try {
            Constructor<T> cons = implclass.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            JExpressConfig ret = (JExpressConfig)cons.newInstance(new Object[0]);
            return (T)cache.get(implclass);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to instance " + implclass, ex);
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    protected BootConfig() {
        this.registerSingleton();
    }

    private void registerSingleton() {
        Class<?> key = this.getClass();
        if (cache.containsKey(key)) {
            return;
        }
        cache.put(key, this);
    }

    @Override
    public JExpressConfig temp() {
        BootConfig ret = null;
        Class<?> c = this.getClass();
        try {
            Constructor<?> cons = c.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            ret = (BootConfig)cons.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            if (this.logger == null) {
                this.logger = LogManager.getLogger(this.getClass());
            }
            this.logger.warn("failed to create temp " + c.getName(), (Throwable)ex);
        }
        return ret;
    }

    @Override
    public String name() {
        return this.configName;
    }

    @Override
    public File getCfgFile() {
        return this.cfgFile;
    }

    @Override
    public String info() {
        try {
            return BeanUtil.toJson(this, true, false);
        }
        catch (JsonProcessingException ex) {
            ex.printStackTrace();
            return ex.getMessage();
        }
    }

    protected void createIfNotExist(String fileName) {
        if (this.cfgFile == null || !this.generateTemplate) {
            return;
        }
        String location = this.cfgFile.getParentFile().getAbsolutePath();
        ClassLoader classLoader = this.getClass().getClassLoader();
        ApplicationUtil.createIfNotExist(location, classLoader, fileName, fileName);
    }

    protected void preLoad(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(File cfgFile, boolean isReal) throws IOException {
        String configFolder = cfgFile.getParent();
        this.cfgFile = cfgFile.getAbsoluteFile();
        if (this.configName == null) {
            this.configName = cfgFile.getName();
        }
        this.props.clear();
        try (FileInputStream is = new FileInputStream(cfgFile);
             InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);){
            this.props.load(isr);
        }
        ConfigUtil helper = new ConfigUtil(this.cfgFile.getAbsolutePath());
        try {
            this.preLoad(cfgFile, isReal, helper, this.props);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            helper.addError("failed to preLoad configs:" + ex);
        }
        Class<?> c = this.getClass();
        List<Field> fields = ReflectionUtil.getDeclaredAndSuperClassesFields(c);
        boolean autoDecrypt = true;
        for (Field field : fields) {
            try {
                this.loadField(field, configFolder, helper, this.props, autoDecrypt);
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                String key = field.getAnnotation(Config.class).key();
                Class<?> expectedType = field.getType();
                helper.addError("invalid \"" + key + "\" - " + expectedType + ", error=" + ex);
            }
        }
        try {
            this.loadCustomizedConfigs(cfgFile, isReal, helper, this.props);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            helper.addError("failed to init customized configs:" + ex);
        }
        finally {
            if (!isReal) {
                this.shutdown();
            }
        }
        String error2 = helper.getError();
        if (error2 != null) {
            throw new IllegalArgumentException(error2);
        }
        if (isReal && this.logger == null) {
            this.logger = LogManager.getLogger(this.getClass());
        }
    }

    protected abstract void loadCustomizedConfigs(File var1, boolean var2, ConfigUtil var3, Properties var4) throws Exception;

    protected void loadField(Field field, String configFolder, ConfigUtil helper, Properties props, boolean autoDecrypt) throws IllegalAccessException {
        Config.Validate validate;
        boolean isEncrypted;
        Config cfgAnnotation = field.getAnnotation(Config.class);
        if (cfgAnnotation == null) {
            return;
        }
        String annotationKey = cfgAnnotation.key();
        Object valueInCfgFile = props.getProperty(annotationKey);
        field.setAccessible(true);
        if (StringUtils.isBlank((CharSequence)valueInCfgFile)) {
            if (cfgAnnotation.required()) {
                helper.addError("missing \"" + annotationKey + "\"");
                return;
            }
            boolean isSpecifiedInCfgFile = props.containsKey(annotationKey);
            if (isSpecifiedInCfgFile) {
                Object nullValue = ReflectionUtil.toStandardJavaType(null, field.getType(), false, false, null);
                field.set(this, nullValue);
                return;
            }
            String annotationDefaultValue = cfgAnnotation.defaultValue();
            boolean hasDefaultValue = StringUtils.isNotBlank((CharSequence)annotationDefaultValue);
            if (hasDefaultValue) {
                valueInCfgFile = annotationDefaultValue;
            } else {
                return;
            }
        }
        if (isEncrypted = (validate = cfgAnnotation.validate()).equals((Object)Config.Validate.Encrypted)) {
            if (((String)valueInCfgFile).startsWith("ENC(") && ((String)valueInCfgFile).endsWith(")")) {
                try {
                    valueInCfgFile = SecurityUtil.decrypt((String)valueInCfgFile, true);
                }
                catch (GeneralSecurityException ex) {
                    throw new IllegalArgumentException("Failed to decrypt", ex);
                }
            } else {
                helper.addError("invalid \"" + annotationKey + "\" - require encrypted format, missing warpper: ENC(encrypted value)");
                return;
            }
        }
        boolean isEmailRecipients = validate.equals((Object)Config.Validate.EmailRecipients);
        Class<?> fieldClass = field.getType();
        if (fieldClass.equals(KeyManagerFactory.class)) {
            String key_storeFile = annotationKey;
            String key_storePwd = cfgAnnotation.StorePwdKey();
            String key_keyAlias = cfgAnnotation.AliasKey();
            String key_keyPwd = cfgAnnotation.AliasPwdKey();
            KeyManagerFactory kmf = helper.getAsKeyManagerFactory(props, configFolder, key_storeFile, key_storePwd, key_keyAlias, key_keyPwd);
            field.set(this, kmf);
        } else if (fieldClass.equals(TrustManagerFactory.class)) {
            String key_storeFile = annotationKey;
            String key_storePwd = cfgAnnotation.StorePwdKey();
            TrustManagerFactory tmf = helper.getAsTrustManagerFactory(props, configFolder, key_storeFile, key_storePwd);
            field.set(this, tmf);
        } else {
            File file;
            if (valueInCfgFile != null && (fieldClass.equals(File.class) || fieldClass.equals(Path.class)) && !(file = new File((String)valueInCfgFile)).isAbsolute()) {
                valueInCfgFile = configFolder + File.separator + (String)valueInCfgFile;
            }
            String collectionDelimiter = cfgAnnotation.collectionDelimiter();
            ReflectionUtil.loadField(this, field, (String)valueInCfgFile, autoDecrypt, isEmailRecipients, collectionDelimiter);
        }
    }

    protected String updateFilePath(File domainDir, String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return fileName;
        }
        if (fileName.startsWith(File.separator)) {
            return new File(fileName).getAbsolutePath();
        }
        return new File(domainDir.getAbsolutePath() + File.separator + fileName).getAbsolutePath();
    }

    public void updateConfigFile(Map<String, String> updatedCfgs) throws IOException {
        if (updatedCfgs == null || updatedCfgs.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        LineIterator iterator = FileUtils.lineIterator((File)new File(this.cfgFile.getAbsolutePath()), (String)"UTf-8");
        while (iterator.hasNext()) {
            String key;
            int i;
            Object line = iterator.nextLine().trim();
            if (!((String)line).startsWith("#") && (i = ((String)line).indexOf("=")) > 0 && updatedCfgs.containsKey(key = ((String)line).substring(0, i).trim())) {
                line = key + "=" + updatedCfgs.get(key);
            }
            sb.append((String)line).append(BR);
        }
        try (FileOutputStream output = new FileOutputStream(this.cfgFile);
             FileChannel foc = output.getChannel();){
            foc.write(ByteBuffer.wrap(sb.toString().getBytes(StandardCharsets.UTF_8)));
        }
    }

    public static String generateTemplate(Class configClass) {
        Object objectInstance = null;
        if (JExpressConfig.class.isAssignableFrom(configClass)) {
            objectInstance = BootConfig.instance(configClass);
        }
        if (objectInstance == null) {
            try {
                Constructor cons = configClass.getDeclaredConstructor(new Class[0]);
                cons.setAccessible(true);
                objectInstance = cons.newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        List<Field> configItems = ReflectionUtil.getDeclaredAndSuperClassesFields(configClass);
        boolean hasConfig = false;
        StringBuilder sb = new StringBuilder();
        for (Field field : configItems) {
            String callbackFunc;
            Config cfg;
            ConfigHeader header = field.getAnnotation(ConfigHeader.class);
            if (header != null) {
                String callbackFunc2;
                List<String> list = BootConfig.parse(header);
                int maxSize = 0;
                for (String s : list) {
                    maxSize = Math.max(maxSize, BootConfig.getLength(s));
                }
                maxSize += 2;
                sb.append("\n\n");
                hasConfig = true;
                for (int i = 0; i < maxSize; ++i) {
                    sb.append("#");
                }
                sb.append("\n");
                for (String s : list) {
                    sb.append(s);
                    int size = maxSize - s.length() - 1;
                    for (int i = 0; i < size; ++i) {
                        sb.append(" ");
                    }
                    sb.append("#").append("\n");
                }
                for (int i = 0; i < maxSize; ++i) {
                    sb.append("#");
                }
                sb.append("\n");
                if (objectInstance != null && StringUtils.isNotBlank((CharSequence)(callbackFunc2 = header.callbackMethodName4Dump()))) {
                    Class[] cArg = new Class[]{StringBuilder.class};
                    try {
                        Method cbMethod = ReflectionUtil.getMethod(configClass, callbackFunc2, cArg);
                        if (cbMethod != null) {
                            cbMethod.setAccessible(true);
                            cbMethod.invoke(objectInstance, sb);
                        } else {
                            sb.append("NoSuchMethodException: ").append(callbackFunc2).append("\n");
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                        sb.append(ex).append("\n");
                    }
                }
            }
            if ((cfg = field.getAnnotation(Config.class)) == null) continue;
            boolean isEncrypted = cfg.validate().equals((Object)Config.Validate.Encrypted);
            String cm = cfg.desc();
            if (StringUtils.isNotBlank((CharSequence)cm)) {
                ArrayList<String> memoList = new ArrayList<String>();
                BootConfig.lineBreak(cm, null, memoList);
                for (String s : memoList) {
                    hasConfig = true;
                    sb.append("#").append(s).append("\n");
                }
            }
            boolean isRequired = cfg.required();
            boolean hasDefaultValue = false;
            boolean hasPredefinedValue = false;
            String dv = cfg.predefinedValue();
            if (!StringUtils.isBlank((CharSequence)dv)) {
                hasPredefinedValue = true;
            } else {
                dv = cfg.defaultValue();
                if (StringUtils.isBlank((CharSequence)dv) && objectInstance != null) {
                    try {
                        field.setAccessible(true);
                        Object dfv = field.get(objectInstance);
                        if (dfv != null) {
                            dv = dfv.toString();
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dv)) {
                    hasDefaultValue = true;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dv)) {
                dv = dv.replace("\n", "\\n");
                dv = dv.replace(BR, "\\n");
            }
            boolean dumpDefault = true;
            if (objectInstance != null && StringUtils.isNotBlank((CharSequence)(callbackFunc = cfg.callbackMethodName4Dump()))) {
                Class[] cArg = new Class[]{StringBuilder.class};
                try {
                    Method cbMethod = ReflectionUtil.getMethod(configClass, callbackFunc, cArg);
                    if (cbMethod != null) {
                        cbMethod.setAccessible(true);
                        cbMethod.invoke(objectInstance, sb);
                        dumpDefault = false;
                    } else {
                        sb.append("NoSuchMethodException: ").append(callbackFunc).append("\n");
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                    sb.append(ex).append("\n");
                }
            }
            if (dumpDefault) {
                String[] keys;
                if (!hasPredefinedValue && !isRequired || hasDefaultValue) {
                    sb.append("#");
                }
                String key = cfg.key();
                sb.append(key).append("=");
                if (isEncrypted) {
                    sb.append("DEC(");
                }
                if (hasDefaultValue || hasPredefinedValue) {
                    sb.append(dv);
                } else if (isEncrypted) {
                    sb.append(DESC_PLAINPWD);
                }
                if (isEncrypted) {
                    sb.append(")");
                }
                sb.append("\n");
                int i = 0;
                for (String skey : keys = new String[]{cfg.StorePwdKey(), cfg.AliasKey(), cfg.AliasPwdKey()}) {
                    if (StringUtils.isNotBlank((CharSequence)skey)) {
                        if (!isRequired) {
                            sb.append("#");
                        }
                        sb.append(skey).append("=");
                        if (i == 0 || i == 2) {
                            sb.append("DEC(").append(DESC_PLAINPWD).append(")");
                        }
                        sb.append("\n");
                    }
                    ++i;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)cm)) continue;
            sb.append("\n");
        }
        return hasConfig ? sb.substring(2) : sb.toString();
    }

    private static List<String> parse(ConfigHeader memo) {
        ArrayList<String> ret = new ArrayList<String>();
        BootConfig.lineBreak(memo.title(), null, ret);
        BootConfig.lineBreak(memo.desc(), null, ret);
        BootConfig.lineBreak(memo.format(), "Format> ", ret);
        BootConfig.lineBreak(memo.example(), "Example> ", ret);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private static String[] lineBreak(String s, String prefix, List<String> list) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String[] ret = s.trim().split("\\r?\\n");
        if (ret != null) {
            for (String string : ret) {
                void var7_11;
                if (string == null) continue;
                if (StringUtils.isBlank((CharSequence)prefix)) {
                    String string2 = string.trim();
                } else {
                    String string3 = prefix + string.trim();
                }
                list.add("# " + (String)var7_11);
            }
        }
        return ret;
    }

    private static int getLength(String s) {
        return StringUtils.isBlank((CharSequence)s) ? 0 : s.trim().length();
    }

    public static ThreadPoolExecutor buildThreadPoolExecutor(ThreadPoolExecutor tpe, String tpeName, ThreadingMode threadingMode, int core, int max, int queue, long keepAliveSec, RejectedExecutionHandler rejectedExecutionHandler, boolean prestartAllCoreThreads, boolean allowCoreThreadTimeOut, boolean isSingleton) {
        switch (threadingMode) {
            case CPU: {
                core = CPU_CORE + 1;
                max = CPU_CORE + 1;
                break;
            }
            case IO: {
                core = CPU_CORE * 2 + 1;
                max = CPU_CORE * 2 + 1;
                break;
            }
            case Mixed: {
                if (core < 1) {
                    core = CPU_CORE * 2 + 1;
                }
                if (max < 1) {
                    max = CPU_CORE * 2 + 1;
                }
                if (max >= core) break;
                max = core;
            }
        }
        boolean isQueueChanged = false;
        if (tpe != null && !isSingleton) {
            int currentQueue = tpe.getQueue().size() + tpe.getQueue().remainingCapacity();
            boolean bl = isQueueChanged = currentQueue != queue;
        }
        if (tpe == null || isQueueChanged) {
            ThreadPoolExecutor old = tpe;
            LinkedBlockingQueue<Runnable> bq = queue > 0 ? new LinkedBlockingQueue<Runnable>(queue) : new EmptyBlockingQueue();
            tpe = new ThreadPoolExecutor(core, max, keepAliveSec, TimeUnit.SECONDS, bq, new NamedDefaultThreadFactory(tpeName), rejectedExecutionHandler);
            if (old != null) {
                old.shutdown();
            }
        }
        if (max >= tpe.getCorePoolSize()) {
            tpe.setMaximumPoolSize(max);
            tpe.setCorePoolSize(core);
        } else {
            tpe.setCorePoolSize(core);
            tpe.setMaximumPoolSize(max);
        }
        tpe.setKeepAliveTime(keepAliveSec, TimeUnit.SECONDS);
        if (prestartAllCoreThreads) {
            tpe.prestartAllCoreThreads();
        }
        tpe.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
        return tpe;
    }

    public static enum ThreadingMode {
        CPU,
        IO,
        Mixed;

    }
}

