/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.config.NamedDefaultThreadFactory;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.nio.server.IoMultiplexer;
import org.summerboot.jexpress.nio.server.NioChannelInitializer;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioCounter;

public class NioServer {
    protected static final Logger log = LogManager.getLogger((String)NioServer.class.getName());
    protected EventLoopGroup bossGroup;
    protected EventLoopGroup workerGroup;
    protected ScheduledExecutorService QPS_SERVICE;
    protected final NioChannelInitializer channelInitializer;
    protected final NIOStatusListener nioListener;

    public NioServer(NioChannelInitializer channelInitializer, NIOStatusListener nioListener) {
        this.channelInitializer = channelInitializer;
        this.nioListener = nioListener;
    }

    public void bind(NioConfig nioCfg) throws InterruptedException, SSLException {
        Class<NioServerSocketChannel> serverChannelClass;
        ClientAuth clientAuth;
        List<InetSocketAddress> bindingAddresses = nioCfg.getBindingAddresses();
        if (bindingAddresses == null || bindingAddresses.isEmpty()) {
            log.info("Skip HTTP server due to no bindingAddresses in config file: " + nioCfg.getCfgFile());
            return;
        }
        IoMultiplexer multiplexer = nioCfg.getMultiplexer();
        log.info("starting... Epoll=" + Epoll.isAvailable() + ", KQueue=" + KQueue.isAvailable() + ", multiplexer=" + multiplexer);
        System.setProperty("io.netty.recycler.maxCapacity", "0");
        System.setProperty("io.netty.allocator.tinyCacheSize", "0");
        System.setProperty("io.netty.allocator.smallCacheSize", "0");
        System.setProperty("io.netty.allocator.normalCacheSize", "0");
        Object jdkSslContext = null;
        SslContext nettySslContext = null;
        KeyManagerFactory kmf = nioCfg.getKmf();
        TrustManagerFactory tmf = nioCfg.getTmf();
        ClientAuth clientAuth2 = clientAuth = kmf != null && tmf != null ? ClientAuth.REQUIRE : ClientAuth.NONE;
        if (kmf != null) {
            String[] cipherSuites = nioCfg.getSslCipherSuites();
            List<String> ciphers = cipherSuites != null && cipherSuites.length > 0 ? Arrays.asList(nioCfg.getSslCipherSuites()) : Http2SecurityUtil.CIPHERS;
            SslProvider sp = nioCfg.getSslProvider();
            nettySslContext = SslContextBuilder.forServer((KeyManagerFactory)kmf).trustManager(tmf).clientAuth(clientAuth).sslProvider(sp).sessionTimeout(0L).protocols(nioCfg.getSslProtocols()).ciphers(ciphers, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).build();
            log.info(StringUtils.join((Object[])new String[]{"[" + sp + "] " + Arrays.asList(nioCfg.getSslProtocols())}) + " (" + nioCfg.getSslHandshakeTimeoutSeconds() + "s): " + ciphers);
        }
        int bossSize = nioCfg.getNioEventLoopGroupAcceptorSize();
        int workerSize = nioCfg.getNioEventLoopGroupWorkerSize();
        NamedDefaultThreadFactory threadFactoryBoss = new NamedDefaultThreadFactory("NIO.Boss");
        NamedDefaultThreadFactory threadFactoryWorker = new NamedDefaultThreadFactory("NIO.Worker");
        if (Epoll.isAvailable() && (IoMultiplexer.AVAILABLE.equals((Object)multiplexer) || IoMultiplexer.EPOLL.equals((Object)multiplexer))) {
            this.bossGroup = bossSize < 1 ? new EpollEventLoopGroup() : new EpollEventLoopGroup(bossSize, (ThreadFactory)threadFactoryBoss);
            this.workerGroup = workerSize < 1 ? new EpollEventLoopGroup() : new EpollEventLoopGroup(workerSize, (ThreadFactory)threadFactoryWorker);
            serverChannelClass = EpollServerSocketChannel.class;
            multiplexer = IoMultiplexer.EPOLL;
        } else if (KQueue.isAvailable() && (IoMultiplexer.AVAILABLE.equals((Object)multiplexer) || IoMultiplexer.KQUEUE.equals((Object)multiplexer))) {
            this.bossGroup = bossSize < 1 ? new EpollEventLoopGroup() : new EpollEventLoopGroup(bossSize, (ThreadFactory)threadFactoryBoss);
            this.workerGroup = workerSize < 1 ? new EpollEventLoopGroup() : new EpollEventLoopGroup(workerSize, (ThreadFactory)threadFactoryWorker);
            serverChannelClass = KQueueServerSocketChannel.class;
            multiplexer = IoMultiplexer.KQUEUE;
        } else {
            this.bossGroup = bossSize < 1 ? new NioEventLoopGroup() : new NioEventLoopGroup(bossSize, (ThreadFactory)threadFactoryBoss);
            this.workerGroup = workerSize < 1 ? new NioEventLoopGroup() : new NioEventLoopGroup(workerSize, (ThreadFactory)threadFactoryWorker);
            serverChannelClass = NioServerSocketChannel.class;
            multiplexer = IoMultiplexer.JDK;
        }
        ServerBootstrap boot = new ServerBootstrap();
        if (multiplexer == IoMultiplexer.EPOLL) {
            boot.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
        }
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)boot.option(ChannelOption.SO_BACKLOG, (Object)nioCfg.getSoBacklog())).option(ChannelOption.SO_REUSEADDR, (Object)nioCfg.isSoReuseAddr())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.SO_REUSEADDR, (Object)nioCfg.isSoReuseAddr()).childOption(ChannelOption.SO_KEEPALIVE, (Object)nioCfg.isSoKeepAlive()).childOption(ChannelOption.TCP_NODELAY, (Object)nioCfg.isSoTcpNodelay()).childOption(ChannelOption.SO_LINGER, (Object)nioCfg.getSoLinger()).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(nioCfg.getSoConnectionTimeoutSeconds() * 1000)).childOption(ChannelOption.SO_RCVBUF, (Object)nioCfg.getSoRcvBuf()).childOption(ChannelOption.SO_SNDBUF, (Object)nioCfg.getSoSndBuf()).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.channelInitializer.initSSL(nettySslContext, nioCfg);
        ((ServerBootstrap)boot.group(this.bossGroup, this.workerGroup).channel(serverChannelClass)).childHandler((ChannelHandler)this.channelInitializer);
        String appInfo = "SummerBoot.jExpress 2.3.13 " + BootConstant.PID;
        String loadBalancingPingEndpoint = BackOffice.agent.getPingURL();
        for (InetSocketAddress addr : bindingAddresses) {
            String protocol;
            Object sslMode;
            if (jdkSslContext == null && nettySslContext == null) {
                sslMode = "non-ssl";
                protocol = multiplexer + " http://";
            } else {
                sslMode = "Client Auth: " + clientAuth;
                protocol = multiplexer + " https://";
            }
            String bindAddr = addr.getAddress().getHostAddress();
            int listeningPort = addr.getPort();
            ChannelFuture f = boot.bind(bindAddr, listeningPort).sync();
            f.channel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> NioServer.lambda$bind$0(appInfo, (String)sslMode, arg_0)));
            log.info(() -> NioServer.lambda$bind$1(appInfo, (String)sslMode, protocol, bindAddr, listeningPort, loadBalancingPingEndpoint));
            if (this.nioListener == null) continue;
            this.nioListener.onNIOBindNewPort(appInfo, (String)sslMode, protocol, bindAddr, listeningPort, loadBalancingPingEndpoint);
        }
        AtomicReference<Long> lastBizHitRef = new AtomicReference<Long>();
        lastBizHitRef.set(-1L);
        if (this.nioListener != null || log.isDebugEnabled()) {
            int interval = 1;
            this.QPS_SERVICE = Executors.newSingleThreadScheduledExecutor(new NamedDefaultThreadFactory("NIO.QPS_SERVICE"));
            this.QPS_SERVICE.scheduleAtFixedRate(() -> {
                long hps = NioCounter.COUNTER_HIT.getAndSet(0L);
                long tps = NioCounter.COUNTER_SENT.getAndSet(0L);
                if (this.nioListener == null && !log.isDebugEnabled()) {
                    return;
                }
                long bizHit = NioCounter.COUNTER_BIZ_HIT.get();
                if ((Long)lastBizHitRef.get() == bizHit && !HealthMonitor.isServicePaused()) {
                    return;
                }
                lastBizHitRef.set(bizHit);
                ThreadPoolExecutor tpe = nioCfg.getBizExecutor();
                int active = tpe.getActiveCount();
                int queue = tpe.getQueue().size();
                if (hps > 0L || tps > 0L || active > 0 || queue > 0 || HealthMonitor.isServicePaused()) {
                    long totalChannel = NioCounter.COUNTER_TOTAL_CHANNEL.get();
                    long activeChannel = NioCounter.COUNTER_ACTIVE_CHANNEL.get();
                    long pool = tpe.getPoolSize();
                    int core = tpe.getCorePoolSize();
                    long max = tpe.getMaximumPoolSize();
                    long largest = tpe.getLargestPoolSize();
                    long task = tpe.getTaskCount();
                    long completed = tpe.getCompletedTaskCount();
                    long pingHit = NioCounter.COUNTER_PING_HIT.get();
                    long totalHit = bizHit + pingHit;
                    log.debug(() -> "hps=" + hps + ", tps=" + tps + ", activeChannel=" + activeChannel + ", totalChannel=" + totalChannel + ", totalHit=" + totalHit + " (ping" + pingHit + " + biz" + bizHit + "), task=" + task + ", completed=" + completed + ", queue=" + queue + ", active=" + active + ", pool=" + pool + ", core=" + core + ", max=" + max + ", largest=" + largest);
                    if (this.nioListener != null) {
                        this.nioListener.onNIOAccessReportUpdate(appInfo, hps, tps, totalHit, pingHit, bizHit, totalChannel, activeChannel, task, completed, queue, active, pool, core, max, largest);
                    }
                }
            }, 0L, interval, TimeUnit.SECONDS);
        }
    }

    public void shutdown() {
        String tn = Thread.currentThread().getName();
        if (this.bossGroup != null && !this.bossGroup.isShutdown()) {
            System.out.println(tn + ": shutdown bossGroup");
            this.bossGroup.shutdownGracefully();
        }
        if (this.workerGroup != null && !this.workerGroup.isShutdown()) {
            System.out.println(tn + ": shutdown workerGroup");
            this.workerGroup.shutdownGracefully();
        }
        if (this.QPS_SERVICE != null && !this.QPS_SERVICE.isShutdown()) {
            System.out.println(tn + ": shutdown QPS_SERVICE");
            this.QPS_SERVICE.shutdownNow();
        }
    }

    private static /* synthetic */ Object lambda$bind$1(String appInfo, String sslMode, String protocol, String bindAddr, int listeningPort, String loadBalancingPingEndpoint) {
        return "Server " + appInfo + " (" + sslMode + ") is listening on " + protocol + bindAddr + ":" + listeningPort + (loadBalancingPingEndpoint == null ? "" : loadBalancingPingEndpoint);
    }

    private static /* synthetic */ void lambda$bind$0(String appInfo, String sslMode, ChannelFuture f1) throws Exception {
        System.out.println("Server " + appInfo + " (" + sslMode + ") is stopped");
    }
}

