/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.SummerApplication;
import org.summerboot.jexpress.boot.annotation.Controller;
import org.summerboot.jexpress.boot.annotation.GrpcService;
import org.summerboot.jexpress.boot.annotation.Service;
import org.summerboot.jexpress.boot.annotation.Unique;
import org.summerboot.jexpress.boot.annotation.Version;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.boot.config.annotation.ImportResource;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.util.ApplicationUtil;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

public abstract class SummerSingularity
implements BootConstant {
    protected static Logger log;
    protected final StringBuilder memo = new StringBuilder();
    protected final Class primaryClass;
    protected String jvmStartCommand;
    protected boolean jmxRequired;
    protected String callerRootPackageName;
    protected String appVersionLong = "SummerBoot.jExpress 2.3.2";
    protected String appVersionShort = "SummerBoot.jExpress 2.3.2";
    protected final List<String> availableUniqueTagOptions = new ArrayList<String>();
    protected final Map<String, ConfigMetadata> scanedJExpressConfigs = new LinkedHashMap<String, ConfigMetadata>();
    protected final Set<String> availableImplTagOptions = new HashSet<String>();
    protected final Set<Class<? extends BindableService>> gRPCBindableServiceImplClasses = new HashSet<Class<? extends BindableService>>();
    protected final Set<Class<ServerServiceDefinition>> gRPCServerServiceDefinitionImplClasses = new HashSet<Class<ServerServiceDefinition>>();
    protected boolean hasControllers = false;
    protected boolean hasGRPCImpl = false;
    protected boolean hasAuthImpl = false;
    protected final Map<Class, Map<String, List<ServiceMetadata>>> scanedServiceBindingMap = new HashMap<Class, Map<String, List<ServiceMetadata>>>();
    protected static final String SUN_JAVA_COMMAND = "sun.java.command";

    protected SummerSingularity(Class callerClass) {
        this.primaryClass = callerClass == null ? this.getClass() : callerClass;
        this.singularity();
        this.bigBang();
    }

    private void singularity() {
        this.memo.setLength(0);
        this.jvmStartCommand = null;
        this.jmxRequired = false;
        this.callerRootPackageName = null;
        this.appVersionLong = "SummerBoot.jExpress 2.3.2";
        this.appVersionShort = "SummerBoot.jExpress 2.3.2";
        this.availableUniqueTagOptions.clear();
        this.scanedJExpressConfigs.clear();
        this.availableImplTagOptions.clear();
        this.gRPCBindableServiceImplClasses.clear();
        this.gRPCServerServiceDefinitionImplClasses.clear();
        this.hasControllers = false;
        this.hasGRPCImpl = false;
        this.hasAuthImpl = false;
    }

    private <T extends SummerApplication> T bigBang() {
        this.memo.append("\n\t- deployee callerClass=").append(this.primaryClass.getName());
        this.callerRootPackageName = ReflectionUtil.getRootPackageName(this.primaryClass);
        this.jvmStartCommand = this.scanJVM_StartCommand();
        this.scanAnnotation_Version(this.primaryClass);
        System.setProperty("appPackage", this.callerRootPackageName);
        System.setProperty("appappName", this.appVersionShort);
        System.setProperty("version", this.appVersionLong);
        this.memo.append("\n\t- callerRootPackageName=").append(this.callerRootPackageName);
        String error2 = this.scanAnnotation_Unique(this.callerRootPackageName, this.memo, new String[0]);
        if (error2 != null) {
            System.out.println(error2);
            System.exit(1);
        }
        this.scanAnnotation_JExpressConfigImportResource("org.summerboot.jexpress", this.callerRootPackageName);
        this.scanImplementation_gRPC(this.callerRootPackageName);
        this.scanAnnotation_Controller(this.callerRootPackageName);
        this.scanAnnotation_Service(this.callerRootPackageName);
        this.scanAnnotation_DeclareRoles(this.callerRootPackageName);
        return (T)((SummerApplication)this);
    }

    protected String scanJVM_StartCommand() {
        String OS = System.getProperty("os.name").toLowerCase();
        boolean isWindows = OS.contains("win");
        String java = System.getProperty("java.home") + "/bin/java";
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer vmArgsOneLine = new StringBuffer();
        for (String arg : vmArguments) {
            if (!arg.contains("-agentlib")) {
                vmArgsOneLine.append(arg);
                vmArgsOneLine.append(" ");
            }
            if (!arg.contains("com.sun.management.jmxremote.port")) continue;
            this.jmxRequired = true;
        }
        StringBuilder cmd = isWindows ? new StringBuilder("\"" + java + "\" " + vmArgsOneLine) : new StringBuilder(java + " " + vmArgsOneLine);
        String[] mainCommand = System.getProperty(SUN_JAVA_COMMAND).split(" ");
        if (mainCommand[0].endsWith(".jar")) {
            cmd.append("-jar ").append(new File(mainCommand[0]).getPath());
        } else {
            cmd.append("-cp \"").append(System.getProperty("java.class.path")).append("\" ").append(mainCommand[0]);
        }
        for (int i = 1; i < mainCommand.length; ++i) {
            cmd.append(" ");
            cmd.append(mainCommand[i]);
        }
        return cmd.toString();
    }

    protected void scanAnnotation_Version(Class callerClass) {
        Version v = callerClass.getAnnotation(Version.class);
        if (v != null) {
            this.appVersionShort = v.logFileName();
            if (StringUtils.isBlank((CharSequence)this.appVersionShort)) {
                this.appVersionShort = v.value()[0];
            }
            this.appVersionLong = Arrays.toString(v.value());
        } else {
            this.appVersionShort = "app";
        }
        this.memo.append("\n\t- callerVersion=").append(this.appVersionLong);
    }

    protected String scanAnnotation_Unique(String rootPackageName, StringBuilder sb, String ... displayByTags) {
        Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Unique.class, rootPackageName);
        StringBuilder errors = new StringBuilder();
        boolean error2 = false;
        for (Class<?> classWithUniqueValues : classes) {
            if (!classWithUniqueValues.isInterface()) {
                error2 = true;
                errors.append("\n\t @Unique can only apply on interfaces, ").append(classWithUniqueValues).append(" is not an interface");
                continue;
            }
            Unique u = classWithUniqueValues.getAnnotation(Unique.class);
            String tag = u.name();
            this.availableUniqueTagOptions.add(tag);
            Class uniqueType = u.type();
            List<String> tags = List.of(displayByTags);
            try {
                Map<Object, Set<String>> duplicated = ApplicationUtil.checkDuplicateFields(classWithUniqueValues, uniqueType);
                if (!duplicated.isEmpty()) {
                    String report = BeanUtil.toJson(duplicated, true, false);
                    return "Duplicated " + uniqueType.getSimpleName() + " values in " + classWithUniqueValues.getSimpleName() + " " + report;
                }
                if (!tags.contains(tag)) continue;
                HashMap results = new HashMap();
                ReflectionUtil.loadFields(classWithUniqueValues, uniqueType, results, false);
                Map sorted = results.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (e1, e2) -> e1, LinkedHashMap::new));
                String json = BeanUtil.toJson(sorted, true, false);
                sb.append("\n").append(tag).append("=").append(json);
            }
            catch (Throwable ex) {
                throw new RuntimeException("check unique failed on package " + rootPackageName + ".*", ex);
            }
        }
        if (error2) {
            throw new RuntimeException(errors.toString());
        }
        return null;
    }

    protected void scanAnnotation_JExpressConfigImportResource(String ... rootPackageNames) {
        Set<String> pakcages = Set.copyOf(List.of(rootPackageNames));
        HashSet<Class<JExpressConfig>> classesAll = new HashSet<Class<JExpressConfig>>();
        for (String string : pakcages) {
            Set<Class<JExpressConfig>> jExpressConfigClasses = ReflectionUtil.getAllImplementationsByInterface(JExpressConfig.class, string);
            classesAll.addAll(jExpressConfigClasses);
        }
        for (Class clazz : classesAll) {
            String key;
            int mod = clazz.getModifiers();
            if (Modifier.isAbstract(mod) || Modifier.isInterface(mod) || this.scanedJExpressConfigs.containsKey(key = clazz.getSimpleName())) continue;
            String configFileName = null;
            ImportResource ir = clazz.getAnnotation(ImportResource.class);
            if (ir != null) {
                configFileName = ir.value();
                String checkImplTagUsed = ir.checkImplTagUsed();
                boolean loadWhenImplTagUsed = ir.loadWhenImplTagUsed();
                ConfigMetadata metadata = new ConfigMetadata(configFileName, clazz, null, checkImplTagUsed, loadWhenImplTagUsed);
                this.scanedJExpressConfigs.put(key, metadata);
                this.memo.append("\n\t- scan.JExpressConfig.ImportResource:").append(key).append("=").append(metadata);
            }
            this.memo.append("\n\t- cfg.scaned=").append(clazz.getName()).append(", file=").append(configFileName);
        }
    }

    protected void scanImplementation_gRPC(String ... pakcages) {
        for (String rootPackageName : pakcages) {
            Set<Class<?>> gRPCServerClasses = ReflectionUtil.getAllImplementationsByAnnotation(GrpcService.class, rootPackageName);
            for (Class<?> gRPCServerClass : gRPCServerClasses) {
                if (BindableService.class.isAssignableFrom(gRPCServerClass)) {
                    this.gRPCBindableServiceImplClasses.add(gRPCServerClass);
                    continue;
                }
                if (!ServerServiceDefinition.class.equals(gRPCServerClass)) continue;
                this.gRPCServerServiceDefinitionImplClasses.add(gRPCServerClass);
            }
        }
        this.hasGRPCImpl = !this.gRPCServerServiceDefinitionImplClasses.isEmpty() || !this.gRPCBindableServiceImplClasses.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    protected void scanAnnotation_Controller(String ... rootPackageNames) {
        void var5_7;
        HashSet classesAll = new HashSet();
        String[] stringArray = rootPackageNames;
        int n = stringArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            String rootPackageName = stringArray[var5_7];
            Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Controller.class, rootPackageName);
            classesAll.addAll(classes);
            ++var5_7;
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (Class clazz : classesAll) {
            Controller a = clazz.getAnnotation(Controller.class);
            String implTag = a.implTag();
            tags.add(implTag);
        }
        List serviceImplTags = tags.stream().distinct().collect(Collectors.toList());
        serviceImplTags.removeAll(Collections.singleton(null));
        serviceImplTags.removeAll(Collections.singleton(""));
        serviceImplTags.removeAll(Collections.singleton(""));
        this.availableImplTagOptions.addAll(serviceImplTags);
    }

    protected List<String> scanAnnotation_Service(String ... rootPackageNames) {
        HashSet classesAll = new HashSet();
        for (String rootPackageName : rootPackageNames) {
            Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Service.class, rootPackageName);
            classesAll.addAll(classes);
        }
        return this.scanAnnotation_Service(classesAll);
    }

    protected List<String> scanAnnotation_Service(Set<Class<?>> classesAll) {
        ArrayList<String> tags = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (Class<?> serviceImplClass : classesAll) {
            Service serviceAnnotation = serviceImplClass.getAnnotation(Service.class);
            if (serviceAnnotation == null) continue;
            String named = serviceAnnotation.named().trim();
            String implTag = serviceAnnotation.implTag().trim();
            tags.add(implTag);
            String uniqueKey = implTag + named;
            Class[] bindingClasses = serviceAnnotation.binding();
            if (bindingClasses != null && bindingClasses.length > 0) {
                for (Class bindingClass : bindingClasses) {
                    if (!bindingClass.isAssignableFrom(serviceImplClass)) {
                        List<Class> interfaces = ReflectionUtil.getAllInterfaces(serviceImplClass, true);
                        List<Class> superclasses = ReflectionUtil.getAllSuperClasses(serviceImplClass);
                        interfaces.addAll(superclasses);
                        interfaces.remove(Object.class);
                        sb.append("\n\t").append(serviceImplClass).append(" specifies @").append(Service.class.getSimpleName()).append("(binding=").append(bindingClass.getSimpleName()).append(".class), which is not in its Interfaces:").append(interfaces);
                        continue;
                    }
                    this.scanAnnotation_Service_Add2BindingMap(bindingClass, uniqueKey, new ServiceMetadata(serviceImplClass, named, implTag));
                }
                continue;
            }
            List<Class> declaredInterfaces = ReflectionUtil.getAllInterfaces(serviceImplClass, false);
            if (declaredInterfaces.isEmpty()) {
                List<Class> superInterfaces = ReflectionUtil.getAllInterfaces(serviceImplClass.getSuperclass(), true);
                if (superInterfaces.isEmpty()) {
                    sb.append("\n\t").append(serviceImplClass).append(" does not implement any interfaces.");
                    continue;
                }
                sb.append("\n\t").append(serviceImplClass).append(" needs to specify the binding interface @").append(Service.class.getSimpleName()).append("(binding=TheMissingInterface.class), which implemented by supper class: ").append(superInterfaces);
                continue;
            }
            for (Class bindingClass : declaredInterfaces) {
                this.scanAnnotation_Service_Add2BindingMap(bindingClass, uniqueKey, new ServiceMetadata(serviceImplClass, named, implTag));
            }
        }
        this.scanAnnotation_Service_ValidateBindingMap(sb);
        String error2 = sb.toString();
        if (!error2.isBlank()) {
            System.out.println("IOC Code error:" + sb);
            System.exit(1);
        }
        List<String> serviceImplTags = tags.stream().distinct().collect(Collectors.toList());
        serviceImplTags.removeAll(Collections.singleton(null));
        serviceImplTags.removeAll(Collections.singleton(""));
        serviceImplTags.removeAll(Collections.singleton(""));
        this.availableImplTagOptions.addAll(serviceImplTags);
        return serviceImplTags;
    }

    protected void scanAnnotation_Service_Add2BindingMap(Class bindingClass, String uniqueKey, ServiceMetadata service) {
        List<ServiceMetadata> serviceImplList;
        this.memo.append("\n\t- scan.taggedservice.add to guiceModule.bind(").append(bindingClass.getName()).append(").to(").append(service).append("), uniqueKey=").append(uniqueKey);
        Map<String, List<ServiceMetadata>> taggeServicedMap = this.scanedServiceBindingMap.get(bindingClass);
        if (taggeServicedMap == null) {
            taggeServicedMap = new HashMap<String, List<ServiceMetadata>>();
            this.scanedServiceBindingMap.put(bindingClass, taggeServicedMap);
        }
        if ((serviceImplList = taggeServicedMap.get(uniqueKey)) == null) {
            serviceImplList = new ArrayList<ServiceMetadata>();
            taggeServicedMap.put(uniqueKey, serviceImplList);
        }
        serviceImplList.add(service);
    }

    protected void scanAnnotation_Service_ValidateBindingMap(StringBuilder sb) {
        for (Class keyBindingClass : this.scanedServiceBindingMap.keySet()) {
            Map<String, List<ServiceMetadata>> taggeServicedMap = this.scanedServiceBindingMap.get(keyBindingClass);
            for (String keyImplTag : taggeServicedMap.keySet()) {
                List<ServiceMetadata> serviceImplList = taggeServicedMap.get(keyImplTag);
                int size = serviceImplList.size();
                if (size == 1) continue;
                sb.append("\nIOC ").append(keyBindingClass).append(" required a single bean, but ").append(size).append(" were found with the same useImplTag(").append(keyImplTag).append("): ").append(serviceImplList);
            }
        }
    }

    protected void scanAnnotation_DeclareRoles(String ... rootPackageNames) {
        TreeSet<String> declareRoles = new TreeSet<String>();
        HashSet classesAll = new HashSet();
        for (String rootPackageName : rootPackageNames) {
            Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Controller.class, rootPackageName);
            classesAll.addAll(classes);
        }
        this.hasControllers = !classesAll.isEmpty();
        for (Class clazz : classesAll) {
            DeclareRoles drs = clazz.getAnnotation(DeclareRoles.class);
            if (drs != null) {
                String[] roles = drs.value();
                declareRoles.addAll(Arrays.asList(roles));
            }
            List<Method> methods = ReflectionUtil.getDeclaredAndSuperClassesMethods(clazz, true);
            for (Method javaMethod : methods) {
                RolesAllowed ra = javaMethod.getAnnotation(RolesAllowed.class);
                if (ra == null) continue;
                String[] roles = ra.value();
                declareRoles.addAll(Arrays.asList(roles));
            }
        }
        AuthConfig authCfg = AuthConfig.cfg;
        authCfg.addDeclareRoles(declareRoles);
        this.memo.append("\n\t- scan.DeclareRoles=").append(declareRoles);
        this.hasAuthImpl = !authCfg.getDeclareRoles().isEmpty();
    }

    protected static class ConfigMetadata {
        final Class cfgClass;
        final String configFileName;
        final JExpressConfig instance;
        final String checkImplTagUsed;
        final boolean loadWhenImplTagUsed;

        ConfigMetadata(String configFileName, Class cfgClass, JExpressConfig instance, String checkImplTagUsed, boolean loadWhenImplTagUsed) {
            this.configFileName = configFileName;
            this.cfgClass = cfgClass;
            this.instance = instance;
            this.checkImplTagUsed = checkImplTagUsed;
            this.loadWhenImplTagUsed = loadWhenImplTagUsed;
        }

        public String toString() {
            return "ConfigMetadata{cfgClass=" + this.cfgClass.getName() + ", configFileName=" + this.configFileName + ", instance=" + this.instance + ", checkImplTagUsed=" + this.checkImplTagUsed + ", loadWhenImplTagUsed=" + this.loadWhenImplTagUsed + "}";
        }
    }

    public static class ServiceMetadata {
        final Class serviceImplClass;
        final String named;
        final String implTag;

        public ServiceMetadata(Class serviceImplClass, String named, String implTag) {
            this.serviceImplClass = serviceImplClass;
            this.named = named;
            this.implTag = implTag;
        }

        public String toString() {
            return "ServiceImpl{" + this.serviceImplClass.getName() + ", named=" + this.named + ", implTag=" + this.implTag + "}";
        }

        public Class getServiceImplClass() {
            return this.serviceImplClass;
        }

        public String getNamed() {
            return this.named;
        }

        public String getImplTag() {
            return this.implTag;
        }
    }
}

