/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.ws.rs;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import org.summerboot.jexpress.boot.annotation.Log;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.nio.server.domain.ServiceRequest;
import org.summerboot.jexpress.nio.server.ws.rs.PingController;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.security.auth.Authenticator;
import org.summerboot.jexpress.security.auth.Caller;

@Singleton
@OpenAPIDefinition(info=@Info(title="Default Admin API", version="SummerBoot.jExpress 2.3.2", description="To change to yours, just add @OpenAPIDefinition.info", contact=@Contact(name="summerboot.org", email="")), servers={@Server(url="https://localhost:8211", description="Local Development server")})
@SecurityScheme(name="BearerAuth", scheme="bearer", type=SecuritySchemeType.HTTP, bearerFormat="Authorization: Bearer <token>")
public abstract class BootController
extends PingController {
    public static final String TAG_APP_ADMIN = "App Admin";
    public static final String TAG_USER_AUTH = "App User Authentication";
    @Inject
    protected AuthTokenCache authTokenCache;
    @Inject
    protected HealthInspector healthInspector;
    @Inject
    protected Authenticator auth;
    private String version;

    @GET
    @Path(value="/version")
    @Produces(value={"text/html"})
    @RolesAllowed(value={"AppAdmin"})
    @Operation(tags={"App Admin"}, summary="Check application version", description="get running application version information", responses={@ApiResponse(responseCode="200", description="running application version"), @ApiResponse(responseCode="401", description="caller is not in Admin role", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="4XX", description="A fault has taken place on client side. Client should not retransmit the same request again, but fix the error first.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="5XX", description="Something happened on the server side. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    public void version(@Parameter(hidden=true) ServiceContext context) {
        context.txt(this.getVersion()).status(HttpResponseStatus.OK);
    }

    protected String getVersion() {
        if (this.version == null) {
            this.version = System.getProperty("version");
        }
        return this.version;
    }

    @GET
    @Path(value="/inspection")
    @Produces(value={"text/html"})
    @RolesAllowed(value={"AppAdmin"})
    @Operation(tags={"App Admin"}, summary="Run application self inspection", description="get running application health information", responses={@ApiResponse(responseCode="200", description="inspection success with current version"), @ApiResponse(responseCode="401", description="caller is not in Admin role", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="500", description="inspection error result"), @ApiResponse(responseCode="4XX", description="A fault has taken place on client side. Client should not retransmit the same request again, but fix the error first.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="5XX", description="Something happened on the server side. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    public void inspect(@Parameter(hidden=true) ServiceContext context) {
        if (this.healthInspector == null) {
            context.error(new Err(50, null, "HealthInspector not provided", null)).status(HttpResponseStatus.NOT_IMPLEMENTED);
            return;
        }
        List<Err> error2 = this.healthInspector.ping(true);
        if (error2 == null || error2.isEmpty()) {
            context.txt("inspection passed").errors(null).status(HttpResponseStatus.OK);
        } else {
            context.errors(error2).status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/status")
    @RolesAllowed(value={"AppAdmin"})
    @Operation(tags={"App Admin"}, summary="Graceful shutdown by changing service status", description="pause service if pause param is true, otherwise resume service", responses={@ApiResponse(responseCode="204", description="success"), @ApiResponse(responseCode="401", description="caller is not in Admin role", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="4XX", description="A fault has taken place on client side. Client should not retransmit the same request again, but fix the error first.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="5XX", description="Something happened on the server side. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    public void changeStatus(@QueryParam(value="pause") boolean pause, @Parameter(hidden=true) ServiceContext context) throws IOException {
        HealthMonitor.setPauseStatus(pause, "request by " + context.caller());
        context.status(HttpResponseStatus.NO_CONTENT);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/j_security_check")
    @Log(requestBody=false, responseHeader=false)
    @Operation(tags={"App User Authentication"}, summary="User login", description="User login", responses={@ApiResponse(responseCode="201", description="success and return JWT token in header X-AuthToken", headers={@Header(name="X-AuthToken", schema=@Schema(type="string"), description="Generated JWT")}, content={@Content(schema=@Schema(implementation=Caller.class))}), @ApiResponse(responseCode="401", description="Invalid username or password", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="4XX", description="A fault has taken place on client side. Client should not retransmit the same request again, but fix the error first.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="5XX", description="Something happened on the server side. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))})})
    public Caller login(@Parameter(required=true) @Nonnull @FormParam(value="j_username") String uid, @FormParam(value="j_password") String pwd, @Parameter(hidden=true) ServiceContext context) throws IOException, NamingException {
        if (this.auth == null) {
            context.error(new Err(50, null, "Authenticator not provided", null)).status(HttpResponseStatus.NOT_IMPLEMENTED);
            return null;
        }
        String jwt = this.auth.login(uid, pwd, null, AuthConfig.cfg.getJwtTTLMinutes(), context);
        if (jwt == null) {
            context.status(HttpResponseStatus.UNAUTHORIZED);
        } else {
            context.responseHeader("X-AuthToken", jwt).status(HttpResponseStatus.CREATED);
        }
        return context.caller();
    }

    @DELETE
    @Path(value="/logout")
    @Operation(tags={"App User Authentication"}, summary="User logout", description="User logout", responses={@ApiResponse(responseCode="204", description="success"), @ApiResponse(responseCode="4XX", description="A fault has taken place on client side. Client should not retransmit the same request again, but fix the error first.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="5XX", description="Something happened on the server side. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    public void logout(@Parameter(hidden=true) ServiceRequest request, @Parameter(hidden=true) ServiceContext context) {
        if (this.auth == null) {
            context.error(new Err(50, null, "Authenticator not provided", null)).status(HttpResponseStatus.NOT_IMPLEMENTED);
            return;
        }
        this.auth.logout(request.getHttpHeaders(), this.authTokenCache, context);
        context.status(HttpResponseStatus.NO_CONTENT);
    }

    @Operation(hidden=true)
    @POST
    @Path(value="/loadtest")
    @RolesAllowed(value={"AppAdmin"})
    public void loadTestBenchmarkPost1(ServiceRequest request, ServiceContext context, @QueryParam(value="delayMilsec") long wait) {
        if (wait > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(wait);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        context.status(HttpResponseStatus.OK).txt(request.getHttpRequestPath() + "?delayMilsec=" + wait + request.getHttpPostRequestBody());
    }

    @Operation(hidden=true)
    @POST
    @Path(value="/loadtest/{delayMilsec}")
    public void loadTestBenchmarkPost2(ServiceRequest request, ServiceContext context, @PathParam(value="delayMilsec") long wait) {
        if (wait > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(wait);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        context.status(HttpResponseStatus.OK).txt(request.getHttpRequestPath() + request.getHttpPostRequestBody());
    }

    @Operation(hidden=true)
    @GET
    @Path(value="/loadtest")
    @RolesAllowed(value={"AppAdmin"})
    public void loadTestBenchmarkGet1(ServiceRequest request, ServiceContext context, @QueryParam(value="delayMilsec") long wait) {
        if (wait > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(wait);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        context.status(HttpResponseStatus.OK).txt(request.getHttpRequestPath() + "?delayMilsec=" + wait);
    }

    @Operation(hidden=true)
    @GET
    @Path(value="/loadtest/{delayMilsec}")
    public void loadTestBenchmarkGet2(ServiceRequest request, ServiceContext context, @PathParam(value="delayMilsec") long wait) {
        if (wait > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(wait);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        context.status(HttpResponseStatus.OK).txt(request.getHttpRequestPath());
    }
}

