/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.security.EncryptorUtil;
import org.summerboot.jexpress.util.FormatterUtil;

public final class SecurityUtil {
    public static final HostnameVerifier DO_NOT_VERIFY_REMOTE_IP = (hostname, session) -> true;
    public static final HostnameVerifier hostnameVerifier = (hostname, session) -> {
        HostnameVerifier hv = HttpsURLConnection.getDefaultHostnameVerifier();
        return hv.verify("hostname", session);
    };
    public static final String[] CIPHER_SUITES = new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_NULL_SHA", "TLS_ECDH_RSA_WITH_NULL_SHA", "TLS_ECDH_anon_WITH_NULL_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_NULL_SHA,TLS_ECDHE_RSA_WITH_NULL_SHA"};
    public static final Pattern hasUppercase = Pattern.compile("[A-Z]");
    public static final Pattern hasLowercase = Pattern.compile("[a-z]");
    public static final Pattern hasNumber = Pattern.compile("\\d");
    public static final Pattern hasSpecialChar = Pattern.compile("[^a-zA-Z0-9 ]");

    public static String encrypt(String plainData, boolean warped) throws GeneralSecurityException {
        int i;
        if (warped) {
            plainData = FormatterUtil.getInsideParenthesesValue(plainData);
        }
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, EncryptorUtil.SCERET_KEY);
        byte[] utf8 = plainData.getBytes(StandardCharsets.UTF_8);
        byte[] encryptedData = cipher.doFinal(utf8);
        String result = Base64.getEncoder().encodeToString(encryptedData);
        for (i = 0; i < utf8.length; ++i) {
            utf8[i] = 0;
        }
        for (i = 0; i < encryptedData.length; ++i) {
            encryptedData[i] = 0;
        }
        return result;
    }

    public static char[] decrypt2Char(String encrypted, boolean warped) throws GeneralSecurityException {
        String decrypted = SecurityUtil.decrypt(encrypted, warped);
        return decrypted == null ? null : decrypted.toCharArray();
    }

    public static String decrypt(String encrypted, boolean warped) throws GeneralSecurityException {
        byte[] utf8;
        if (warped) {
            encrypted = FormatterUtil.getInsideParenthesesValue(encrypted);
        }
        if ((utf8 = SecurityUtil.decryptEx(encrypted)) == null) {
            return null;
        }
        String result = new String(utf8, StandardCharsets.UTF_8);
        for (int i = 0; i < utf8.length; ++i) {
            utf8[i] = 0;
        }
        return result;
    }

    public static byte[] decryptEx(String encrypted) throws GeneralSecurityException {
        if (encrypted == null) {
            return null;
        }
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, EncryptorUtil.SCERET_KEY);
        byte[] decodedData = Base64.getDecoder().decode(encrypted);
        byte[] result = cipher.doFinal(decodedData);
        for (int i = 0; i < decodedData.length; ++i) {
            decodedData[i] = 0;
        }
        return result;
    }

    public static String base64Decode(String base64Text) {
        byte[] dec = Base64.getDecoder().decode(base64Text);
        return new String(dec, StandardCharsets.UTF_8);
    }

    public static String base64Encode(String plain) {
        return Base64.getEncoder().encodeToString(plain.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean validatePassword(String pwd, int length) {
        if (StringUtils.isBlank((CharSequence)pwd)) {
            return false;
        }
        if (pwd.length() < length) {
            return false;
        }
        if (!hasUppercase.matcher(pwd).find()) {
            return false;
        }
        if (!hasLowercase.matcher(pwd).find()) {
            return false;
        }
        if (!hasNumber.matcher(pwd).find()) {
            return false;
        }
        return hasSpecialChar.matcher(pwd).find();
    }
}

