/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.operator.OperatorCreationException;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.boot.config.annotation.ImportResource;
import org.summerboot.jexpress.integration.ldap.LdapAgent;
import org.summerboot.jexpress.integration.ldap.LdapSSLConnectionFactory1;
import org.summerboot.jexpress.security.EncryptorUtil;
import org.summerboot.jexpress.security.JwtUtil;
import org.summerboot.jexpress.security.auth.RoleMapping;

@ImportResource(value="cfg_auth.properties")
public class AuthConfig
extends BootConfig {
    public static final AuthConfig cfg = new AuthConfig();
    @ConfigHeader(title="1.1 LDAP connection settings")
    @Config(key="ldap.type.AD", desc="set it true only when LDAP is implemented by Microsoft Active Directory (AD)\nfalse when use others like Open LDAP, IBM Tivoli, Apache")
    private volatile boolean typeAD = false;
    @Config(key="ldap.host", desc="LDAP will be disabled when host is not provided")
    private volatile String ldapHost;
    @Config(key="ldap.port", desc="LDAP 389, LDAP over SSL 636, AD global 3268, AD global voer SSL 3269")
    private volatile int ldapPort;
    @Config(key="ldap.baseDN")
    private volatile String ldapBaseDN;
    @Config(key="ldap.bindingUserDN")
    private volatile String bindingUserDN;
    @JsonIgnore
    @Config(key="ldap.bindingPassword", validate=Config.Validate.Encrypted, required=false)
    private volatile String bindingPassword;
    @Config(key="ldap.PasswordAlgorithm", required=false)
    private volatile String passwordAlgorithm = "SHA3-256";
    @Config(key="ldap.schema.TenantGroup.ou", required=false)
    private volatile String ldapScheamTenantGroupOU;
    @ConfigHeader(title="1.2 LDAP Client keystore")
    @Config(key="ldap.SSLConnectionFactoryClass", required=false)
    private volatile String ldapSSLConnectionFactoryClassName = LdapSSLConnectionFactory1.class.getName();
    @Config(key="ldap.ssl.protocol")
    private volatile String ldapTLSProtocol = "TLSv1.3";
    @JsonIgnore
    @Config(key="ldap.ssl.KeyStore", StorePwdKey="ldap.ssl.KeyStorePwd", AliasKey="ldap.ssl.KeyAlias", AliasPwdKey="ldap.ssl.KeyPwd")
    private volatile KeyManagerFactory kmf;
    @ConfigHeader(title="1.3 LDAP Client truststore")
    @JsonIgnore
    @Config(key="ldap.ssl.TrustStore", StorePwdKey="ldap.ssl.TrustStorePwd")
    private volatile TrustManagerFactory tmf;
    private volatile Properties ldapConfig;
    @ConfigHeader(title="2. JWT")
    @Config(key="jwt.asymmetric.SigningKeyFile", desc="Path to an encrypted RSA private key file in PKCS#8 format with minimal 2048 key size. To generate the keypair manually:\n1. generate keypair: openssl genrsa -des3 -out keypair.pem 4096 \n2. export public key: openssl rsa -in keypair.pem -outform PEM -pubout -out public.pem \n3. export private key: openssl rsa -in keypair.pem -out private_unencrypted.pem -outform PEM \n4. encrypt and convert private key from PKCS#1 to PKCS#8: openssl pkcs8 -topk8 -inform PEM -outform PEM -in private_unencrypted.pem -out private.pem")
    private volatile File privateKeyFile;
    @JsonIgnore
    @Config(key="jwt.asymmetric.SigningKeyPwd", validate=Config.Validate.Encrypted, required=false, desc="The password of this private key")
    private volatile String privateKeyPwd;
    @Config(key="jwt.asymmetric.ParsingKeyFile", desc="Path to the public key file corresponding to this private key")
    private volatile File publicKeyFile;
    @JsonIgnore
    @Config(key="jwt.symmetric.key", validate=Config.Validate.Encrypted, required=false, desc="HMAC-SHA key for bothe signing and parsing, it will be ignored when asymmetric one is specified.\nUse this command to generate this key: java -jar <app>.jar -jwt <HS256, HS384, HS512>")
    private volatile String symmetricKey;
    @JsonIgnore
    private volatile Key jwtSigningKey;
    @JsonIgnore
    private volatile JwtParser jwtParser;
    @Config(key="jwt.ttl.minutes")
    private volatile int jwtTTLMinutes = 1440;
    @Config(key="jwt.issuer")
    private volatile String jwtIssuer;
    @ConfigHeader(title="3. Role mapping", desc="Map the role with user group (no matter the group is defined in LDAP or DB)", format="roles.<role name>.groups=csv list\nroles.<role name>.users=csv list", example="the following example maps one group(AppAdmin_Group) and two users(johndoe, janejoe) to a role(AppAdmin)\nroles.AppAdmin.groups=AppAdmin_Group\nroles.AppAdmin.users=johndoe, janejoe", callbackmethodname4Dump="generateTemplate_DumpRoleMapping")
    private Map<String, RoleMapping> roles = new HashMap<String, RoleMapping>();
    private final Set<String> declareRoles = new TreeSet<String>();

    public static void main(String[] args) {
        String t = AuthConfig.generateTemplate(AuthConfig.class);
        System.out.println(t);
    }

    protected AuthConfig() {
    }

    @Override
    public AuthConfig temp() {
        AuthConfig temp = (AuthConfig)super.temp();
        AuthConfig current = cfg;
        temp.addDeclareRoles(current.getDeclareRoles());
        return temp;
    }

    @Override
    public void shutdown() {
    }

    protected void generateTemplate_DumpRoleMapping(StringBuilder sb) {
        for (String role : this.declareRoles) {
            sb.append("#roles.").append(role).append(".groups=\n");
            sb.append("#roles.").append(role).append(".users=\n");
        }
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws IOException, OperatorCreationException, GeneralSecurityException {
        if (this.ldapHost != null) {
            boolean isSSL;
            boolean bl = isSSL = this.kmf != null;
            if (isSSL) {
                String key2 = "ldap.SSLConnectionFactoryClass";
                try {
                    Class<?> sslFactoryClass = Class.forName(this.ldapSSLConnectionFactoryClassName);
                    Method method = sslFactoryClass.getMethod("init", KeyManagerFactory.class, TrustManagerFactory.class, String.class);
                    method.invoke(null, this.kmf, this.tmf, this.ldapTLSProtocol);
                }
                catch (ClassNotFoundException ex) {
                    helper.addError("invalid \"" + key2 + ", error=" + ex);
                }
                catch (NoSuchMethodException ex) {
                    helper.addError("invalid \"" + key2 + "missing method: public static void init(KeyManagerFactory kmf, TrustManagerFactory tmf, String protocol), error=" + ex);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    helper.addError("invalid \"" + key2 + "failed to invoke method: public static void init(KeyManagerFactory kmf, TrustManagerFactory tmf, String protocol), error=" + ex);
                }
            }
            this.ldapConfig = LdapAgent.buildCfg(this.ldapHost, this.ldapPort, isSSL, this.ldapSSLConnectionFactoryClassName, this.ldapTLSProtocol, this.bindingUserDN, this.bindingPassword);
        }
        if (this.symmetricKey != null) {
            this.jwtSigningKey = JwtUtil.parseSigningKey(this.symmetricKey);
            this.jwtParser = Jwts.parserBuilder().setSigningKey(this.jwtSigningKey).build();
        }
        if (this.privateKeyFile != null) {
            this.jwtSigningKey = EncryptorUtil.loadPrivateKey(this.privateKeyFile, this.privateKeyPwd.toCharArray());
        }
        if (this.publicKeyFile != null) {
            PublicKey publicKey = EncryptorUtil.loadPublicKey(EncryptorUtil.KeyFileType.PKCS12, this.publicKeyFile);
            this.jwtParser = Jwts.parserBuilder().setSigningKey((Key)publicKey).build();
        }
        Set<Object> keys = props.keySet();
        HashMap rolesTemp = new HashMap();
        keys.forEach(key -> {
            String name = key.toString();
            if (name.startsWith("roles.")) {
                String[] names = name.split("\\.");
                String roleName = names[1];
                if (!this.declareRoles.contains(roleName)) {
                    helper.addError("Undefined role: (\"" + roleName + "\") is not defined in any @Controller @RolesAllowed(" + this.declareRoles + ") - line: " + key + "=" + props.getProperty(key.toString()));
                }
                RoleMapping.Type type = RoleMapping.Type.valueOf(names[2]);
                RoleMapping rm = (RoleMapping)rolesTemp.get(roleName);
                if (rm == null) {
                    rm = new RoleMapping(roleName);
                    rolesTemp.put(roleName, rm);
                }
                rm.add(type, props.getProperty(key.toString()));
            }
        });
        this.roles = Map.copyOf(rolesTemp);
        String error2 = helper.getError();
        if (error2 != null) {
            throw new IllegalArgumentException(error2);
        }
    }

    public String getLdapHost() {
        return this.ldapHost;
    }

    public int getLdapPort() {
        return this.ldapPort;
    }

    public String getLdapBaseDN() {
        return this.ldapBaseDN;
    }

    public String getBindingUserDN() {
        return this.bindingUserDN;
    }

    public String getLdapScheamTenantGroupOU() {
        return this.ldapScheamTenantGroupOU;
    }

    public String getPasswordAlgorithm() {
        return this.passwordAlgorithm;
    }

    public void setPasswordAlgorithm(String passwordAlgorithm) {
        this.passwordAlgorithm = passwordAlgorithm;
    }

    public String getLdapSSLConnectionFactoryClassName() {
        return this.ldapSSLConnectionFactoryClassName;
    }

    public String getLdapTLSProtocol() {
        return this.ldapTLSProtocol;
    }

    public boolean isTypeAD() {
        return this.typeAD;
    }

    @JsonIgnore
    public Properties getLdapConfig() {
        return this.ldapConfig;
    }

    @JsonIgnore
    public Key getJwtSigningKey() {
        return this.jwtSigningKey;
    }

    @JsonIgnore
    public JwtParser getJwtParser() {
        return this.jwtParser;
    }

    public String getJwtIssuer() {
        return this.jwtIssuer;
    }

    public int getJwtTTLMinutes() {
        return this.jwtTTLMinutes;
    }

    public RoleMapping getRole(String role) {
        return this.roles.get(role);
    }

    public Map<String, RoleMapping> getRoles() {
        return this.roles;
    }

    @JsonIgnore
    public String getBindingPassword() {
        return this.bindingPassword;
    }

    @JsonIgnore
    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    @JsonIgnore
    public TrustManagerFactory getTmf() {
        return this.tmf;
    }

    @JsonIgnore
    public File getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    @JsonIgnore
    public String getPrivateKeyPwd() {
        return this.privateKeyPwd;
    }

    @JsonIgnore
    public File getPublicKeyFile() {
        return this.publicKeyFile;
    }

    @JsonIgnore
    public String getSymmetricKey() {
        return this.symmetricKey;
    }

    public void addDeclareRoles(Set<String> scanedDeclareRoles) {
        this.declareRoles.addAll(Set.copyOf(scanedDeclareRoles));
    }

    public Set<String> getDeclareRoles() {
        return Set.copyOf(this.declareRoles);
    }
}

