/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.Inject;
import com.google.inject.Module;
import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import java.net.BindException;
import java.time.OffsetDateTime;
import java.util.Iterator;
import java.util.List;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.SummerBigBang;
import org.summerboot.jexpress.boot.SummerRunner;
import org.summerboot.jexpress.boot.config.ConfigChangeListener;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgr;
import org.summerboot.jexpress.i18n.I18n;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import org.summerboot.jexpress.nio.grpc.Counter;
import org.summerboot.jexpress.nio.grpc.GRPCServer;
import org.summerboot.jexpress.nio.grpc.GRPCServerConfig;
import org.summerboot.jexpress.nio.grpc.StatusReporter;
import org.summerboot.jexpress.nio.server.NioServer;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.util.ApplicationUtil;
import org.summerboot.jexpress.util.BeanUtil;

public abstract class SummerApplication
extends SummerBigBang {
    @Inject
    protected ConfigChangeListener configChangeListener;
    @Inject
    protected InstrumentationMgr instrumentationMgr;
    @Inject
    protected HealthInspector healthInspector;
    @Inject
    protected PostOffice postOffice;
    private GRPCServer gRPCServer;

    public static void run() {
        Module userOverrideModule = null;
        SummerApplication.run(userOverrideModule);
    }

    public static void run(Class callerClass, String[] args) {
        Module userOverrideModule = null;
        SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static void run(Module userOverrideModule) {
        StackTraceElement[] stackTrace;
        String[] mainCommand = ApplicationUtil.getApplicationArgs();
        int size = mainCommand.length;
        String[] args = size > 0 ? new String[size - 1] : ApplicationUtil.EMPTY_ARGS;
        String mainClassName = mainCommand[0];
        for (int i = 1; i < size; ++i) {
            args[i - 1] = mainCommand[i];
        }
        Class<?> callerClass = null;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            try {
                callerClass = Class.forName(stackTraceElement.getClassName());
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            try {
                callerClass = Class.forName(mainClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            throw new RuntimeException("Failed to find the caller class");
        }
        SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static void run(String[] args) {
        Module userOverrideModule = null;
        SummerApplication.run(userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Module userOverrideModule, String[] args) {
        StackTraceElement[] stackTrace;
        Class<?> callerClass = null;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            try {
                callerClass = Class.forName(stackTraceElement.getClassName());
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            throw new RuntimeException("Failed to find the caller class");
        }
        return SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Class callerClass, Module userOverrideModule, String argsStr) {
        String[] args = argsStr.split(" ");
        return SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T run(Class callerClass, Module userOverrideModule, String[] args) {
        SummerApplication app = new SummerApplication(callerClass, userOverrideModule, args){};
        app.start();
        return (T)app;
    }

    public static <T extends SummerApplication> T unittest(Class callerClass, Module userOverrideModule, String argsStr) {
        String[] args = argsStr.split(" ");
        return SummerApplication.unittest(callerClass, userOverrideModule, args);
    }

    public static <T extends SummerApplication> T unittest(Class callerClass, Module userOverrideModule, String ... args) {
        SummerApplication app = new SummerApplication(callerClass, userOverrideModule, args){};
        app.traceConfig();
        return (T)app;
    }

    private SummerApplication(Class callerClass, Module userOverrideModule, String ... args) {
        super(callerClass, userOverrideModule, args);
    }

    @Override
    protected Class getAddtionalI18n() {
        return null;
    }

    protected void traceConfig() {
        this.memo.append("\n\t- sys.prop.").append("version").append("=").append(System.getProperty("version"));
        this.memo.append("\n\t- sys.prop.").append("appPackage").append("=").append(System.getProperty("appPackage"));
        this.memo.append("\n\t- sys.prop.").append("appappName").append("=").append(System.getProperty("appappName"));
        this.memo.append("\n\t- sys.prop.").append("logDir").append("=").append(System.getProperty("logDir"));
        this.memo.append("\n\t- start: PostOffice=").append(this.postOffice.getClass().getName());
        this.memo.append("\n\t- start: HealthInspector=").append(this.healthInspector.getClass().getName());
        this.memo.append("\n\t- start: InstrumentationMgr=").append(this.instrumentationMgr.getClass().getName());
        log.trace(() -> this.memo.toString());
    }

    public void start() {
        this.traceConfig();
        if (this.configChangeListener != null) {
            ConfigUtil.setConfigChangeListener(this.configChangeListener);
        }
        SMTPClientConfig smtpCfg = SMTPClientConfig.cfg;
        if (this.postOffice != null) {
            this.postOffice.setAppVersion(this.appVersionLong);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.postOffice != null) {
                    this.postOffice.sendAlertSync(smtpCfg.getEmailToAppSupport(), "Shutdown at " + OffsetDateTime.now() + " - " + this.appVersionLong, "EOM", null, false);
                }
            }, "ShutdownHook.BootApp"));
        }
        try {
            if (this.instrumentationMgr != null) {
                this.instrumentationMgr.start("SummerBoot.jExpress 2.3.3");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(System.lineSeparator()).append("\tSelf Inspection Result: ");
            if (this.healthInspector != null) {
                List<Err> errors = this.healthInspector.ping(log);
                if (errors == null || errors.isEmpty()) {
                    sb.append("passed");
                    log.info((CharSequence)sb);
                } else {
                    Iterator inspectionReport;
                    try {
                        inspectionReport = BeanUtil.toJson(errors, true, true);
                    }
                    catch (Throwable ex) {
                        inspectionReport = "total " + errors.size();
                    }
                    sb.append((String)((Object)inspectionReport));
                    HealthMonitor.setHealthStatus(false, sb.toString(), this.healthInspector);
                }
            } else {
                sb.append("skipped");
                log.warn((CharSequence)sb);
            }
            SummerRunner.RunnerContext context = new SummerRunner.RunnerContext(this.cli, this.userSpecifiedConfigDir, this.guiceInjector, this.healthInspector, this.postOffice);
            for (SummerRunner summerRunner : this.summerRunners) {
                summerRunner.run(context);
            }
            log.trace("hasGRPCImpl.bs=" + this.gRPCBindableServiceImplClasses);
            log.trace("hasGRPCImpl.ssd=" + this.gRPCServerServiceDefinitionImplClasses);
            if (this.hasGRPCImpl) {
                BindableService impl;
                GRPCServerConfig gRPCCfg = GRPCServerConfig.cfg;
                this.gRPCServer = new GRPCServer(gRPCCfg.getBindingAddr(), gRPCCfg.getBindingPort(), gRPCCfg.getKmf(), gRPCCfg.getTmf());
                Counter gRPCCounter = this.gRPCServer.configThreadPool(gRPCCfg.getPoolCoreSize(), gRPCCfg.getPoolMaxSizeMaxSize(), gRPCCfg.getPoolQueueSize(), gRPCCfg.getKeepAliveSeconds());
                ServerBuilder serverBuilder = this.gRPCServer.serverBuilder();
                for (Class c : this.gRPCBindableServiceImplClasses) {
                    impl = (BindableService)this.guiceInjector.getInstance(c);
                    serverBuilder.addService(impl);
                    if (!(impl instanceof StatusReporter)) continue;
                    ((StatusReporter)impl).setCounter(gRPCCounter);
                }
                for (Class c : this.gRPCServerServiceDefinitionImplClasses) {
                    impl = (ServerServiceDefinition)this.guiceInjector.getInstance(c);
                    serverBuilder.addService((ServerServiceDefinition)impl);
                }
                this.gRPCServer.start();
            }
            log.trace("hasControllers=" + this.hasControllers);
            if (this.hasControllers) {
                NioServer.bind();
            }
            log.info(() -> I18n.info.launched.format(this.userSpecifiedResourceBundle, this.appVersionLong + " pid#" + BootConstant.PID));
            String fullConfigInfo = sb.toString();
            if (this.postOffice != null) {
                this.postOffice.sendAlertAsync(smtpCfg.getEmailToAppSupport(), "Started at " + OffsetDateTime.now(), fullConfigInfo, null, false);
            }
        }
        catch (BindException ex) {
            log.fatal("\nIn order to check which application is listening on a port, you can use the following command from the command line:\n\nFor Microsoft Windows:\n    netstat -ano | find \"80\" | find \"LISTEN\"\n    tasklist /fi \"PID eq <pid>\"\n     \nFor Linux:\n    netstat -anpe | grep \"80\" | grep \"LISTEN\" \n", (Throwable)ex);
            System.exit(1);
        }
        catch (Throwable ex) {
            log.fatal(I18n.info.unlaunched.format(this.userSpecifiedResourceBundle, new String[0]), ex);
            System.exit(1);
        }
    }

    public void stop() {
        if (this.gRPCServer != null) {
            this.gRPCServer.shutdown();
        }
        NioServer.shutdown();
        if (this.instrumentationMgr != null) {
            this.instrumentationMgr.shutdown();
        }
    }
}

