/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.cache;

import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.summerboot.jexpress.integration.cache.SimpleLocalCache;

@Singleton
public class SimpleLocalCacheImpl
implements SimpleLocalCache {
    protected final Map<Object, CacheEntity> debouncingData = new ConcurrentHashMap<Object, CacheEntity>();

    protected void clean(long now) {
        this.debouncingData.keySet().forEach(key -> {
            CacheEntity ce = this.debouncingData.get(key);
            if (ce == null || ce.getTtlMillis() < now) {
                this.debouncingData.remove(key);
            }
        });
    }

    @Override
    public void put(Object key, Object value, Long ttlMilliseconds) {
        this.debouncingData.put(key, new CacheEntity(value, ttlMilliseconds));
    }

    @Override
    public <T> T get(Object key) {
        if (key == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        this.clean(now);
        CacheEntity e = this.debouncingData.get(key);
        if (e == null) {
            return null;
        }
        if (e.getTtlMillis() < now) {
            return null;
        }
        return (T)e.getValue();
    }

    @Override
    public <T> T delete(Object key) {
        T ret = this.get(key);
        this.debouncingData.remove(key);
        return ret;
    }

    public static class CacheEntity {
        private final Object value;
        private final long ttlMillis;

        public CacheEntity(Object value, Long ttlMilliseconds) {
            this.value = value;
            this.ttlMillis = ttlMilliseconds == null || ttlMilliseconds < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + ttlMilliseconds;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTtlMillis() {
            return this.ttlMillis;
        }
    }
}

