/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.summerboot.jexpress.nio.server.domain.ErrorCodeDeserializer;
import org.summerboot.jexpress.nio.server.domain.ErrorCodeSerializer;
import org.summerboot.jexpress.util.BeanUtil;

public class Err<T> {
    @JsonSerialize(using=ErrorCodeSerializer.class)
    @JsonDeserialize(using=ErrorCodeDeserializer.class)
    private String errorCode;
    private String errorTag;
    private String errorDesc;
    private String cause;
    private Throwable ex;
    @JsonIgnore
    private T attachedData;

    public Err() {
    }

    public Err(int errorCode, String errorTag, String errorDesc, Throwable ex) {
        this("" + errorCode, errorTag, errorDesc, ex);
    }

    public Err(String errorCode, String errorTag, String errorDesc, Throwable ex) {
        this.errorCode = errorCode;
        this.errorTag = errorTag;
        this.errorDesc = errorDesc;
        this.ex = ex;
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
        if (rootCause == null) {
            rootCause = ex;
        }
        this.cause = rootCause == null ? null : rootCause.toString();
    }

    public String toString() {
        return this.toJson();
    }

    protected String toStringEx() {
        if (this.cause == null) {
            return "{\"errorCode\": " + this.errorCode + ", errorTag=" + this.errorTag + ", \"errorDesc\": \"" + this.errorDesc + "\"}";
        }
        return "{\"errorCode\": " + this.errorCode + ", errorTag=" + this.errorTag + ", \"errorDesc\": \"" + this.errorDesc + "\", \"cause\": \"" + this.cause + "\"}";
    }

    public String toJson() {
        try {
            return BeanUtil.toJson(this, true, true);
        }
        catch (JsonProcessingException ex) {
            return this.toStringEx();
        }
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @JsonIgnore
    public int getErrorCodeInt() {
        return Integer.parseInt(this.errorCode);
    }

    public String getErrorTag() {
        return this.errorTag;
    }

    public String getErrorDesc() {
        return this.errorDesc;
    }

    public String getCause() {
        return this.cause;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = "" + errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorTag(String errorTag) {
        this.errorTag = errorTag;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    @JsonIgnore
    public Throwable getEx() {
        return this.ex;
    }

    public T getAttachedData() {
        return this.attachedData;
    }

    public void setAttachedData(T attachedData) {
        this.attachedData = attachedData;
    }
}

