/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.boot.instrumentation.HTTPClientStatusListener;
import org.summerboot.jexpress.nio.client.RPCResult;
import org.summerboot.jexpress.nio.server.AbortPolicyWithReport;
import org.summerboot.jexpress.security.SSLUtil;

public abstract class HttpClientConfig
extends BootConfig {
    @ConfigHeader(title="1. HTTP Client Security")
    @Config(key="httpclient.ssl.protocol")
    private volatile String protocol = "TLSv1.3";
    @JsonIgnore
    @Config(key="httpclient.ssl.KeyStore", StorePwdKey="httpclient.ssl.KeyStorePwd", AliasKey="httpclient.ssl.KeyAlias", AliasPwdKey="httpclient.ssl.KeyPwd", required=false)
    private volatile KeyManagerFactory kmf;
    @JsonIgnore
    @Config(key="httpclient.ssl.TrustStore", StorePwdKey="httpclient.ssl.TrustStorePwd")
    private volatile TrustManagerFactory tmf;
    @Config(key="httpclient.ssl.HostnameVerification")
    private volatile Boolean hostnameVerification = false;
    @Config(key="httpclient.proxy.host")
    private volatile String proxyHost;
    private volatile String currentProxyHost;
    @Config(key="httpclient.proxy.port")
    private volatile int proxyPort = 8080;
    private volatile int currentProxyPort;
    @Config(key="httpclient.proxy.userName")
    private volatile String proxyUserName;
    @JsonIgnore
    @Config(key="httpclient.proxy.userPwd", validate=Config.Validate.Encrypted)
    private volatile String proxyUserPwd;
    @JsonIgnore
    private volatile String proxyAuthorizationBasicValue;
    @Config(key="httpclient.redirectOption")
    private volatile HttpClient.Redirect redirectOption = HttpClient.Redirect.NEVER;
    @Config(key="httpclient.fromJson.CaseInsensitive")
    private volatile boolean fromJsonCaseInsensitive = false;
    @Config(key="httpclient.fromJson.failOnUnknownProperties")
    private volatile boolean fromJsonFailOnUnknownProperties = true;
    @ConfigHeader(title="2. HTTP Client Performance")
    private volatile HttpClient httpClient;
    @Config(key="httpclient.timeout.ms")
    private volatile long httpClientTimeoutMs = 5000L;
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();
    @Config(key="httpclient.executor.CoreSize", desc="HTTP Client will be disabled when core size is/below 0")
    private volatile int httpClientCoreSize = this.availableProcessors * 2 + 1;
    private volatile int currentCore;
    @Config(key="httpclient.executor.MaxSize")
    private volatile int httpClientMaxSize = this.availableProcessors * 2 + 1;
    private volatile int currentMax;
    @Config(key="httpclient.executor.QueueSize")
    private volatile int httpClientQueueSize = Integer.MAX_VALUE;
    private volatile int currentQueue;
    private ThreadPoolExecutor tpe;
    @JsonIgnore
    private ScheduledExecutorService ses;
    private static final String HEADER_CLIENT_REQUEST = "httpclient.DefaultReqHttpHeaders.";
    @ConfigHeader(title="3. HTTP Client Default Headers", desc="put generic HTTP Client request headers here", format="httpclient.DefaultReqHttpHeaders.?=?", example="httpclient.DefaultReqHttpHeaders.Accept=application/json\nhttpclient.DefaultReqHttpHeaders.Content-Type=application/json;charset=UTF-8\nhttpclient.DefaultReqHttpHeaders.Accept-Language=en-ca")
    private final Map<String, String> httpClientDefaultRequestHeaders = new HashMap<String, String>();
    private HTTPClientStatusListener listener = null;

    public static void main(String[] args) {
        String t = HttpClientConfig.generateTemplate(HttpClientConfig.class);
        System.out.println(t);
    }

    protected HttpClientConfig() {
    }

    @Override
    public void shutdown() {
        String tn = Thread.currentThread().getName();
        if (this.tpe != null && !this.tpe.isShutdown()) {
            System.out.println(tn + ": shutdown tpe: " + this.tpe);
            this.tpe.shutdown();
        } else {
            System.out.println(tn + ": already shutdown tpe: " + this.tpe);
        }
        if (this.ses != null && !this.ses.isShutdown()) {
            System.out.println(tn + ": shutdown ses: " + this.ses);
            this.ses.shutdown();
        }
    }

    public void setStatusListener(HTTPClientStatusListener l) {
        this.listener = l;
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
        boolean isHttpClientSettingsChanged;
        String error2;
        Set _keys = props.keySet().stream().map(o -> o.toString()).collect(Collectors.toSet());
        ArrayList<String> keys = new ArrayList<String>(_keys);
        Collections.sort(keys);
        this.httpClientDefaultRequestHeaders.clear();
        keys.forEach(name -> {
            if (name.startsWith(HEADER_CLIENT_REQUEST)) {
                String[] names = name.split("\\.");
                String headerName = names[2];
                String headerValue = props.getProperty((String)name);
                this.httpClientDefaultRequestHeaders.put(headerName, headerValue);
            }
        });
        RPCResult.init(this.fromJsonFailOnUnknownProperties, this.fromJsonCaseInsensitive);
        KeyManager[] keyManagers = this.kmf == null ? null : this.kmf.getKeyManagers();
        TrustManager[] trustManagers = this.tmf == null ? SSLUtil.TRUST_ALL_CERTIFICATES : this.tmf.getTrustManagers();
        SSLContext sslContext = SSLUtil.buildSSLContext(keyManagers, trustManagers, this.protocol);
        if (this.hostnameVerification != null) {
            System.setProperty("jdk.internal.httpclient.disableHostnameVerification", this.hostnameVerification != false ? "false" : "true");
        }
        if (this.httpClientMaxSize < this.httpClientCoreSize) {
            helper.addError("MaxSize should not less than CoreSize");
        }
        if ((error2 = helper.getError()) != null) {
            throw new IllegalArgumentException(error2);
        }
        if (!isReal) {
            return;
        }
        boolean bl = isHttpClientSettingsChanged = this.currentCore != this.httpClientCoreSize || this.currentMax != this.httpClientMaxSize || this.currentQueue != this.httpClientQueueSize || !StringUtils.equals((CharSequence)this.currentProxyHost, (CharSequence)this.proxyHost) || this.currentProxyPort != this.proxyPort;
        if (this.httpClient == null || isHttpClientSettingsChanged) {
            this.currentCore = this.httpClientCoreSize;
            this.currentMax = this.httpClientMaxSize;
            this.currentQueue = this.httpClientQueueSize;
            this.currentProxyHost = this.proxyHost;
            this.currentProxyPort = this.proxyPort;
            ThreadPoolExecutor old = this.tpe;
            ScheduledExecutorService sesold = this.ses;
            if (this.httpClientCoreSize > 0) {
                this.tpe = new ThreadPoolExecutor(this.currentCore, this.currentMax, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.currentQueue), Executors.defaultThreadFactory(), new AbortPolicyWithReport("HttpClientExecutor"));
                HttpClient.Builder builder = HttpClient.newBuilder().executor(this.tpe);
                if (sslContext != null) {
                    builder.sslContext(sslContext);
                }
                builder.version(HttpClient.Version.HTTP_2).followRedirects(this.redirectOption);
                if (StringUtils.isNotBlank((CharSequence)this.proxyHost)) {
                    builder.proxy(ProxySelector.of(new InetSocketAddress(this.proxyHost, this.proxyPort)));
                }
                if (StringUtils.isNotBlank((CharSequence)this.proxyUserName)) {
                    if (this.proxyUserPwd == null) {
                        this.proxyUserPwd = "";
                    }
                    System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                    String plain = this.proxyUserName + ":" + this.proxyUserPwd;
                    String encoded = new String(Base64.getEncoder().encode(plain.getBytes()));
                    this.proxyAuthorizationBasicValue = "Basic " + encoded;
                }
                this.httpClient = builder.build();
                this.ses = Executors.newSingleThreadScheduledExecutor();
                this.ses.scheduleAtFixedRate(() -> {
                    int queue = this.tpe.getQueue().size();
                    int active = this.tpe.getActiveCount();
                    if (active > 0 || queue > 0) {
                        long task = this.tpe.getTaskCount();
                        long completed = this.tpe.getCompletedTaskCount();
                        long pool = this.tpe.getPoolSize();
                        int core = this.tpe.getCorePoolSize();
                        long max = this.tpe.getMaximumPoolSize();
                        long largest = this.tpe.getLargestPoolSize();
                        if (this.listener != null) {
                            this.listener.onHTTPClientAccessReportUpdate(task, completed, queue, active, pool, core, max, largest);
                        }
                        this.logger.info(() -> "HTTPClient task=" + task + ", completed=" + completed + ", queue=" + queue + ", active=" + active + ", pool=" + pool + ", core=" + core + ", max=" + max + ", largest=" + largest);
                    }
                }, 0L, 1L, TimeUnit.SECONDS);
            }
            if (old != null) {
                old.shutdown();
            }
            if (sesold != null) {
                sesold.shutdown();
            }
        }
    }

    @JsonIgnore
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Map<String, String> getHttpClientDefaultRequestHeaders() {
        return this.httpClientDefaultRequestHeaders;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Boolean isHostnameVerificationEnabled() {
        return this.hostnameVerification;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public String getProxyUserPwd() {
        return this.proxyUserPwd;
    }

    public String getProxyAuthorizationBasicValue() {
        return this.proxyAuthorizationBasicValue;
    }

    public boolean isFromJsonCaseInsensitive() {
        return this.fromJsonCaseInsensitive;
    }

    public boolean isFromJsonFailOnUnknownProperties() {
        return this.fromJsonFailOnUnknownProperties;
    }

    public long getHttpClientTimeoutMs() {
        return this.httpClientTimeoutMs;
    }

    public int getHttpClientCoreSize() {
        return this.httpClientCoreSize;
    }

    public int getHttpClientMaxSize() {
        return this.httpClientMaxSize;
    }

    public int getHttpClientQueueSize() {
        return this.httpClientQueueSize;
    }

    public String getHttpClientInfo() {
        return String.valueOf(this.httpClient);
    }

    public String getTpeInfo() {
        return String.valueOf(this.tpe);
    }
}

