/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.nio.grpc.GRPCClient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public abstract class GRPCClientConfig
extends BootConfig {
    protected static final String ID = "gRpc.client";
    @ConfigHeader(title="1. gRpc.client provider")
    @Config(key="gRpc.client.url", defaultValue="grpc://127.0.0.1:8424", desc="grpc://127.0.0.1:8424\ngrpcs://127.0.0.1:8424\nunix:/tmp/grpcsrver.socket")
    protected volatile URI uri;
    @Config(key="gRpc.client.ssl.Protocols", defaultValue="TLSv1.3")
    protected String[] sslProtocols = new String[]{"TLSv1.3"};
    @Config(key="gRpc.client.ssl.ciphers")
    protected List ciphers;
    @ConfigHeader(title="2. gRpc.client keystore")
    @Config(key="gRpc.client.ssl.KeyStore", StorePwdKey="gRpc.client.ssl.KeyStorePwd", AliasKey="gRpc.client.ssl.KeyAlias", AliasPwdKey="gRpc.client.ssl.KeyPwd")
    @JsonIgnore
    protected volatile KeyManagerFactory kmf;
    @ConfigHeader(title="3. gRpc.client truststore")
    @Config(key="gRpc.client.ssl.TrustStore", StorePwdKey="gRpc.client.ssl.TrustStorePwd")
    @JsonIgnore
    protected volatile TrustManagerFactory tmf;
    @Config(key="gRpc.client.ssl.overrideAuthority")
    protected volatile String overrideAuthority;
    @JsonIgnore
    protected volatile NettyChannelBuilder channelBuilder;

    public static void main(String[] args) {
        String t = GRPCClientConfig.generateTemplate(GRPCClientConfig.class);
        System.out.println(t);
    }

    protected GRPCClientConfig() {
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws IOException {
        this.channelBuilder = GRPCClient.getNettyChannelBuilder(this.uri, this.kmf, this.tmf, this.overrideAuthority, this.ciphers, this.sslProtocols);
    }

    @Override
    public void shutdown() {
    }

    public URI getUri() {
        return this.uri;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public List getCiphers() {
        return this.ciphers;
    }

    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    public TrustManagerFactory getTmf() {
        return this.tmf;
    }

    public String getOverrideAuthority() {
        return this.overrideAuthority;
    }

    public NettyChannelBuilder getChannelBuilder() {
        return this.channelBuilder;
    }
}

