/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.ws.rs;

import io.netty.handler.codec.http.HttpMethod;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.annotation.Controller;
import org.summerboot.jexpress.boot.annotation.Ping;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.ws.rs.JaxRsRequestProcessor;
import org.summerboot.jexpress.nio.server.ws.rs.PingController;
import org.summerboot.jexpress.util.ReflectionUtil;

public class JaxRsRequestProcessorManager {
    private static final Map<String, List<ProcessorMeta>> registeredProcessors = new HashMap<String, List<ProcessorMeta>>();
    public static final String KEY_PING = Ping.class.getName();
    private static Map<HttpMethod, Map<String, RequestProcessor>> processorMapString;
    private static Map<HttpMethod, Map<String, RequestProcessor>> processorMapRegex;

    private static void registerProcessor(String key, String path, Method method, Object instance) {
        List<ProcessorMeta> processors = registeredProcessors.get(key);
        if (processors == null) {
            processors = new ArrayList<ProcessorMeta>();
            registeredProcessors.put(key, processors);
        }
        processors.add(new ProcessorMeta(key, path, method, instance));
    }

    private static void checkDuplicated(StringBuilder errors, StringBuilder memo) {
        List<ProcessorMeta> pingProcessors = registeredProcessors.remove(KEY_PING);
        if (pingProcessors != null) {
            ProcessorMeta targetPingProcessor = null;
            int pintImplCount = pingProcessors.size();
            if (pintImplCount == 1) {
                targetPingProcessor = pingProcessors.get(0);
            } else if (pintImplCount > 1) {
                ArrayList<ProcessorMeta> defaultPing = new ArrayList<ProcessorMeta>();
                ArrayList<ProcessorMeta> overridenPing = new ArrayList<ProcessorMeta>();
                for (ProcessorMeta pingProcessor : pingProcessors) {
                    if (pingProcessor.m.getDeclaringClass().equals(PingController.class)) {
                        defaultPing.add(pingProcessor);
                        continue;
                    }
                    overridenPing.add(pingProcessor);
                }
                if (overridenPing.size() == 1) {
                    targetPingProcessor = (ProcessorMeta)overridenPing.get(0);
                } else {
                    errors.append("\n\n! Duplicated URI ").append(KEY_PING);
                    for (ProcessorMeta p : pingProcessors) {
                        errors.append("\n\t").append("@ ").append(p.info);
                    }
                }
            }
            if (targetPingProcessor != null) {
                System.setProperty("pingURI", targetPingProcessor.url);
                memo.append("\n\t- ").append("* GET").append(" ").append(targetPingProcessor.url).append(" (").append(targetPingProcessor.info).append(" )");
            }
        }
        for (String key : registeredProcessors.keySet()) {
            List<ProcessorMeta> processors = registeredProcessors.get(key);
            if (processors == null || processors.size() < 2) continue;
            errors.append("\n\n! Duplicated URI ").append(key);
            for (ProcessorMeta p : processors) {
                errors.append("\n\t").append("@ ").append(p.info);
            }
        }
    }

    public static void registerControllers(@Controller Map<String, Object> controllers, StringBuilder memo) {
        if (controllers == null || controllers.isEmpty()) {
            return;
        }
        registeredProcessors.clear();
        HashSet<String> declareRoles = new HashSet<String>();
        HashMap<HttpMethod, Map<String, RequestProcessor>> stringMap = new HashMap<HttpMethod, Map<String, RequestProcessor>>();
        HashMap<HttpMethod, Map<String, RequestProcessor>> regexMap = new HashMap<HttpMethod, Map<String, RequestProcessor>>();
        StringBuilder errors = new StringBuilder();
        for (String name : controllers.keySet()) {
            Object javaInstance = controllers.get(name);
            Class<?> controllerClass = javaInstance.getClass();
            String rootPath = null;
            Path pathRoot = controllerClass.getAnnotation(Path.class);
            if (pathRoot != null) {
                rootPath = pathRoot.value().trim();
            }
            List<Method> methods = ReflectionUtil.getDeclaredAndSuperClassesMethods(controllerClass, true);
            for (Method javaMethod : methods) {
                HEAD amh;
                PATCH ampc;
                OPTIONS amo;
                DELETE amd;
                PUT ampt;
                POST amp;
                Object path;
                Path pathAnnotation = javaMethod.getAnnotation(Path.class);
                if (pathAnnotation == null || (path = StringUtils.isBlank((CharSequence)rootPath) ? pathAnnotation.value().trim() : rootPath + pathAnnotation.value().trim()) == null) continue;
                HashSet<HttpMethod> httpMethods = new HashSet<HttpMethod>();
                GET amg = javaMethod.getAnnotation(GET.class);
                if (amg != null) {
                    httpMethods.add(HttpMethod.GET);
                    Ping ping = javaMethod.getAnnotation(Ping.class);
                    if (ping != null) {
                        JaxRsRequestProcessorManager.registerProcessor(KEY_PING, (String)path, javaMethod, javaInstance);
                        continue;
                    }
                }
                if ((amp = javaMethod.getAnnotation(POST.class)) != null) {
                    httpMethods.add(HttpMethod.POST);
                }
                if ((ampt = javaMethod.getAnnotation(PUT.class)) != null) {
                    httpMethods.add(HttpMethod.PUT);
                }
                if ((amd = javaMethod.getAnnotation(DELETE.class)) != null) {
                    httpMethods.add(HttpMethod.DELETE);
                }
                if ((amo = javaMethod.getAnnotation(OPTIONS.class)) != null) {
                    httpMethods.add(HttpMethod.OPTIONS);
                }
                if ((ampc = javaMethod.getAnnotation(PATCH.class)) != null) {
                    httpMethods.add(HttpMethod.PATCH);
                }
                if ((amh = javaMethod.getAnnotation(HEAD.class)) != null) {
                    httpMethods.add(HttpMethod.HEAD);
                }
                if (httpMethods.isEmpty()) continue;
                for (HttpMethod httpMethod : httpMethods) {
                    JaxRsRequestProcessor processor;
                    try {
                        processor = new JaxRsRequestProcessor(javaInstance, javaMethod, httpMethod, (String)path, declareRoles);
                        memo.append("\n\t- ").append(httpMethod).append(" ").append((String)path).append(" (").append(javaMethod.getDeclaringClass().getName()).append(".").append(javaMethod.getName()).append(" )");
                    }
                    catch (Throwable ex) {
                        errors.append("failed to create processor for ").append(controllerClass.getName()).append(".").append(javaMethod.getName()).append("\n\t").append(ex);
                        continue;
                    }
                    boolean isRegexMap = processor.isUsingPathParam() || processor.isUsingMatrixPara();
                    HashMap<HttpMethod, Map<String, RequestProcessor>> httpMethodMapRef = isRegexMap ? regexMap : stringMap;
                    Map processorMapPerHttpMethod = (Map)httpMethodMapRef.get(httpMethod);
                    if (processorMapPerHttpMethod == null) {
                        processorMapPerHttpMethod = isRegexMap ? new TreeMap(Comparator.comparingInt(String::length).reversed().thenComparing(Function.identity())) : new HashMap();
                        httpMethodMapRef.put(httpMethod, processorMapPerHttpMethod);
                    }
                    String key = processor.getDeclaredPath();
                    JaxRsRequestProcessorManager.registerProcessor(httpMethod + " " + key, (String)path, javaMethod, javaInstance);
                    processorMapPerHttpMethod.put(key, processor);
                }
            }
        }
        JaxRsRequestProcessorManager.checkDuplicated(errors, memo);
        String error2 = errors.toString();
        if (!error2.isBlank()) {
            System.err.println("Invalid Java methods: \n" + errors);
            System.exit(1);
        }
        memo.append("\n\t- * DeclareRoles=").append(declareRoles);
        processorMapString = stringMap;
        processorMapRegex = regexMap;
    }

    public static RequestProcessor getRequestProcessor(HttpMethod httptMethod, String httpRequestPath) {
        if (processorMapString == null) {
            return null;
        }
        RequestProcessor processor = null;
        Map<String, RequestProcessor> subMap = processorMapString.get(httptMethod);
        if (subMap != null) {
            processor = subMap.get(httpRequestPath);
        }
        if (processor == null && (subMap = processorMapRegex.get(httptMethod)) != null) {
            for (RequestProcessor p : subMap.values()) {
                if (!p.matches(httpRequestPath)) continue;
                processor = p;
                break;
            }
        }
        return processor;
    }

    private static <T> T create(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                boolean flag = method.isAnnotationPresent(GET.class);
                return null;
            }
        });
    }

    private static class ProcessorMeta {
        final String key;
        final String url;
        final Class cThis;
        final Class cSuper;
        final Method m;
        final Object instance;
        final String info;

        public ProcessorMeta(String key, String url, Method m, Object instance) {
            this.key = key;
            this.url = url;
            this.cThis = instance.getClass();
            this.cSuper = m.getDeclaringClass();
            this.m = m;
            this.instance = instance;
            this.info = this.cThis.equals(this.cSuper) ? this.cThis.getName() + "." + m.getName() + "()" : this.cThis.getName() + " extneds " + this.cSuper.getName() + "." + m.getName() + "()";
        }
    }
}

