/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Enumeration;

public class GeoIpUtil {
    public static final String CHECKIP_URL_AWS = "http://checkip.amazonaws.com";

    public static String getExternalIp() throws IOException {
        return GeoIpUtil.getExternalIp(CHECKIP_URL_AWS);
    }

    public static String getExternalIp(String url) throws IOException {
        URL whatismyip = new URL(url);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(whatismyip.openStream()));){
            String string = in.readLine();
            return string;
        }
    }

    public static String[] getMyIP() {
        String[] ret = new String[]{"", "", ""};
        StringBuilder sb0 = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        try {
            sb0.append(GeoIpUtil.getExternalIp()).append(" - ");
            ret[0] = InetAddress.getLocalHost().getHostAddress();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (i.isAnyLocalAddress()) {
                        sb0.append(i.getHostAddress()).append(", ");
                        sb1.append("LocalAddress: ").append(i.toString()).append("<br>");
                    }
                    if (i.isLinkLocalAddress()) {
                        sb1.append("LinkLocalAddress: ").append(i.toString()).append("<br>");
                    }
                    if (i.isLoopbackAddress()) {
                        sb1.append("LoopbackAddress: ").append(i.toString()).append("<br>");
                    }
                    if (i.isSiteLocalAddress()) {
                        sb0.append(i.getHostAddress()).append(", ");
                        sb1.append("SiteLocalAddress: ").append(i.toString()).append("<br>");
                    }
                    if (i.isMCGlobal()) {
                        sb1.append("MCGlobal: ").append(i.toString()).append("<br>");
                    }
                    if (i.isMCLinkLocal()) {
                        sb1.append("MCLinkLocal: ").append(i.toString()).append("<br>");
                    }
                    if (i.isMCNodeLocal()) {
                        sb1.append("MCNodeLocal: ").append(i.toString()).append("<br>");
                    }
                    if (i.isMCOrgLocal()) {
                        sb1.append("MCOrgLocal: ").append(i.toString()).append("<br>");
                    }
                    if (!i.isMCSiteLocal()) continue;
                    sb1.append("MCSiteLocal: ").append(i.toString()).append("<br>");
                }
            }
        }
        catch (Throwable ex) {
            sb1.append(ex);
        }
        String systemInfo = "<br>Pid#" + ManagementFactory.getRuntimeMXBean().getName() + "<br>user.name=" + System.getProperty("user.name") + "<br>user=" + System.getProperty("user.name") + "<br>home=" + System.getProperty("user.home") + "<br>dir=" + System.getProperty("user.dir") + "<br>os=" + System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "<br>Java=" + System.getProperty("java.vendor") + " " + System.getProperty("java.version");
        ret[0] = sb0.toString();
        ret[1] = sb1.toString();
        ret[2] = systemInfo;
        return ret;
    }
}

