/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BootLoadBalancerProvider
extends NameResolverProvider {
    protected final List<EquivalentAddressGroup> servers;
    protected final String scheme;
    protected String authority;

    public BootLoadBalancerProvider(String scheme, SocketAddress ... addresses) {
        this.scheme = scheme;
        this.authority = Arrays.stream(addresses).map(Object::toString).collect(Collectors.joining(", "));
        this.servers = Arrays.stream(addresses).map(EquivalentAddressGroup::new).collect(Collectors.toList());
    }

    public BootLoadBalancerProvider(String scheme, List<? extends SocketAddress> addresses) {
        this.scheme = scheme;
        this.authority = addresses.stream().map(Object::toString).collect(Collectors.joining(", "));
        this.servers = addresses.stream().map(EquivalentAddressGroup::new).collect(Collectors.toList());
    }

    public BootLoadBalancerProvider(String scheme, Map<String, Integer> addressesMap) {
        this.scheme = scheme;
        InetSocketAddress[] addresses = (InetSocketAddress[])addressesMap.entrySet().stream().map(entry -> new InetSocketAddress((String)entry.getKey(), (int)((Integer)entry.getValue()))).toArray(InetSocketAddress[]::new);
        this.authority = Arrays.stream(addresses).map(Object::toString).collect(Collectors.joining(", "));
        this.servers = Arrays.stream(addresses).map(EquivalentAddressGroup::new).collect(Collectors.toList());
    }

    public NameResolver newNameResolver(URI notUsedTargetUri, NameResolver.Args args) {
        return new NameResolver(){

            public String getServiceAuthority() {
                return BootLoadBalancerProvider.this.authority;
            }

            public void start(NameResolver.Listener2 listener) {
                listener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(BootLoadBalancerProvider.this.servers).setAttributes(Attributes.EMPTY).build());
            }

            public void shutdown() {
            }
        };
    }

    public String getDefaultScheme() {
        return this.scheme;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 0;
    }
}

