/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import com.google.inject.ConfigurationException;
import io.grpc.Grpc;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.SummerRunner;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.nio.grpc.GRPCServiceCounter;
import org.summerboot.jexpress.nio.server.AbortPolicyWithReport;

public class GRPCServer {
    protected static final Logger log = LogManager.getLogger((String)GRPCServer.class.getName());
    protected Server server = null;
    protected final String bindingAddr;
    protected final int port;
    protected final ServerCredentials serverCredentials;
    protected final ServerBuilder serverBuilder;
    protected ServerInterceptor serverInterceptor;
    protected ScheduledExecutorService statusReporter = null;
    protected ThreadPoolExecutor tpe = null;
    protected static NIOStatusListener listener = null;
    protected boolean servicePaused = false;
    protected final GRPCServiceCounter serviceCounter = new GRPCServiceCounter();
    protected SummerRunner.RunnerContext context;

    public static ServerCredentials initTLS(KeyManagerFactory kmf, TrustManagerFactory tmf) {
        if (kmf == null) {
            return null;
        }
        TlsServerCredentials.Builder tlsBuilder = TlsServerCredentials.newBuilder().keyManager(kmf.getKeyManagers());
        if (tmf != null) {
            tlsBuilder.trustManager(tmf.getTrustManagers());
            tlsBuilder.clientAuth(TlsServerCredentials.ClientAuth.REQUIRE);
        }
        return tlsBuilder.build();
    }

    public GRPCServer(String bindingAddr, int port, KeyManagerFactory kmf, TrustManagerFactory tmf) {
        this(bindingAddr, port, GRPCServer.initTLS(kmf, tmf));
    }

    public GRPCServer(String bindingAddr, int port, ServerCredentials serverCredentials) {
        this.bindingAddr = bindingAddr;
        this.port = port;
        this.serverCredentials = serverCredentials;
        this.serverBuilder = serverCredentials == null ? NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(bindingAddr, port)) : Grpc.newServerBuilderForPort((int)port, (ServerCredentials)serverCredentials);
    }

    public ServerInterceptor getServerInterceptor() {
        return this.serverInterceptor;
    }

    public void setContext(SummerRunner.RunnerContext context) {
        this.context = context;
        try {
            this.serverInterceptor = (ServerInterceptor)context.getGuiceInjector().getInstance(ServerInterceptor.class);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (this.serverInterceptor != null) {
            this.serverBuilder.intercept(this.serverInterceptor);
        }
    }

    public ServerBuilder getServerBuilder() {
        return this.serverBuilder;
    }

    public GRPCServiceCounter getServiceCounter() {
        return this.serviceCounter;
    }

    public static void setListener(NIOStatusListener listener) {
        GRPCServer.listener = listener;
    }

    public GRPCServiceCounter configThreadPool() {
        int poolCoreSize;
        int coreSize = Runtime.getRuntime().availableProcessors();
        int poolMaxSizeMaxSize = poolCoreSize = coreSize * 2 + 1;
        long keepAliveSeconds = 60L;
        int poolQueueSize = Integer.MAX_VALUE;
        return this.configThreadPool(poolCoreSize, poolMaxSizeMaxSize, poolQueueSize, keepAliveSeconds);
    }

    public GRPCServiceCounter configThreadPool(int poolCoreSize, int poolMaxSizeMaxSize, int poolQueueSize, long keepAliveSeconds) {
        ThreadPoolExecutor old = this.tpe;
        this.tpe = new ThreadPoolExecutor(poolCoreSize, poolMaxSizeMaxSize, keepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(poolQueueSize), Executors.defaultThreadFactory(), new AbortPolicyWithReport("gRPC Server Executor"));
        this.serverBuilder.executor((Executor)this.tpe);
        if (old != null) {
            old.shutdown();
        }
        int interval = 1;
        AtomicReference<Long> lastBizHitRef = new AtomicReference<Long>();
        lastBizHitRef.set(-1L);
        long totalChannel = -1L;
        long activeChannel = -1L;
        ScheduledExecutorService old2 = this.statusReporter;
        this.statusReporter = Executors.newSingleThreadScheduledExecutor();
        this.statusReporter.scheduleAtFixedRate(() -> {
            if (listener == null && !log.isDebugEnabled()) {
                return;
            }
            long bizHit = this.serviceCounter.getBiz();
            if ((Long)lastBizHitRef.get() == bizHit && !this.servicePaused) {
                return;
            }
            lastBizHitRef.set(bizHit);
            long hps = this.serviceCounter.getHitAndReset();
            long tps = this.serviceCounter.getProcessedAndReset();
            long pingHit = this.serviceCounter.getPing();
            long totalHit = bizHit + pingHit;
            int active = this.tpe.getActiveCount();
            int queue = this.tpe.getQueue().size();
            if (hps > 0L || tps > 0L || active > 0 || queue > 0 || this.servicePaused) {
                long pool = this.tpe.getPoolSize();
                int core = this.tpe.getCorePoolSize();
                long max = this.tpe.getMaximumPoolSize();
                long largest = this.tpe.getLargestPoolSize();
                long task = this.tpe.getTaskCount();
                long completed = this.tpe.getCompletedTaskCount();
                log.debug(() -> "hps=" + hps + ", tps=" + tps + ", totalHit=" + totalHit + " (ping " + pingHit + " + biz " + bizHit + "), queue=" + queue + ", active=" + active + ", pool=" + pool + ", core=" + core + ", max=" + max + ", largest=" + largest + ", task=" + task + ", completed=" + completed + ", activeChannel=" + activeChannel + ", totalChannel=" + totalChannel);
                if (listener != null) {
                    listener.onNIOAccessReportUpdate(hps, tps, totalHit, pingHit, bizHit, totalChannel, activeChannel, task, completed, queue, active, pool, core, max, largest);
                }
            }
        }, 0L, interval, TimeUnit.SECONDS);
        if (old2 != null) {
            old2.shutdownNow();
        }
        return this.serviceCounter;
    }

    public void start() throws IOException {
        this.start(false);
    }

    public void start(boolean isBlock) throws IOException {
        if (this.server != null) {
            this.shutdown();
        }
        this.server = this.serverBuilder.build().start();
        String schema = this.serverCredentials == null ? "grpc" : "grpcs";
        log.info("*** GRPCServer is listening on " + schema + "://" + this.bindingAddr + ":" + this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown(), "GRPCServer.shutdown and stop listening on " + schema + "://" + this.bindingAddr + ":" + this.port));
        if (isBlock) {
            try {
                this.server.awaitTermination();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void shutdown() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.shutdown();
            if (this.statusReporter != null) {
                this.statusReporter.shutdown();
            }
            log.warn("*** GRPCServer shutdown " + this.bindingAddr + ":" + this.port);
            this.server.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            System.err.println("GRPCServer shutdown timeout " + this.bindingAddr + ":" + this.port);
        }
        finally {
            this.server = null;
        }
    }
}

