/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.nio.server.HeartbeatRecIdleStateHandler;
import org.summerboot.jexpress.nio.server.HeartbeatSentIdleStateHandler;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioCounter;

class NioServerHttpInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LogManager.getLogger((String)NioServerHttpInitializer.class.getName());
    private final SslContext nettySslContext;
    private final SSLContext jdkSslContext;
    private final boolean verifyClient;
    private final NioConfig cfg;
    private final boolean isHttpService;
    private final String loadBalancingEndpoint;

    NioServerHttpInitializer(SSLContext jdkSSLContext, SslContext nettySslContext, boolean verifyClient, NioConfig cfg, String loadBalancingEndpoint) {
        this.jdkSslContext = jdkSSLContext;
        this.nettySslContext = nettySslContext;
        this.verifyClient = verifyClient;
        this.cfg = cfg;
        this.isHttpService = cfg.isHttpService();
        this.loadBalancingEndpoint = loadBalancingEndpoint;
    }

    private void configureSsl(SocketChannel socketChannel, ChannelPipeline pipeline) {
        SslHandler sslHandler = null;
        if (this.nettySslContext != null) {
            sslHandler = this.nettySslContext.newHandler(socketChannel.alloc());
            if (this.cfg.isVerifyCertificateHost()) {
                SSLEngine sslEngine = sslHandler.engine();
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                sslEngine.setSSLParameters(sslParameters);
            }
        } else if (this.jdkSslContext != null) {
            String[] cipherSuites;
            SSLEngine engine = this.jdkSslContext.createSSLEngine();
            engine.setUseClientMode(false);
            engine.setNeedClientAuth(this.verifyClient);
            engine.setWantClientAuth(this.verifyClient);
            String[] protocols = this.cfg.getSslProtocols();
            if (protocols != null && protocols.length > 0) {
                engine.setEnabledProtocols(protocols);
            }
            if ((cipherSuites = this.cfg.getSslCipherSuites()) != null && cipherSuites.length > 0) {
                engine.setEnabledCipherSuites(cipherSuites);
            }
            sslHandler = new SslHandler(engine);
            long sslHandshakeTimeout = this.cfg.getSslHandshakeTimeout();
            if (sslHandshakeTimeout > 0L) {
                sslHandler.setHandshakeTimeout(sslHandshakeTimeout, TimeUnit.SECONDS);
            }
            if (log.isTraceEnabled()) {
                for (String s : engine.getEnabledProtocols()) {
                    log.trace("\tProtocol = " + s);
                }
                for (String s : engine.getEnabledCipherSuites()) {
                    log.trace("\tCipher = " + s);
                }
            }
        }
        if (sslHandler != null) {
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
    }

    public void initChannel(SocketChannel socketChannel) {
        long tc = NioCounter.COUNTER_TOTAL_CHANNEL.incrementAndGet();
        log.debug(() -> tc + "[" + ((Object)((Object)this)).hashCode() + "]" + socketChannel);
        ChannelPipeline channelPipeline = socketChannel.pipeline();
        this.configureSsl(socketChannel, channelPipeline);
        if (this.cfg.getReaderIdleTime() > 0) {
            channelPipeline.addLast("tcp-pong", (ChannelHandler)new HeartbeatRecIdleStateHandler(this.cfg.getReaderIdleTime()));
        }
        if (this.cfg.getWriterIdleTime() > 0) {
            channelPipeline.addLast("tcp-ping", (ChannelHandler)new HeartbeatSentIdleStateHandler(this.cfg.getWriterIdleTime()));
        }
        if (this.isHttpService) {
            channelPipeline.addLast("http-codec", (ChannelHandler)new HttpServerCodec(this.cfg.getHttpServerCodec_MaxInitialLineLength(), this.cfg.getHttpServerCodec_MaxHeaderSize(), this.cfg.getHttpServerCodec_MaxChunkSize()));
            ChannelHandler ch = this.cfg.getHttpFileUploadHandler();
            if (ch != null) {
                channelPipeline.addLast("biz-fileUploadHandler", ch);
            }
            channelPipeline.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(this.cfg.getHttpObjectAggregatorMaxContentLength()));
            channelPipeline.addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
            String webSocketURI = this.cfg.getWebSocketHandlerAnnotatedName();
            if (webSocketURI != null) {
                String subprotocols = this.cfg.getWebSocketSubprotocols();
                boolean allowExtensions = this.cfg.isWebSocketAllowExtensions();
                int maxFrameSize = this.cfg.getWebSocketMaxFrameSize();
                channelPipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(webSocketURI, subprotocols, allowExtensions, maxFrameSize)});
                if (this.cfg.isWebSocketCompress()) {
                    channelPipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
                }
                if ((ch = this.cfg.getWebSockettHandler()) != null) {
                    channelPipeline.addLast(new ChannelHandler[]{ch});
                }
            }
            if (this.loadBalancingEndpoint != null && (ch = this.cfg.getPingHandler()) != null) {
                channelPipeline.addLast("biz-pingHandler", ch);
            }
            if ((ch = this.cfg.getRequestHandler()) != null) {
                channelPipeline.addLast("biz-requestHandler", ch);
            }
        }
    }
}

