/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.summerboot.jexpress.boot.BootGuiceModule;
import org.summerboot.jexpress.boot.ScanedGuiceModule;
import org.summerboot.jexpress.boot.SummerApplication;
import org.summerboot.jexpress.boot.SummerInitializer;
import org.summerboot.jexpress.boot.SummerRunner;
import org.summerboot.jexpress.boot.SummerSingularity;
import org.summerboot.jexpress.boot.annotation.Controller;
import org.summerboot.jexpress.boot.annotation.Order;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.i18n.I18n;
import org.summerboot.jexpress.nio.grpc.GRPCServerConfig;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.ws.rs.JaxRsRequestProcessorManager;
import org.summerboot.jexpress.security.EncryptorUtil;
import org.summerboot.jexpress.security.JwtUtil;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

public abstract class SummerBigBang
extends SummerSingularity {
    public static final String USAGE = "?";
    public static final String CLI_VERSION = "version";
    public static final String CLI_CONFIG_MONITOR_INTERVAL = "monitorInterval";
    public static final String CLI_I8N = "i18n";
    public static final String CLI_USE_IMPL = "use";
    public static final String CLI_CONFIG_DEMO = "cfgdemo";
    public static final String CLI_LIST_UNIQUE = "list";
    public static final String CLI_ADMIN_PWD_FILE = "authfile";
    public static final String CLI_ADMIN_PWD = "auth";
    public static final String CLI_JWT = "jwt";
    public static final String CLI_ENCRYPT = "encrypt";
    public static final String CLI_DECRYPT = "decrypt";
    private final Module userOverrideModule;
    protected Injector guiceInjector;
    protected List<SummerInitializer> summerInitializers = new ArrayList<SummerInitializer>();
    protected List<SummerRunner> summerRunners = new ArrayList<SummerRunner>();
    protected Locale userSpecifiedResourceBundle;
    private int userSpecifiedCfgMonitorIntervalSec = 30;
    protected final Set<String> userSpecifiedImplTags = new HashSet<String>();
    protected CommandLine cli;
    protected final Options cliOptions = new Options();
    protected final HelpFormatter cliHelpFormatter = new HelpFormatter();

    protected SummerBigBang(Class callerClass, Module userOverrideModule, String ... args) {
        super(callerClass, args);
        this.userOverrideModule = userOverrideModule;
        this.singularity();
        this.aParallelUniverse(args);
    }

    public Injector getGuiceInjector() {
        return this.guiceInjector;
    }

    private void singularity() {
        this.guiceInjector = null;
        this.summerInitializers.clear();
        this.summerRunners.clear();
        this.userSpecifiedResourceBundle = null;
        this.userSpecifiedCfgMonitorIntervalSec = 30;
        this.userSpecifiedImplTags.clear();
    }

    private <T extends SummerApplication> T aParallelUniverse(String ... args) {
        this.bigBang_LetThereBeCLI(args);
        this.bigBang_AndThereWasCLI();
        this.loadBootConfigFiles(ConfigUtil.ConfigLoadMode.app_run);
        for (SummerInitializer summerInitializer : this.summerInitializers) {
            summerInitializer.initApp(this.userSpecifiedConfigDir);
        }
        this.genesis(this.primaryClass, this.userSpecifiedImplTags);
        return (T)((SummerApplication)this);
    }

    protected void bigBang_LetThereBeCLI(String[] args) {
        Object validOptions;
        this.memo.append("\n\t- CLI.init: args=").append(Arrays.asList(args));
        Option arg = Option.builder((String)USAGE).desc("Usage/Help").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)CLI_VERSION).desc("check application version").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)CLI_CONFIG_MONITOR_INTERVAL).desc("configuration monitoring interval in second (default " + this.userSpecifiedCfgMonitorIntervalSec + " seconds)").hasArg().argName("second").build();
        this.cliOptions.addOption(arg);
        arg = new Option(CLI_I8N, true, "language <en | fr-CA>");
        arg.setRequired(false);
        this.cliOptions.addOption(arg);
        if (this.availableImplTagOptions != null && !this.availableImplTagOptions.isEmpty()) {
            validOptions = FormatterUtil.toCSV(this.availableImplTagOptions);
            arg = Option.builder((String)CLI_USE_IMPL).desc("launch application with selected implementations, valid values <" + (String)validOptions + ">").hasArgs().argName("items").build();
            arg.setArgs(-2);
            arg.setRequired(false);
            this.cliOptions.addOption(arg);
        }
        arg = Option.builder((String)"domain").desc("Start the program using the configuration in the ../standalone_<domain_name> directory. For example, if you specify --domain foo, the program will load the configuration files from the ../standalone_foo directory. If this option is not specified, the program will start using the default configuration files.").hasArg().argName("domain").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)"cfgdir").desc("the path to load the configuration files, or load from current folder when not specified").hasArg().argName("path").build();
        this.cliOptions.addOption(arg);
        if (this.scanedJExpressConfigs != null && !this.scanedJExpressConfigs.isEmpty()) {
            validOptions = FormatterUtil.toCSV(this.scanedJExpressConfigs.keySet());
            arg = Option.builder((String)CLI_CONFIG_DEMO).desc("Show specified configuration template (" + (String)validOptions + "), or when specified with -cfgdir just dump all available configuration templates to the specified folder").hasArgs().argName("config").optionalArg(true).build();
            this.cliOptions.addOption(arg);
        }
        if (!this.availableUniqueTagOptions.isEmpty()) {
            arg = Option.builder((String)CLI_LIST_UNIQUE).desc("Show list of: " + this.availableUniqueTagOptions).hasArg().argName("item").build();
            this.cliOptions.addOption(arg);
        }
        arg = Option.builder((String)CLI_ADMIN_PWD_FILE).desc("Specify an application configuration password in a file which contains a line: APP_ROOT_PASSWORD=<base64 encoded password>" + System.lineSeparator() + "Note: Unlike the -auth opton, this option protects the app config password from being exposed via ps command.").hasArg().argName("file").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)CLI_ADMIN_PWD).desc("Specify an application config password instead of the default one." + System.lineSeparator() + "Note: This option exposes the app config password via ps command").hasArg().argName("password").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)CLI_JWT).desc("generate JWT root signing key with the specified algorithm <HS256, HS384, HS512>").hasArg().argName("algorithm").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)CLI_ENCRYPT).desc("Encrypt config file content with all \"DEC(plain text)\":" + System.lineSeparator() + System.lineSeparator() + "\t -encrypt -cfgdir <path> -authfile <path>" + System.lineSeparator() + System.lineSeparator() + "\t or" + System.lineSeparator() + System.lineSeparator() + "\t -encrypt -cfgdir <path> -auth <password>").build();
        this.cliOptions.addOption(arg);
        arg = Option.builder((String)CLI_DECRYPT).desc("Decrypt config file content with all \"ENC(encrypted text)\" using password:" + System.lineSeparator() + System.lineSeparator() + System.lineSeparator() + "\t -decrypt -cfgdir <path> -auth <password>").build();
        this.cliOptions.addOption(arg);
        this.summerInitializers.addAll(this.scanImplementation_SummerInitializer());
        for (SummerInitializer summerInitializer : this.summerInitializers) {
            summerInitializer.initCLI(this.cliOptions);
        }
        try {
            DefaultParser parser = new DefaultParser();
            this.cli = parser.parse(this.cliOptions, args);
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
            this.cliHelpFormatter.printHelp(this.appVersion, this.cliOptions);
            System.exit(1);
        }
    }

    protected List<SummerInitializer> scanImplementation_SummerInitializer() {
        ArrayList<SummerInitializer> summerCLIs = new ArrayList<SummerInitializer>();
        Set<Class<SummerInitializer>> summerCLI_ImplClasses = ReflectionUtil.getAllImplementationsByInterface(SummerInitializer.class, this.callerRootPackageName);
        TreeSet<Integer> orderSet = new TreeSet<Integer>();
        HashMap<Integer, ArrayList<SummerInitializer>> orderMapping = new HashMap<Integer, ArrayList<SummerInitializer>>();
        for (Class<SummerInitializer> c : summerCLI_ImplClasses) {
            SummerInitializer instance;
            int order = 0;
            Order o = c.getAnnotation(Order.class);
            if (o != null) {
                order = o.value();
            }
            try {
                Constructor<SummerInitializer> cc = c.getConstructor(new Class[0]);
                cc.setAccessible(true);
                instance = cc.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new InaccessibleObjectException("Failed to call default constructor of " + c.getName());
            }
            orderSet.add(order);
            ArrayList<SummerInitializer> sameOoderCLIs = (ArrayList<SummerInitializer>)orderMapping.get(order);
            if (sameOoderCLIs == null) {
                sameOoderCLIs = new ArrayList<SummerInitializer>();
                orderMapping.put(order, sameOoderCLIs);
            }
            sameOoderCLIs.add(instance);
        }
        Iterator<Class<SummerInitializer>> iterator = orderSet.iterator();
        while (iterator.hasNext()) {
            int order = (Integer)((Object)iterator.next());
            summerCLIs.addAll((Collection)orderMapping.get(order));
        }
        return summerCLIs;
    }

    protected boolean runCLI_Utils() {
        boolean continueCLI = true;
        if (this.cli.hasOption(USAGE)) {
            continueCLI = false;
            this.cliHelpFormatter.printHelp(this.appVersion, this.cliOptions);
        }
        if (this.cli.hasOption(CLI_VERSION)) {
            continueCLI = false;
            System.out.println(this.appVersion);
        }
        if (this.cli.hasOption(CLI_JWT)) {
            continueCLI = false;
            String algorithm = this.cli.getOptionValue(CLI_JWT);
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forName((String)algorithm);
            String jwt = JwtUtil.buildSigningKey(signatureAlgorithm);
            System.out.println(jwt);
        }
        if (this.cli.hasOption(CLI_LIST_UNIQUE)) {
            continueCLI = false;
            String tag = this.cli.getOptionValue(CLI_LIST_UNIQUE);
            StringBuilder sb = new StringBuilder();
            String error2 = this.scanAnnotation_Unique(this.callerRootPackageName, sb, tag);
            if (error2 != null) {
                System.out.println(error2);
            } else {
                System.out.println(sb);
            }
        }
        return continueCLI;
    }

    protected void bigBang_AndThereWasCLI() {
        if (!this.runCLI_Utils()) {
            System.exit(0);
        }
        if (this.cli.hasOption(CLI_ADMIN_PWD_FILE)) {
            String adminPwdFile = this.cli.getOptionValue(CLI_ADMIN_PWD_FILE);
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(adminPwdFile);){
                props.load(is);
            }
            catch (Throwable ex) {
                throw new RuntimeException("failed to load " + adminPwdFile, ex);
            }
            String adminPwd = props.getProperty("APP_ROOT_PASSWORD");
            adminPwd = SecurityUtil.base64Decode(adminPwd);
            EncryptorUtil.init(adminPwd);
        } else if (this.cli.hasOption(CLI_ADMIN_PWD)) {
            String adminPwd = this.cli.getOptionValue(CLI_ADMIN_PWD);
            EncryptorUtil.init(adminPwd);
        }
        if (this.cli.hasOption(CLI_CONFIG_MONITOR_INTERVAL)) {
            String cmi = this.cli.getOptionValue(CLI_CONFIG_MONITOR_INTERVAL);
            this.userSpecifiedCfgMonitorIntervalSec = Integer.parseInt(cmi);
        }
        if (this.cli.hasOption(CLI_CONFIG_DEMO) && !this.cli.hasOption("cfgdir") && !this.cli.hasOption("domain")) {
            Class c;
            String cfgName = this.cli.getOptionValue(CLI_CONFIG_DEMO);
            if (cfgName == null) {
                String validOptions = FormatterUtil.toCSV(this.scanedJExpressConfigs.keySet());
                System.err.println("Missing config option, valid values <" + validOptions + ">");
                System.exit(1);
            }
            if ((c = ((SummerSingularity.ConfigMetadata)this.scanedJExpressConfigs.get((Object)cfgName)).cfgClass) == null) {
                String validOptions = FormatterUtil.toCSV(this.scanedJExpressConfigs.keySet());
                System.err.println(cfgName + "is an invalid config option, valid values <" + validOptions + ">");
                System.exit(1);
            }
            String t = BootConfig.generateTemplate(c);
            System.out.println(t);
            System.exit(0);
        }
        log.trace(() -> I18n.info.launching.format(this.userSpecifiedResourceBundle, new String[0]) + ", cmi=" + this.userSpecifiedCfgMonitorIntervalSec + ", StartCommand>" + this.jvmStartCommand);
        if (this.cli.hasOption(CLI_ENCRYPT)) {
            int updated = this.loadBootConfigFiles(ConfigUtil.ConfigLoadMode.cli_encrypt);
            System.out.println(System.lineSeparator() + "\t " + updated + " config items have been encrypted in " + this.userSpecifiedConfigDir.getAbsolutePath());
            System.exit(0);
        } else if (this.cli.hasOption(CLI_DECRYPT)) {
            if (this.cli.hasOption(CLI_ADMIN_PWD_FILE)) {
                System.err.println(System.lineSeparator() + "\t error: -authfile is not allowed for decryption, please private password with -auth option when decrypt data");
                System.exit(1);
            }
            int updated = this.loadBootConfigFiles(ConfigUtil.ConfigLoadMode.cli_decrypt);
            System.out.println(System.lineSeparator() + "\t " + updated + " config items have been decrypted in " + this.userSpecifiedConfigDir.getAbsolutePath());
            System.exit(0);
        }
        if (this.cli.hasOption(CLI_USE_IMPL)) {
            this.userSpecifiedImplTags.clear();
            String[] mockItemList = this.cli.getOptionValues(CLI_USE_IMPL);
            HashSet<String> mockInputValues = new HashSet<String>(Arrays.asList(mockItemList));
            mockInputValues.remove("");
            if (this.availableImplTagOptions.containsAll(mockInputValues)) {
                this.userSpecifiedImplTags.addAll(mockInputValues);
            } else {
                HashSet<String> invalidOptions = new HashSet<String>(mockInputValues);
                invalidOptions.removeAll(this.availableImplTagOptions);
                System.out.println("invalid -use value: " + FormatterUtil.toCSV(invalidOptions) + ", valid -use values: " + FormatterUtil.toCSV(this.availableImplTagOptions));
                System.exit(1);
            }
        }
        if (this.cli.hasOption(CLI_CONFIG_DEMO)) {
            int i = 0;
            for (String cfgName : this.scanedJExpressConfigs.keySet()) {
                Class c = ((SummerSingularity.ConfigMetadata)this.scanedJExpressConfigs.get((Object)cfgName)).cfgClass;
                try {
                    ConfigUtil.createConfigFile(c, this.userSpecifiedConfigDir, cfgName, true);
                }
                catch (IOException ex) {
                    System.out.println(ex + "\n\tFailed to generate config file (" + cfgName + ") in " + this.userSpecifiedConfigDir.getAbsolutePath());
                    ex.printStackTrace();
                    System.exit(1);
                }
                ++i;
            }
            System.out.println("Total generated " + i + " configuration files in " + this.userSpecifiedConfigDir.getAbsolutePath());
            System.exit(0);
        }
        if (this.cli.hasOption(CLI_I8N)) {
            String language = this.cli.getOptionValue(CLI_I8N);
            this.userSpecifiedResourceBundle = Locale.forLanguageTag(language);
        } else {
            this.userSpecifiedResourceBundle = null;
        }
        I18n.init(this.getAddtionalI18n());
    }

    protected abstract Class getAddtionalI18n();

    protected int loadBootConfigFiles(ConfigUtil.ConfigLoadMode mode) {
        LinkedHashMap<String, JExpressConfig> configs = new LinkedHashMap<String, JExpressConfig>();
        int updated = 0;
        switch (mode) {
            case app_run: {
                if (!this.hasControllers) {
                    this.memo.append("\n\t- cfg.loading.skip: no @Controller found, skip=").append(NioConfig.class.getSimpleName());
                    this.scanedJExpressConfigs.remove(NioConfig.class.getSimpleName());
                }
                if (!this.hasGRPCImpl) {
                    this.memo.append("\n\t- cfg.loading.skip: no gRPC Server stub found, skip=").append(GRPCServerConfig.class.getSimpleName());
                    this.scanedJExpressConfigs.remove(GRPCServerConfig.class.getSimpleName());
                }
                if (this.hasAuthImpl) break;
                this.memo.append("\n\t- cfg.loading.skip: no @DeclareRoles or @RolesAllowed found in any @Controller, skip=").append(AuthConfig.class.getSimpleName());
                this.scanedJExpressConfigs.remove(AuthConfig.class.getSimpleName());
            }
        }
        try {
            for (SummerSingularity.ConfigMetadata registeredAppConfig : this.scanedJExpressConfigs.values()) {
                if (this.isUserSpecifiedImplTags(registeredAppConfig.checkImplTagUsed) != registeredAppConfig.loadWhenImplTagUsed) continue;
                JExpressConfig instance = registeredAppConfig.instance;
                if (instance == null) {
                    instance = BootConfig.instance(registeredAppConfig.cfgClass);
                }
                this.memo.append("\n\t- cfg.loading=").append(instance).append(", info=").append(registeredAppConfig);
                if (instance == null) continue;
                configs.put(registeredAppConfig.configFileName, instance);
            }
            updated = ConfigUtil.loadConfigs(mode, log, this.userSpecifiedResourceBundle, this.userSpecifiedConfigDir.toPath(), configs, this.userSpecifiedCfgMonitorIntervalSec, this.userSpecifiedConfigDir);
        }
        catch (Throwable ex) {
            log.fatal(I18n.info.unlaunched.format(this.userSpecifiedResourceBundle, new String[0]), ex);
            System.exit(1);
        }
        return updated;
    }

    protected boolean isUserSpecifiedImplTags(String mockItemName) {
        return this.userSpecifiedImplTags.contains(mockItemName);
    }

    protected void genesis(Class primaryClass, Set<String> userSpecifiedImplTags) {
        Module applicationModule;
        BootGuiceModule defaultModule = new BootGuiceModule(this, primaryClass, userSpecifiedImplTags, this.memo);
        ScanedGuiceModule scanedModule = new ScanedGuiceModule(this.scanedServiceBindingMap, userSpecifiedImplTags, this.channelHandlerNames, this.memo);
        Module bootModule = Modules.override((Module[])new Module[]{defaultModule}).with(new Module[]{scanedModule});
        Module module = applicationModule = this.userOverrideModule == null ? bootModule : Modules.override((Module[])new Module[]{bootModule}).with(new Module[]{this.userOverrideModule});
        if (this.userOverrideModule == null) {
            this.memo.append("\n\t- init default Ioc @Conponent");
        } else {
            this.memo.append("\n\t- init user overridden Ioc @Conponent via").append(this.userOverrideModule.getClass().getName());
        }
        this.guiceInjector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{applicationModule});
        this.scanImplementation_SummerRunner(this.guiceInjector);
    }

    @Inject
    protected void onGuiceInjectorCreated_ControllersInjected(@Controller Map<String, Object> controllers) {
        JaxRsRequestProcessorManager.registerControllers(controllers, this.memo);
    }

    protected void scanImplementation_SummerRunner(Injector injector) {
        Set<Class<SummerRunner>> summerRunner_ImplClasses = ReflectionUtil.getAllImplementationsByInterface(SummerRunner.class, this.callerRootPackageName);
        TreeSet<Integer> orderSet = new TreeSet<Integer>();
        HashMap<Integer, ArrayList<SummerRunner>> orderMapping = new HashMap<Integer, ArrayList<SummerRunner>>();
        for (Class<SummerRunner> c : summerRunner_ImplClasses) {
            int order = 0;
            Order o = c.getAnnotation(Order.class);
            if (o != null) {
                order = o.value();
            }
            SummerRunner instance = (SummerRunner)injector.getInstance(c);
            orderSet.add(order);
            ArrayList<SummerRunner> sameOoderRunners = (ArrayList<SummerRunner>)orderMapping.get(order);
            if (sameOoderRunners == null) {
                sameOoderRunners = new ArrayList<SummerRunner>();
                orderMapping.put(order, sameOoderRunners);
            }
            sameOoderRunners.add(instance);
        }
        Iterator<Class<SummerRunner>> iterator = orderSet.iterator();
        while (iterator.hasNext()) {
            int order = (Integer)((Object)iterator.next());
            this.summerRunners.addAll((Collection)orderMapping.get(order));
        }
    }
}

