/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import io.netty.channel.ChannelHandler;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.SummerApplication;
import org.summerboot.jexpress.boot.annotation.Controller;
import org.summerboot.jexpress.boot.annotation.GrpcService;
import org.summerboot.jexpress.boot.annotation.Service;
import org.summerboot.jexpress.boot.annotation.Unique;
import org.summerboot.jexpress.boot.annotation.Version;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.boot.config.annotation.ImportResource;
import org.summerboot.jexpress.i18n.I18n;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.util.ApplicationUtil;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

public abstract class SummerSingularity
implements BootConstant {
    protected static Logger log;
    protected static final String CLI_CONFIG_DOMAIN = "domain";
    protected static final String CLI_CONFIG_DIR = "cfgdir";
    protected static final String DEFAULT_CFG_DIR_NAME = "configuration";
    protected static final File DEFAULT_CFG_DIR;
    protected static final File CURRENT_DIR;
    protected File userSpecifiedConfigDir;
    protected File pluginDir;
    protected final StringBuilder memo = new StringBuilder();
    protected final Class primaryClass;
    protected String jvmStartCommand;
    protected boolean jmxRequired;
    protected String callerRootPackageName;
    protected String appVersion = "SummerBoot.jExpress 2.3.7";
    protected String logFileName = "SummerBoot.jExpress 2.3.7";
    protected final List<String> availableUniqueTagOptions = new ArrayList<String>();
    protected final Map<String, ConfigMetadata> scanedJExpressConfigs = new LinkedHashMap<String, ConfigMetadata>();
    protected final Set<String> availableImplTagOptions = new HashSet<String>();
    protected final Set<Class<? extends BindableService>> gRPCBindableServiceImplClasses = new HashSet<Class<? extends BindableService>>();
    protected final Set<Class<ServerServiceDefinition>> gRPCServerServiceDefinitionImplClasses = new HashSet<Class<ServerServiceDefinition>>();
    protected boolean hasControllers = false;
    protected boolean hasGRPCImpl = false;
    protected boolean hasAuthImpl = false;
    protected final Map<Class, Map<String, List<ServiceMetadata>>> scanedServiceBindingMap = new HashMap<Class, Map<String, List<ServiceMetadata>>>();
    protected final Map<Service.ChannelHandlerType, Set<String>> channelHandlerNames = new HashMap<Service.ChannelHandlerType, Set<String>>();

    protected SummerSingularity(Class callerClass, String ... args) {
        System.out.println("SummerApplication loading from " + BootConstant.HOST);
        this.primaryClass = callerClass == null ? this.getClass() : callerClass;
        this.singularity();
        this.bigBang(args);
    }

    private void singularity() {
        SummerApplication.SystemErrorCodeAsInt = false;
        this.memo.setLength(0);
        this.userSpecifiedConfigDir = null;
        this.pluginDir = null;
        System.getProperties().remove("log4j.configurationFile");
        System.getProperties().remove("java.util.logging.manager");
        System.getProperties().remove("appPackage", "");
        System.getProperties().remove("appappName", "");
        System.getProperties().remove("version", "");
        System.setProperty("log4j.configurationFile", "");
        this.jvmStartCommand = null;
        this.jmxRequired = false;
        this.callerRootPackageName = null;
        this.appVersion = "SummerBoot.jExpress 2.3.7";
        this.logFileName = "SummerBoot.jExpress 2.3.7";
        this.availableUniqueTagOptions.clear();
        this.scanedJExpressConfigs.clear();
        this.availableImplTagOptions.clear();
        this.gRPCBindableServiceImplClasses.clear();
        this.gRPCServerServiceDefinitionImplClasses.clear();
        this.hasControllers = false;
        this.hasGRPCImpl = false;
        this.hasAuthImpl = false;
    }

    private <T extends SummerApplication> T bigBang(String[] args) {
        this.memo.append("\n\t- deployee callerClass=").append(this.primaryClass.getName());
        this.callerRootPackageName = ReflectionUtil.getRootPackageName(this.primaryClass);
        this.memo.append("\n\t- callerRootPackageName=").append(this.callerRootPackageName);
        StringBuilder sb = new StringBuilder();
        this.jmxRequired = ApplicationUtil.scanJVM_StartCommand(sb);
        this.jvmStartCommand = sb.toString();
        this.scanAnnotation_Version(this.primaryClass);
        System.setProperty("appPackage", this.callerRootPackageName);
        System.setProperty("appappName", this.logFileName);
        System.setProperty("version", this.appVersion);
        this.scanArgsToInitializePluginFromConfigDir(args);
        log = LogManager.getLogger(SummerApplication.class);
        log.debug("Configuration path = {}", (Object)this.userSpecifiedConfigDir);
        try {
            this.scanPluginJars(this.pluginDir, true);
        }
        catch (IOException ex) {
            System.out.println(ex + "\n\tFailed to load plugin jar files from " + this.pluginDir);
            ex.printStackTrace();
            System.exit(1);
        }
        String error2 = this.scanAnnotation_Unique(this.callerRootPackageName, this.memo, new String[0]);
        if (error2 != null) {
            System.out.println(error2);
            System.exit(1);
        }
        this.scanAnnotation_JExpressConfigImportResource("org.summerboot.jexpress", this.callerRootPackageName);
        this.scanImplementation_gRPC(this.callerRootPackageName);
        this.scanAnnotation_Controller(this.callerRootPackageName);
        this.scanAnnotation_Service(this.callerRootPackageName);
        this.scanAnnotation_DeclareRoles(this.callerRootPackageName);
        return (T)((SummerApplication)this);
    }

    protected void scanAnnotation_Version(Class callerClass) {
        Version version = callerClass.getAnnotation(Version.class);
        if (version != null) {
            String logManager = version.LogManager();
            if (StringUtils.isNotBlank((CharSequence)logManager)) {
                System.setProperty("java.util.logging.manager", logManager);
            }
            SummerApplication.SystemErrorCodeAsInt = version.SystemErrorCodeAsInt();
            this.logFileName = version.logFileName();
            if (StringUtils.isBlank((CharSequence)this.logFileName)) {
                this.logFileName = version.value()[0];
            }
            this.appVersion = version.value()[0];
            System.setProperty("version.short", this.appVersion);
            int versionCount = version.value().length;
            if (versionCount > 1) {
                this.appVersion = this.appVersion + " (";
                for (int i = 1; i < versionCount; ++i) {
                    this.appVersion = this.appVersion + version.value()[i] + " ";
                }
                this.appVersion = this.appVersion + ")";
            }
        } else {
            this.logFileName = "app";
        }
        this.memo.append("\n\t- callerVersion=").append(this.appVersion);
    }

    protected void scanArgsToInitializePluginFromConfigDir(String[] args) {
        this.userSpecifiedConfigDir = null;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String cli = args[i];
                if ("-cfgdir".equals(cli)) {
                    String cfgDir = args[++i];
                    this.userSpecifiedConfigDir = new File(cfgDir).getAbsoluteFile();
                    break;
                }
                if (!"-domain".equals(cli)) continue;
                String envTag = args[++i];
                String cfgDir = "standalone_" + envTag + File.separator + DEFAULT_CFG_DIR_NAME;
                this.userSpecifiedConfigDir = new File(cfgDir).getAbsoluteFile();
                System.setProperty("domainName", envTag);
                break;
            }
        }
        if (this.userSpecifiedConfigDir == null) {
            this.userSpecifiedConfigDir = DEFAULT_CFG_DIR;
        }
        if (!this.userSpecifiedConfigDir.exists()) {
            this.userSpecifiedConfigDir.mkdirs();
        }
        if (!(this.userSpecifiedConfigDir.exists() && this.userSpecifiedConfigDir.isDirectory() && this.userSpecifiedConfigDir.canRead())) {
            System.out.println("Could access configuration path as a folder: " + this.userSpecifiedConfigDir);
            System.exit(1);
        }
        System.setProperty("logDir", this.userSpecifiedConfigDir.getParent());
        this.pluginDir = new File(this.userSpecifiedConfigDir.getParentFile(), "plugin").getAbsoluteFile();
        String location = this.userSpecifiedConfigDir.getAbsolutePath();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Path logFilePath = ApplicationUtil.createIfNotExist(location, classLoader, "log4j2.xml.temp", "log4j2.xml");
        String log4j2ConfigFile = logFilePath.toString();
        System.setProperty("log4j.configurationFile", log4j2ConfigFile);
        Locale userSpecifiedResourceBundle = null;
        this.memo.append("\n\t- ").append(I18n.info.launchingLog.format(userSpecifiedResourceBundle, System.getProperty("log4j.configurationFile")));
    }

    protected void scanPluginJars(File pluginDir, boolean failOnUndefinedClasses) throws IOException {
        pluginDir.mkdirs();
        if (!pluginDir.canRead() || !pluginDir.isDirectory()) {
            this.memo.append("\n\t- loadPluginJars: invalid dir ").append(pluginDir);
            return;
        }
        FileFilter fileFilter = file -> !file.isDirectory() && file.getName().endsWith(".jar");
        File[] jarFiles = pluginDir.listFiles(fileFilter);
        if (jarFiles == null || jarFiles.length < 1) {
            this.memo.append("\n\t- loadPluginJars: no jar files found at ").append(pluginDir);
            return;
        }
        HashSet pluginClasses = new HashSet();
        for (File jarFile : jarFiles) {
            this.memo.append("\n\t- loadPluginJars: loading jar file ").append(jarFile.getAbsolutePath());
            Set<Class<?>> classes = ApplicationUtil.loadClassFromJarFile(jarFile, failOnUndefinedClasses);
            this.memo.append("\n\t- loadPluginJars: loaded ").append(classes.size()).append(" classes from jar file ").append(jarFile.getAbsolutePath());
            pluginClasses.addAll(classes);
        }
        ReflectionUtil.setPluginClasses(pluginClasses);
        this.memo.append("\n\t- loadPluginJars: loaded ").append(pluginClasses.size()).append(" classes from ").append(jarFiles.length).append(" jar files in ").append(pluginDir);
    }

    protected String scanAnnotation_Unique(String rootPackageName, StringBuilder sb, String ... displayByTags) {
        Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Unique.class, rootPackageName, false);
        StringBuilder errors = new StringBuilder();
        boolean error2 = false;
        for (Class<?> classWithUniqueValues : classes) {
            if (!classWithUniqueValues.isInterface()) {
                error2 = true;
                errors.append("\n\t @Unique can only apply on interfaces, ").append(classWithUniqueValues).append(" is not an interface");
                continue;
            }
            Unique u = classWithUniqueValues.getAnnotation(Unique.class);
            String tag = u.name();
            this.availableUniqueTagOptions.add(tag);
            Class uniqueType = u.type();
            List<String> tags = List.of(displayByTags);
            try {
                Map<Object, Set<String>> duplicated = ApplicationUtil.checkDuplicateFields(classWithUniqueValues, uniqueType);
                if (!duplicated.isEmpty()) {
                    String report = BeanUtil.toJson(duplicated, true, false);
                    return "Duplicated " + uniqueType.getSimpleName() + " values in " + classWithUniqueValues.getSimpleName() + " " + report;
                }
                if (!tags.contains(tag)) continue;
                HashMap results = new HashMap();
                ReflectionUtil.loadFields(classWithUniqueValues, uniqueType, results, false);
                Map sorted = results.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (e1, e2) -> e1, LinkedHashMap::new));
                String json = BeanUtil.toJson(sorted, true, false);
                sb.append("\n").append(tag).append("=").append(json);
            }
            catch (Throwable ex) {
                throw new RuntimeException("check unique failed on package " + rootPackageName + ".*", ex);
            }
        }
        if (error2) {
            throw new RuntimeException(errors.toString());
        }
        return null;
    }

    protected void scanAnnotation_JExpressConfigImportResource(String ... rootPackageNames) {
        Set<String> pakcages = Set.copyOf(List.of(rootPackageNames));
        HashSet<Class<JExpressConfig>> classesAll = new HashSet<Class<JExpressConfig>>();
        for (String string : pakcages) {
            Set<Class<JExpressConfig>> jExpressConfigClasses = ReflectionUtil.getAllImplementationsByInterface(JExpressConfig.class, string);
            classesAll.addAll(jExpressConfigClasses);
        }
        for (Class clazz : classesAll) {
            String key;
            int mod = clazz.getModifiers();
            if (Modifier.isAbstract(mod) || Modifier.isInterface(mod) || this.scanedJExpressConfigs.containsKey(key = clazz.getSimpleName())) continue;
            String configFileName = null;
            ImportResource ir = clazz.getAnnotation(ImportResource.class);
            if (ir != null) {
                configFileName = ir.value();
                String checkImplTagUsed = ir.checkImplTagUsed();
                boolean loadWhenImplTagUsed = ir.loadWhenImplTagUsed();
                ConfigMetadata metadata = new ConfigMetadata(configFileName, clazz, null, checkImplTagUsed, loadWhenImplTagUsed);
                this.scanedJExpressConfigs.put(key, metadata);
                this.memo.append("\n\t- scan.JExpressConfig.ImportResource:").append(key).append("=").append(metadata);
            }
            this.memo.append("\n\t- cfg.scaned=").append(clazz.getName()).append(", file=").append(configFileName);
        }
    }

    protected void scanImplementation_gRPC(String ... pakcages) {
        for (String rootPackageName : pakcages) {
            Set<Class<?>> gRPCServerClasses = ReflectionUtil.getAllImplementationsByAnnotation(GrpcService.class, rootPackageName, false);
            for (Class<?> gRPCServerClass : gRPCServerClasses) {
                if (BindableService.class.isAssignableFrom(gRPCServerClass)) {
                    this.gRPCBindableServiceImplClasses.add(gRPCServerClass);
                    continue;
                }
                if (!ServerServiceDefinition.class.equals(gRPCServerClass)) continue;
                this.gRPCServerServiceDefinitionImplClasses.add(gRPCServerClass);
            }
        }
        this.hasGRPCImpl = !this.gRPCServerServiceDefinitionImplClasses.isEmpty() || !this.gRPCBindableServiceImplClasses.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    protected void scanAnnotation_Controller(String ... rootPackageNames) {
        void var5_7;
        HashSet classesAll = new HashSet();
        String[] stringArray = rootPackageNames;
        int n = stringArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            String rootPackageName = stringArray[var5_7];
            Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Controller.class, rootPackageName, false);
            classesAll.addAll(classes);
            ++var5_7;
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (Class clazz : classesAll) {
            Controller a = clazz.getAnnotation(Controller.class);
            if (a == null) continue;
            String implTag = a.implTag();
            tags.add(implTag);
        }
        List serviceImplTags = tags.stream().distinct().collect(Collectors.toList());
        serviceImplTags.removeAll(Collections.singleton(null));
        serviceImplTags.removeAll(Collections.singleton(""));
        serviceImplTags.removeAll(Collections.singleton(""));
        this.availableImplTagOptions.addAll(serviceImplTags);
    }

    protected List<String> scanAnnotation_Service(String ... rootPackageNames) {
        HashSet classesAll = new HashSet();
        for (String rootPackageName : rootPackageNames) {
            Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Service.class, rootPackageName, false);
            classesAll.addAll(classes);
        }
        return this.scanAnnotation_Service(classesAll);
    }

    protected List<String> scanAnnotation_Service(Set<Class<?>> classesAll) {
        ArrayList<String> tags = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (Class<?> serviceImplClass : classesAll) {
            Service serviceAnnotation = serviceImplClass.getAnnotation(Service.class);
            if (serviceAnnotation == null) continue;
            String named = serviceAnnotation.named().trim();
            String implTag = serviceAnnotation.implTag().trim();
            tags.add(implTag);
            String uniqueKey = "named=" + named + ", implTag=" + implTag;
            Class[] bindingClasses = serviceAnnotation.binding();
            Service.ChannelHandlerType ChannelHandlerType2 = serviceAnnotation.type();
            if (bindingClasses != null && bindingClasses.length > 0) {
                for (Class bindingClass : bindingClasses) {
                    if (!bindingClass.isAssignableFrom(serviceImplClass)) {
                        List<Class> interfaces = ReflectionUtil.getAllInterfaces(serviceImplClass, true);
                        List<Class> superclasses = ReflectionUtil.getAllSuperClasses(serviceImplClass);
                        interfaces.addAll(superclasses);
                        interfaces.remove(Object.class);
                        sb.append("\n\t").append(serviceImplClass).append(" specifies @").append(Service.class.getSimpleName()).append("(binding=").append(bindingClass.getSimpleName()).append(".class), which is not in its Interfaces:").append(interfaces);
                        continue;
                    }
                    this.scanAnnotation_Service_Add2BindingMap(bindingClass, uniqueKey, new ServiceMetadata(serviceImplClass, named, implTag, ChannelHandlerType2), sb);
                }
                continue;
            }
            List<Class> declaredInterfaces = ReflectionUtil.getAllInterfaces(serviceImplClass, false);
            if (declaredInterfaces.isEmpty()) {
                List<Class> superInterfaces = ReflectionUtil.getAllInterfaces(serviceImplClass.getSuperclass(), true);
                if (superInterfaces.isEmpty()) {
                    sb.append("\n\t").append(serviceImplClass).append(" does not implement any interfaces.");
                    continue;
                }
                sb.append("\n\t").append(serviceImplClass).append(" needs to specify the binding interface @").append(Service.class.getSimpleName()).append("(binding=TheMissingInterface.class), which implemented by supper class: ").append(superInterfaces);
                continue;
            }
            for (Class bindingClass : declaredInterfaces) {
                this.scanAnnotation_Service_Add2BindingMap(bindingClass, uniqueKey, new ServiceMetadata(serviceImplClass, named, implTag, ChannelHandlerType2), sb);
            }
        }
        this.scanAnnotation_Service_ValidateBindingMap(sb);
        String error2 = sb.toString();
        if (!error2.isBlank()) {
            System.out.println("IOC Code error:" + sb);
            System.exit(1);
        }
        List<String> serviceImplTags = tags.stream().distinct().collect(Collectors.toList());
        serviceImplTags.removeAll(Collections.singleton(null));
        serviceImplTags.removeAll(Collections.singleton(""));
        serviceImplTags.removeAll(Collections.singleton(""));
        this.availableImplTagOptions.addAll(serviceImplTags);
        return serviceImplTags;
    }

    protected void scanAnnotation_Service_Add2BindingMap(Class bindingClass, String uniqueKey, ServiceMetadata service, StringBuilder sb) {
        Service.ChannelHandlerType channelHandlerType;
        List<ServiceMetadata> serviceImplList;
        this.memo.append("\n\t- scan.taggedservice.add to guiceModule.bind(").append(bindingClass.getName()).append(").to(").append(service).append("), uniqueKey=").append(uniqueKey);
        Map<String, List<ServiceMetadata>> taggeServicedMap = this.scanedServiceBindingMap.get(bindingClass);
        if (taggeServicedMap == null) {
            taggeServicedMap = new HashMap<String, List<ServiceMetadata>>();
            this.scanedServiceBindingMap.put(bindingClass, taggeServicedMap);
        }
        if ((serviceImplList = taggeServicedMap.get(uniqueKey)) == null) {
            serviceImplList = new ArrayList<ServiceMetadata>();
            taggeServicedMap.put(uniqueKey, serviceImplList);
        }
        if (bindingClass.equals(ChannelHandler.class) && ((channelHandlerType = service.getChannelHandlerType()) == null || channelHandlerType == Service.ChannelHandlerType.nptspecified)) {
            sb.append("\n\t").append(service.getServiceImplClass()).append(" needs to specify type @").append(Service.class.getSimpleName()).append("(binding=ChannelHandler.class, type=?), when binding=ChannelHandler.class");
        }
        serviceImplList.add(service);
    }

    protected void scanAnnotation_Service_ValidateBindingMap(StringBuilder sb) {
        for (Class keyBindingClass : this.scanedServiceBindingMap.keySet()) {
            Map<String, List<ServiceMetadata>> taggeServicedMap = this.scanedServiceBindingMap.get(keyBindingClass);
            for (String keyImplTag : taggeServicedMap.keySet()) {
                List<ServiceMetadata> serviceImplList = taggeServicedMap.get(keyImplTag);
                int size = serviceImplList.size();
                if (size == 1) continue;
                sb.append("\nIOC ").append(keyBindingClass).append(" required a single bean, but ").append(size).append(" were found with the same named+implTag(").append(keyImplTag).append("): ").append(serviceImplList);
            }
        }
    }

    protected void scanAnnotation_DeclareRoles(String ... rootPackageNames) {
        TreeSet<String> declareRoles = new TreeSet<String>();
        HashSet classesAll = new HashSet();
        for (String rootPackageName : rootPackageNames) {
            Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Controller.class, rootPackageName, false);
            classesAll.addAll(classes);
        }
        this.hasControllers = !classesAll.isEmpty();
        for (Class clazz : classesAll) {
            DeclareRoles drs = clazz.getAnnotation(DeclareRoles.class);
            if (drs != null) {
                String[] roles = drs.value();
                declareRoles.addAll(Arrays.asList(roles));
            }
            List<Method> methods = ReflectionUtil.getDeclaredAndSuperClassesMethods(clazz, true);
            for (Method javaMethod : methods) {
                RolesAllowed ra = javaMethod.getAnnotation(RolesAllowed.class);
                if (ra == null) continue;
                String[] roles = ra.value();
                declareRoles.addAll(Arrays.asList(roles));
            }
        }
        AuthConfig authCfg = AuthConfig.cfg;
        authCfg.addDeclareRoles(declareRoles);
        this.memo.append("\n\t- scan.DeclareRoles=").append(declareRoles);
        this.hasAuthImpl = !authCfg.getDeclareRoles().isEmpty();
    }

    static {
        DEFAULT_CFG_DIR = new File(DEFAULT_CFG_DIR_NAME).getAbsoluteFile();
        CURRENT_DIR = new File("").getAbsoluteFile();
    }

    protected static class ConfigMetadata {
        final Class cfgClass;
        final String configFileName;
        final JExpressConfig instance;
        final String checkImplTagUsed;
        final boolean loadWhenImplTagUsed;

        ConfigMetadata(String configFileName, Class cfgClass, JExpressConfig instance, String checkImplTagUsed, boolean loadWhenImplTagUsed) {
            this.configFileName = configFileName;
            this.cfgClass = cfgClass;
            this.instance = instance;
            this.checkImplTagUsed = checkImplTagUsed;
            this.loadWhenImplTagUsed = loadWhenImplTagUsed;
        }

        public String toString() {
            return "ConfigMetadata{cfgClass=" + this.cfgClass.getName() + ", configFileName=" + this.configFileName + ", instance=" + this.instance + ", checkImplTagUsed=" + this.checkImplTagUsed + ", loadWhenImplTagUsed=" + this.loadWhenImplTagUsed + "}";
        }
    }

    public static class ServiceMetadata {
        final Class serviceImplClass;
        final String named;
        final String implTag;
        final Service.ChannelHandlerType channelHandlerType;

        public ServiceMetadata(Class serviceImplClass, String named, String implTag, Service.ChannelHandlerType channelHandlerType) {
            this.serviceImplClass = serviceImplClass;
            this.named = named;
            this.implTag = implTag;
            this.channelHandlerType = channelHandlerType;
        }

        public String toString() {
            return "ServiceImpl{" + this.serviceImplClass.getName() + ", named=" + this.named + ", implTag=" + this.implTag + "}";
        }

        public Class getServiceImplClass() {
            return this.serviceImplClass;
        }

        public String getNamed() {
            return this.named;
        }

        public String getImplTag() {
            return this.implTag;
        }

        public Service.ChannelHandlerType getChannelHandlerType() {
            return this.channelHandlerType;
        }
    }
}

