/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.summerboot.jexpress.nio.grpc.BearerAuthCredential;
import org.summerboot.jexpress.security.auth.Caller;

public abstract class BootServerInterceptor
implements ServerInterceptor {
    public static final Context.Key<String> CONTEXT_KEY_USER_ID = Context.key((String)"uid");
    public static final Context.Key<Caller> CONTEXT_KEY_CALLER = Context.key((String)"caller");

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        Status status;
        String headerValueAuthorization = (String)metadata.get(BearerAuthCredential.AUTHORIZATION_METADATA_KEY);
        if (headerValueAuthorization == null) {
            status = Status.UNAUTHENTICATED.withDescription("Authorization header is missing");
        } else if (!headerValueAuthorization.startsWith("Bearer")) {
            status = Status.UNAUTHENTICATED.withDescription("Unknown authorization type, non bearer token provided");
        } else {
            try {
                String jwt = headerValueAuthorization.substring("Bearer".length()).trim();
                Caller caller = this.buildCaller(jwt);
                Context ctx = Context.current().withValue(CONTEXT_KEY_CALLER, (Object)caller);
                return Contexts.interceptCall((Context)ctx, serverCall, (Metadata)metadata, serverCallHandler);
            }
            catch (Throwable ex) {
                status = Status.UNAUTHENTICATED.withDescription(ex.getMessage()).withCause(ex);
            }
        }
        serverCall.close(status, metadata);
        return new ServerCall.Listener<ReqT>(){};
    }

    protected abstract Caller buildCaller(String var1);
}

