/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.boot.config.annotation.ImportResource;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@ImportResource(value="cfg_grpc.properties")
public class GRPCServerConfig
extends BootConfig {
    protected static final String ID = "gRpc.server";
    public static final GRPCServerConfig cfg = new GRPCServerConfig();
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();
    @ConfigHeader(title="1. gRpc.server Network Listeners", format="ip1:port1, ip2:port2, ..., ipN:portN", example="192.168.1.10:8424, 127.0.0.1:8424, 0.0.0.0:8424")
    @Config(key="gRpc.server.bindings", predefinedValue="0.0.0.0:8424, 0.0.0.0:8425", required=true)
    private volatile List<InetSocketAddress> bindingAddresses;
    @Config(key="gRpc.server.autostart", defaultValue="true")
    private volatile boolean autoStart;
    @Config(key="gRpc.server.pool.BizExecutor.mode", defaultValue="Mixed", desc="valid value = CPU (default), IO, Mixed")
    private volatile ThreadingMode threadingMode = ThreadingMode.Mixed;
    @Config(key="gRpc.server.pool.coreSize", predefinedValue="0", desc="coreSize 0 = current computer/VM's available processors x 2 + 1")
    private volatile int poolCoreSize = this.availableProcessors * 2 + 1;
    @Config(key="gRpc.server.pool.maxSize", predefinedValue="0", desc="maxSize 0 = current computer/VM's available processors x 2 + 1")
    private volatile int poolMaxSizeMaxSize = this.availableProcessors * 2 + 1;
    @Config(key="gRpc.server.pool.queueSize", defaultValue="2147483647", desc="The waiting list size when the pool is full")
    private volatile int poolQueueSize = Integer.MAX_VALUE;
    @Config(key="gRpc.server.pool.keepAliveSeconds", defaultValue="60")
    private volatile long keepAliveSeconds = 60L;
    private static final String KEY_kmf_key = "gRpc.server.ssl.KeyStore";
    private static final String KEY_kmf_StorePwdKey = "gRpc.server.ssl.KeyStorePwd";
    private static final String KEY_kmf_AliasKey = "gRpc.server.ssl.KeyAlias";
    private static final String KEY_kmf_AliasPwdKey = "gRpc.server.ssl.KeyPwd";
    @ConfigHeader(title="2. gRpc.server keystore")
    @Config(key="gRpc.server.ssl.KeyStore", StorePwdKey="gRpc.server.ssl.KeyStorePwd", AliasKey="gRpc.server.ssl.KeyAlias", AliasPwdKey="gRpc.server.ssl.KeyPwd", desc="Path to key store file. Use SSL/TLS when keystore is provided, otherwise use plain socket", callbackMethodName4Dump="generateTemplate_keystore")
    protected volatile KeyManagerFactory kmf;
    private static final String KEY_tmf_key = "gRpc.server.ssl.TrustStore";
    private static final String KEY_tmf_StorePwdKey = "gRpc.server.ssl.TrustStorePwd";
    @ConfigHeader(title="3. gRpc.server truststore")
    @Config(key="gRpc.server.ssl.TrustStore", StorePwdKey="gRpc.server.ssl.TrustStorePwd", callbackMethodName4Dump="generateTemplate_truststore", desc="Path to trust store file. Auth the remote peer certificate when a truststore is provided, otherwise blindly trust all remote peer certificate")
    @JsonIgnore
    protected volatile TrustManagerFactory tmf;

    public static void main(String[] args) {
        String t = GRPCServerConfig.generateTemplate(GRPCServerConfig.class);
        System.out.println(t);
    }

    protected GRPCServerConfig() {
    }

    protected void generateTemplate_keystore(StringBuilder sb) {
        sb.append("gRpc.server.ssl.KeyStore=tls_keystore.p12\n");
        sb.append("gRpc.server.ssl.KeyStorePwd=DEC(changeit)\n");
        sb.append("gRpc.server.ssl.KeyAlias=server2_4096.jexpress.org\n");
        sb.append("gRpc.server.ssl.KeyPwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    protected void generateTemplate_truststore(StringBuilder sb) {
        sb.append("gRpc.server.ssl.TrustStore=tls_truststore_4server.p12\n");
        sb.append("gRpc.server.ssl.TrustStorePwd=DEC(changeit)\n");
        this.generateTemplate = true;
    }

    @Override
    protected void preLoad(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) {
        this.createIfNotExist("tls_keystore.p12");
        this.createIfNotExist("tls_truststore_4server.p12");
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws IOException {
        int cpuCoreSize = this.availableProcessors;
        switch (this.threadingMode) {
            case CPU: {
                this.poolMaxSizeMaxSize = this.poolCoreSize = cpuCoreSize + 1;
                break;
            }
            case IO: {
                this.poolMaxSizeMaxSize = this.poolCoreSize = cpuCoreSize * 2 + 1;
                break;
            }
            case Mixed: {
                if (this.poolCoreSize < 1) {
                    this.poolCoreSize = cpuCoreSize * 2 + 1;
                }
                if (this.poolMaxSizeMaxSize < 1) {
                    this.poolMaxSizeMaxSize = cpuCoreSize * 2 + 1;
                }
                if (this.poolMaxSizeMaxSize >= this.poolCoreSize) break;
                this.poolMaxSizeMaxSize = this.poolCoreSize;
            }
        }
    }

    @Override
    public void shutdown() {
    }

    public List<InetSocketAddress> getBindingAddresses() {
        return this.bindingAddresses;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public ThreadingMode getThreadingMode() {
        return this.threadingMode;
    }

    public int getPoolCoreSize() {
        return this.poolCoreSize;
    }

    public int getPoolMaxSizeMaxSize() {
        return this.poolMaxSizeMaxSize;
    }

    public int getPoolQueueSize() {
        return this.poolQueueSize;
    }

    public long getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    public TrustManagerFactory getTmf() {
        return this.tmf;
    }

    public static enum ThreadingMode {
        CPU,
        IO,
        Mixed;

    }
}

