/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpTimeoutException;
import java.nio.channels.UnresolvedAddressException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.naming.NamingException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import org.summerboot.jexpress.nio.server.NioExceptionListener;
import org.summerboot.jexpress.nio.server.NioLifecycleListener;
import org.summerboot.jexpress.nio.server.NioServerHttpRequestHandler;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.ProcessorSettings;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.security.auth.Authenticator;

@Singleton
@ChannelHandler.Sharable
public class BootHttpRequestHandler
extends NioServerHttpRequestHandler {
    @Inject
    protected Authenticator authenticator;
    @Inject
    protected NioExceptionListener nioExceptionListener;
    @Inject
    protected AuthTokenCache tokenCache;
    @Inject
    protected NioLifecycleListener nioLifecycleListener;
    protected static SMTPClientConfig cmtpCfg = SMTPClientConfig.cfg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProcessorSettings service(ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        ProcessorSettings processorSettings = null;
        RequestProcessor processor = null;
        try {
            processor = this.getRequestProcessor(httptMethod, httpRequestPath);
            if (processor == null && (processor = this.getRequestProcessor(httptMethod, "")) == null) {
                this.nioExceptionListener.onActionNotFound(ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                ProcessorSettings processorSettings2 = processorSettings;
                return processorSettings2;
            }
            processorSettings = processor.getProcessorSettings();
            ProcessorSettings.LogSettings logSettings = processorSettings.getLogSettings();
            if (logSettings != null) {
                context.logRequestHeader(logSettings.isLogRequestHeader());
                context.logRequestBody(logSettings.isLogRequestBody());
                context.logResponseHeader(logSettings.isLogResponseHeader());
                context.logResponseBody(logSettings.isLogResponseBody());
            }
            if (processor.isRoleBased()) {
                context.poi("auth.begin");
                if (!this.authenticationCheck(processor, httpRequestHeaders, httpRequestPath, context)) {
                    context.status(HttpResponseStatus.UNAUTHORIZED);
                    ProcessorSettings processorSettings3 = processorSettings;
                    return processorSettings3;
                }
                if (!processor.authorizationCheck(ctx, httpRequestHeaders, httpRequestPath, queryParams, httpPostRequestBody, context, 46)) {
                    context.status(HttpResponseStatus.FORBIDDEN);
                    ProcessorSettings processorSettings4 = processorSettings;
                    return processorSettings4;
                }
            }
            context.poi("process.begin");
            if (this.authenticator != null && !this.authenticator.customizedAuthorizationCheck(processor, httpRequestHeaders, httpRequestPath, context)) {
                ProcessorSettings processorSettings5 = processorSettings;
                return processorSettings5;
            }
            if (!this.nioLifecycleListener.beofreProcess(processor, httpRequestHeaders, httpRequestPath, context)) {
                ProcessorSettings processorSettings6 = processorSettings;
                return processorSettings6;
            }
            processor.process(ctx, httpRequestHeaders, httpRequestPath, queryParams, httpPostRequestBody, context, 10);
        }
        catch (NamingException ex) {
            this.nioExceptionListener.onNamingException(ex, httptMethod, httpRequestPath, context);
        }
        catch (PersistenceException ex) {
            this.nioExceptionListener.onPersistenceException(ex, httptMethod, httpRequestPath, context);
        }
        catch (HttpConnectTimeoutException ex) {
            this.nioExceptionListener.onHttpConnectTimeoutException(ex, httptMethod, httpRequestPath, context);
        }
        catch (HttpTimeoutException ex) {
            this.nioExceptionListener.onHttpTimeoutException(ex, httptMethod, httpRequestPath, context);
        }
        catch (RejectedExecutionException ex) {
            this.nioExceptionListener.onRejectedExecutionException(ex, httptMethod, httpRequestPath, context);
        }
        catch (IOException | UnresolvedAddressException ex) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            if (cause == null) {
                cause = ex;
            }
            if (cause instanceof RejectedExecutionException) {
                this.nioExceptionListener.onRejectedExecutionException(ex, httptMethod, httpRequestPath, context);
            } else {
                this.nioExceptionListener.onIOException(ex, httptMethod, httpRequestPath, context);
            }
        }
        catch (InterruptedException ex) {
            this.nioExceptionListener.onInterruptedException(ex, httptMethod, httpRequestPath, context);
        }
        catch (Throwable ex) {
            this.nioExceptionListener.onUnexpectedException(ex, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
        }
        finally {
            this.nioLifecycleListener.afterProcess(processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
            context.poi("process.end");
        }
        return processorSettings;
    }

    protected boolean authenticationCheck(RequestProcessor processor, HttpHeaders httpRequestHeaders, String httpRequestPath, ServiceContext context) throws Exception {
        if (this.authenticator == null) {
            return true;
        }
        this.authenticator.verifyBearerToken(httpRequestHeaders, this.tokenCache, null, context);
        return context.caller() != null;
    }

    @Override
    protected String beforeLogging(String originallLogContent, HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestUri, String httpPostRequestBody, ServiceContext context, long queuingTime, long processTime, long responseTime, long responseContentLength, Throwable ioEx) {
        return this.nioLifecycleListener.beforeLogging(originallLogContent, httpHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, ioEx);
    }

    @Override
    protected void afterLogging(String logContent, HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestUri, String httpPostRequestBody, ServiceContext context, long queuingTime, long processTime, long responseTime, long responseContentLength, Throwable ioEx) throws Exception {
        this.nioLifecycleListener.afterLogging(logContent, httpHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, ioEx);
    }

    @Override
    public String beforeSendingError(String errorContent) {
        return this.nioLifecycleListener.beforeSendingError(errorContent);
    }
}

