/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.lang.annotation.Annotation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.nio.server.BootHttpFileUploadRejector;
import org.summerboot.jexpress.nio.server.HeartbeatRecIdleStateHandler;
import org.summerboot.jexpress.nio.server.HeartbeatSentIdleStateHandler;
import org.summerboot.jexpress.nio.server.NioChannelInitializer;
import org.summerboot.jexpress.nio.server.NioConfig;

public class HttpNioChannelInitializer
extends NioChannelInitializer {
    private static final ChannelHandler DefaultFileUploadRejector = new BootHttpFileUploadRejector();
    private static final Logger LoggingHandlerLogger = LogManager.getLogger(LoggingHandler.class);
    @Inject
    @Named(value="BootHttpPingHandler")
    private ChannelHandler defaultHttpPingHandler;
    @Inject
    @Named(value="BootHttpRequestHandler")
    private ChannelHandler defaultHttpRequestHandler;
    private final ChannelHandler defaultLoggingHandler = new LoggingHandler(LogLevel.DEBUG);

    @Override
    protected void initChannelPipeline(ChannelPipeline channelPipeline, NioConfig nioCfg) {
        ChannelHandler ch;
        if (LoggingHandlerLogger.isDebugEnabled()) {
            channelPipeline.addLast(new ChannelHandler[]{this.defaultLoggingHandler});
        }
        if (nioCfg.getReaderIdleSeconds() > 0) {
            if (this.namedReadIdle != null) {
                for (String named : this.namedReadIdle) {
                    ch = (ChannelHandler)this.injector.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)named)));
                    channelPipeline.addLast("tcp-ping_" + named, ch);
                }
            } else {
                channelPipeline.addLast("tcp-ping", (ChannelHandler)new HeartbeatRecIdleStateHandler(nioCfg.getReaderIdleSeconds()));
            }
        }
        if (nioCfg.getWriterIdleSeconds() > 0) {
            if (this.namedWriteIdle != null) {
                for (String named : this.namedWriteIdle) {
                    ch = (ChannelHandler)this.injector.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)named)));
                    channelPipeline.addLast("tcp-pong_" + named, ch);
                }
            } else {
                channelPipeline.addLast("tcp-pong", (ChannelHandler)new HeartbeatSentIdleStateHandler(nioCfg.getWriterIdleSeconds()));
            }
        }
        channelPipeline.addLast("http-codec", (ChannelHandler)new HttpServerCodec(nioCfg.getHttpServerCodec_MaxInitialLineLength(), nioCfg.getHttpServerCodec_MaxHeaderSize(), nioCfg.getHttpServerCodec_MaxChunkSize()));
        channelPipeline.addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
        if (this.namedFileUpload != null) {
            for (String named : this.namedFileUpload) {
                ch = (ChannelHandler)this.injector.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)named)));
                channelPipeline.addLast("FileUpload_" + named, ch);
            }
        } else {
            channelPipeline.addLast("FileUploadRejector", DefaultFileUploadRejector);
        }
        channelPipeline.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(nioCfg.getHttpObjectAggregatorMaxContentLength()));
        if (this.namedWebsocket != null) {
            boolean isWebSocketCompress = nioCfg.isWebSocketCompress();
            if (isWebSocketCompress) {
                channelPipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
            }
            boolean allowExtensions = nioCfg.isWebSocketAllowExtensions();
            int maxFrameSize = nioCfg.getWebSocketMaxFrameSize();
            boolean allowMaskMismatch = nioCfg.isWebSocketAllowMaskMismatch();
            boolean checkStartsWith = nioCfg.isWebSocketCheckStartsWith();
            boolean dropPongFrames = nioCfg.isWebSocketDropPongFrames();
            long handshakeTimeoutMillis = nioCfg.getWebSocketHandshakeTimeoutMillis();
            boolean isWebSocketServerProtocolHandlerRequired = true;
            for (String named : this.namedWebsocket) {
                ch = (ChannelHandler)this.injector.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)named)));
                if (ch == null) continue;
                if (isWebSocketServerProtocolHandlerRequired) {
                    String webSocketURI = named;
                    String subprotocols = null;
                    channelPipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(webSocketURI, subprotocols, allowExtensions, maxFrameSize, allowMaskMismatch, checkStartsWith, dropPongFrames, handshakeTimeoutMillis)});
                    isWebSocketServerProtocolHandlerRequired = false;
                }
                channelPipeline.addLast("Websocket_" + named, ch);
            }
        }
        if (this.namedPing != null) {
            for (String named : this.namedPing) {
                ch = (ChannelHandler)this.injector.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)named)));
                channelPipeline.addLast("Ping_" + named, ch);
            }
        } else {
            channelPipeline.addLast("Ping", this.defaultHttpPingHandler);
        }
        if (this.namedBusiness != null) {
            for (String named : this.namedBusiness) {
                ch = (ChannelHandler)this.injector.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)named)));
                channelPipeline.addLast("Biz_" + named, ch);
            }
        } else {
            channelPipeline.addLast("Biz", this.defaultHttpRequestHandler);
        }
    }
}

