/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.config;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import org.summerboot.jexpress.boot.config.ConfigChangeListener;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;

@Singleton
public class ConfigChangeListenerImpl
implements ConfigChangeListener {
    @Inject
    protected PostOffice po;
    protected static SMTPClientConfig smtpCfg = SMTPClientConfig.cfg;

    @Override
    public void onBefore(File configFile, JExpressConfig cfg) {
        this.po.sendAlertAsync(smtpCfg.getEmailToAppSupport(), "Config Changed - before", cfg.info(), null, false);
    }

    @Override
    public void onAfter(File configFile, JExpressConfig cfg, Throwable ex) {
        this.po.sendAlertAsync(smtpCfg.getEmailToAppSupport(), "Config Changed - after", cfg.info(), ex, false);
    }
}

