/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.cache;

import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.summerboot.jexpress.integration.cache.SimpleLocalCache;

@Singleton
public class SimpleLocalCacheImpl<K, V>
implements SimpleLocalCache<K, V> {
    protected final Map<Object, CacheEntity<V>> debouncingData = new ConcurrentHashMap<Object, CacheEntity<V>>();

    protected void clean(long now) {
        this.debouncingData.keySet().forEach(key -> {
            CacheEntity<V> ce = this.debouncingData.get(key);
            if (ce == null || ce.getTtlMillis() < now) {
                this.debouncingData.remove(key);
            }
        });
    }

    @Override
    public void put(K key, V value, Long ttlMilliseconds) {
        this.debouncingData.put(key, new CacheEntity<V>(value, ttlMilliseconds));
    }

    @Override
    public V get(K key) {
        if (key == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        this.clean(now);
        CacheEntity<V> e = this.debouncingData.get(key);
        if (e == null) {
            return null;
        }
        if (e.getTtlMillis() < now) {
            return null;
        }
        return e.getValue();
    }

    @Override
    public V delete(K key) {
        V ret = this.get(key);
        this.debouncingData.remove(key);
        return ret;
    }

    public static class CacheEntity<V> {
        private final V value;
        private final long ttlMillis;

        public CacheEntity(V value, Long ttlMilliseconds) {
            this.value = value;
            this.ttlMillis = ttlMilliseconds == null || ttlMilliseconds < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + ttlMilliseconds;
        }

        public V getValue() {
            return this.value;
        }

        public long getTtlMillis() {
            return this.ttlMillis;
        }
    }
}

