/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.jpa;

import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

public abstract class JPAConfig
extends BootConfig {
    protected final Map<String, Object> settings = new HashMap<String, Object>();
    protected final List<Class<?>> entityClasses = new ArrayList();

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public List<Class<?>> getEntityClasses() {
        return this.entityClasses;
    }

    @Override
    public void load(File cfgFile, boolean isReal) throws IOException {
        this.load(cfgFile, new String[0]);
    }

    public void load(File cfgFile, String ... packages) throws IOException {
        String error2;
        if (this.logger == null) {
            this.logger = LogManager.getLogger(this.getClass());
        }
        this.cfgFile = cfgFile.getAbsoluteFile();
        try (FileInputStream is = new FileInputStream(cfgFile);){
            this.props.load(is);
        }
        if (!cfgFile.canRead() || this.props.isEmpty()) {
            throw new IOException("Failed to load DB config file " + cfgFile);
        }
        ConfigUtil helper = new ConfigUtil(this.cfgFile.getAbsolutePath());
        Set<Object> keys = this.props.keySet();
        this.settings.clear();
        keys.forEach(key -> {
            String name = key.toString();
            this.settings.put(name, this.props.getProperty(name));
        });
        if (this.props.get("hibernate.connection.password") != null) {
            this.settings.put("hibernate.connection.password", helper.getAsPassword(this.props, "hibernate.connection.password"));
        }
        if (this.props.get("jakarta.persistence.jdbc.password") != null) {
            this.settings.put("jakarta.persistence.jdbc.password", helper.getAsPassword(this.props, "jakarta.persistence.jdbc.password"));
        }
        if ((error2 = helper.getError()) != null) {
            throw new IllegalArgumentException(error2);
        }
        HashSet<String> packageSet = new HashSet<String>();
        packageSet.addAll(Set.of(packages));
        Set<String> configuredPackageSet = BackOffice.agent.getRootPackageNames();
        if (configuredPackageSet != null && !configuredPackageSet.isEmpty()) {
            packageSet.addAll(configuredPackageSet);
        }
        String csvPackageNames = this.props.getProperty("hibernate.loaded_classes", "");
        this.scanAnnotation_Entity(csvPackageNames, packageSet);
        this.buildEntityManagerFactory();
    }

    protected void scanAnnotation_Entity(String csvPackageNames, Set<String> packageSet) {
        this.logger.debug("_rootPackageNames={}", (Object)csvPackageNames);
        String[] rootPackageNames = FormatterUtil.parseCsv(csvPackageNames);
        List<Object> rootPackageNameList = new ArrayList<String>();
        rootPackageNameList.addAll(Arrays.asList(rootPackageNames));
        rootPackageNameList.addAll(List.copyOf(packageSet));
        rootPackageNameList = rootPackageNameList.stream().distinct().collect(Collectors.toList());
        rootPackageNameList.removeAll(Collections.singleton(""));
        rootPackageNameList.removeAll(Collections.singleton(null));
        this.logger.debug("rootPackageNameList:{}", rootPackageNameList);
        this.entityClasses.clear();
        Set<Class<?>> tempEntityClasses = ReflectionUtil.getAllImplementationsByAnnotation(Entity.class, false, rootPackageNameList);
        this.entityClasses.addAll(tempEntityClasses);
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
    }

    protected abstract void buildEntityManagerFactory();

    public abstract EntityManager em();
}

