/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import jakarta.activation.MimetypesFileTypeMap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tika.Tika;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.integration.cache.SimpleLocalCache;
import org.summerboot.jexpress.integration.cache.SimpleLocalCacheImpl;
import org.summerboot.jexpress.nio.server.ErrorAuditor;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.ResponseEncoder;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ProcessorSettings;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.nio.server.domain.ServiceRequest;
import org.summerboot.jexpress.util.TimeUtil;

public class NioHttpUtil {
    private static final Logger log = LogManager.getLogger((String)NioHttpUtil.class.getName());
    public static final String HTTP_HEADER_AUTH_TOKEN = "Authorization";
    public static final String HTTP_HEADER_AUTH_TYPE = "Bearer";
    public static final AsciiString KEEP_ALIVE = new AsciiString((CharSequence)"keep-alive");
    public static final AsciiString CONNECTION = new AsciiString((CharSequence)"Connection");
    private static final String DEFAULT_CHARSET = "UTF-8";
    public static final SimpleLocalCache<String, File> WebResourceCache = new SimpleLocalCacheImpl<String, File>();
    private static final Pattern ALLOWED_FILE_NAME = Pattern.compile("[A-Za-z0-9][-_A-Za-z0-9\\.]*");
    private static final Pattern INSECURE_URI = Pattern.compile(".*[<>&\"].*");

    public static String encodeMimeBase64(File file) throws IOException {
        byte[] contentBytes = Files.readAllBytes(file.toPath());
        return Base64.getMimeEncoder().encodeToString(contentBytes);
    }

    public static String encodeMimeBase64(byte[] contentBytes) {
        return Base64.getMimeEncoder().encodeToString(contentBytes);
    }

    public static byte[] decodeMimeBase64(String contentBase64) {
        return Base64.getMimeDecoder().decode(contentBase64);
    }

    public static void decodeMimeBase64(String contentBase64, File dest) throws IOException {
        byte[] contentBytes = Base64.getMimeDecoder().decode(contentBase64);
        FileUtils.writeByteArrayToFile((File)dest, (byte[])contentBytes);
    }

    public static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, int errorCode, String msg, Throwable ex) {
        ServiceError e = new ServiceError(errorCode, null, msg, ex);
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)e.toJson(), (Charset)CharsetUtil.UTF_8));
        resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=UTF-8");
        ctx.writeAndFlush((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static void sendRedirect(ChannelHandlerContext ctx, String newUri, HttpResponseStatus status) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        resp.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)newUri);
        ctx.writeAndFlush((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static long sendResponse(ChannelHandlerContext ctx, boolean isKeepAlive, ServiceContext serviceContext, ErrorAuditor errorAuditor, ProcessorSettings processorSettings) {
        if (processorSettings != null) {
            String key = processorSettings.getHttpServiceResponseHeaderName_Reference();
            if (key != null) {
                serviceContext.responseHeader(key, serviceContext.hit());
            }
            if ((key = processorSettings.getHttpServiceResponseHeaderName_ServerTimestamp()) != null) {
                serviceContext.responseHeader(key, OffsetDateTime.now().format(TimeUtil.ISO_ZONED_DATE_TIME3));
            }
        }
        if (serviceContext.file() != null) {
            return NioHttpUtil.sendFile(ctx, isKeepAlive, serviceContext);
        }
        HttpResponseStatus status = serviceContext.status();
        ResponseEncoder responseEncoder = serviceContext.responseEncoder();
        if (StringUtils.isBlank((CharSequence)serviceContext.txt()) && status.code() >= 400) {
            String textResponse;
            String clientAcceptContentType;
            if (serviceContext.error() == null) {
                serviceContext.error(null);
            }
            if ((clientAcceptContentType = serviceContext.clientAcceptContentType()) != null && clientAcceptContentType.contains("xml")) {
                textResponse = serviceContext.error().toXML();
                serviceContext.contentType("application/xml");
            } else {
                textResponse = serviceContext.error().toJson();
                serviceContext.contentType("application/json");
            }
            if (errorAuditor != null) {
                textResponse = errorAuditor.beforeSendingError(textResponse);
            }
            serviceContext.txt(textResponse);
        }
        if (StringUtils.isNotBlank((CharSequence)serviceContext.txt())) {
            return NioHttpUtil.sendText(ctx, isKeepAlive, serviceContext.responseHeaders(), status, serviceContext.txt(), serviceContext.contentType(), serviceContext.charsetName(), true, responseEncoder);
        }
        if (serviceContext.redirect() != null) {
            NioHttpUtil.sendRedirect(ctx, serviceContext.redirect(), status);
            return 0L;
        }
        if (serviceContext.autoConvertBlank200To204() && HttpResponseStatus.OK.equals((Object)status)) {
            status = HttpResponseStatus.NO_CONTENT;
        }
        return NioHttpUtil.sendText(ctx, isKeepAlive, serviceContext.responseHeaders(), status, null, serviceContext.contentType(), serviceContext.charsetName(), true, responseEncoder);
    }

    public static long sendText(ChannelHandlerContext ctx, boolean isKeepAlive, HttpHeaders serviceHeaders, HttpResponseStatus status, String content, String contentType, String charsetName, boolean flush, ResponseEncoder responseEncoder) {
        long contentLength;
        byte[] contentBytes;
        if (content == null) {
            content = "";
        }
        if (responseEncoder != null) {
            content = responseEncoder.encode(content);
        }
        if (charsetName == null) {
            contentBytes = content.getBytes(StandardCharsets.UTF_8);
            charsetName = DEFAULT_CHARSET;
        } else {
            try {
                contentBytes = content.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException ex) {
                log.warn("Unsupported Header (Accept-Charset: " + charsetName + "): " + ex.getMessage());
                contentBytes = content.getBytes(StandardCharsets.UTF_8);
                charsetName = DEFAULT_CHARSET;
            }
        }
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((byte[])contentBytes));
        HttpHeaders h = resp.headers();
        if (serviceHeaders != null) {
            h.set(serviceHeaders);
        }
        if (contentType != null) {
            h.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(contentType + ";charset=" + charsetName));
        }
        if ((contentLength = (long)resp.content().readableBytes()) > Integer.MAX_VALUE) {
            h.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(contentLength));
        } else {
            h.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (int)contentLength);
        }
        if (isKeepAlive) {
            h.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)KEEP_ALIVE);
            if (flush) {
                ctx.writeAndFlush((Object)resp);
            } else {
                ctx.write((Object)resp);
            }
        } else if (flush) {
            ctx.writeAndFlush((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.write((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return contentLength;
    }

    public static long sendFile(ChannelHandlerContext ctx, boolean isKeepAlive, ServiceContext serviceContext) {
        long fileLength = -1L;
        File file = serviceContext.file();
        final String filePath = file.getName();
        try {
            final RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            fileLength = randomAccessFile.length();
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, serviceContext.status());
            HttpHeaders h = response.headers();
            h.set(serviceContext.responseHeaders());
            if (isKeepAlive) {
                h.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)KEEP_ALIVE);
            }
            ctx.write((Object)response);
            ChannelFuture sendFileFuture = ctx.write((Object)new ChunkedFile(randomAccessFile, 0L, fileLength, 8192), (ChannelPromise)ctx.newProgressivePromise());
            sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

                public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                    if (total < 0L) {
                        log.error(filePath + " -> Transfer progress: " + progress);
                    } else {
                        log.debug(() -> filePath + " -> Transfer progress: " + progress + " / " + total);
                    }
                }

                public void operationComplete(ChannelProgressiveFuture future) throws Exception {
                    log.debug(() -> filePath + " -> Transfer complete.");
                    randomAccessFile.close();
                }
            });
            ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!isKeepAlive) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (IOException ex) {
            log.error("download " + filePath, (Throwable)ex);
            NioHttpUtil.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, BootErrorCode.NIO_UNEXPECTED_SERVICE_FAILURE, "faild to download", null);
        }
        return fileLength;
    }

    public static void sendWebResource(ServiceRequest request, ServiceContext response) {
        String httpRequestPath = request.getHttpRequestPath();
        NioHttpUtil.sendWebResource(httpRequestPath, response);
    }

    public static void sendWebResource(String httpRequestPath, ServiceContext context) {
        String accept;
        HttpHeaders headers = context.requestHeaders();
        if (!(headers == null || (accept = headers.get((CharSequence)HttpHeaderNames.ACCEPT)) == null || (accept = accept.toLowerCase()).contains("html") || accept.contains("web") || accept.contains("image") || !accept.contains("json") && !accept.contains("xml"))) {
            Err error2 = new Err(BootErrorCode.NIO_REQUEST_BAD_HEADER, null, "Client expect " + accept + ", but request a web resource", null);
            context.error(error2).status(HttpResponseStatus.NOT_FOUND);
            return;
        }
        File webResourceFile = WebResourceCache.get(httpRequestPath);
        if (webResourceFile == null) {
            Object filePath = NioConfig.cfg.getDocrootDir() + httpRequestPath;
            filePath = ((String)filePath).replace('/', File.separatorChar);
            webResourceFile = new File((String)filePath).getAbsoluteFile();
            WebResourceCache.put(httpRequestPath, webResourceFile, BootConstant.WEB_RESOURCE_TTL_MS);
        }
        context.file(webResourceFile, false).level(Level.TRACE);
    }

    public static String getFileContentType(File file) {
        String mimeType;
        try {
            Tika tika = new Tika();
            mimeType = tika.detect(file);
        }
        catch (IOException ex) {
            MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
            mimeType = mimeTypesMap.getContentType(file.getPath());
            log.warn(() -> "Magic cannot get MIME from " + file.getAbsolutePath());
        }
        return mimeType;
    }

    public static String getHttpPostBodyString(FullHttpRequest fullHttpRequest) {
        ByteBuf buf = fullHttpRequest.content();
        String jsonStr = buf.toString(CharsetUtil.UTF_8);
        log.debug(() -> "\n" + fullHttpRequest.uri() + "\n" + jsonStr);
        return jsonStr;
    }

    public static String decode(String value) {
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            return value;
        }
    }

    public static boolean sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                return false;
            }
        }
        uri = uri.replace('/', File.separatorChar);
        return !uri.contains(File.separator + ".") && !uri.contains("." + File.separator) && uri.charAt(0) != '.' && uri.charAt(uri.length() - 1) != '.' && !INSECURE_URI.matcher(uri).matches();
    }

    public static boolean sanitizePath(String path) {
        return !path.contains(File.separator + ".") && !path.contains("." + File.separator);
    }

    @Deprecated
    public static String sanitizeDocRootUri(String uri, String docroot) {
        try {
            uri = URLDecoder.decode(uri, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error(e);
            }
        }
        uri = uri.replace('/', File.separatorChar);
        if (uri.contains(File.separator + ".") || uri.contains("." + File.separator) || uri.charAt(0) == '.' || uri.charAt(uri.length() - 1) == '.' || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        if (!uri.startsWith(docroot)) {
            return null;
        }
        return System.getProperty("user.dir") + uri;
    }

    @Deprecated
    public static void sendListing(ChannelHandlerContext ctx, File dir) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        StringBuilder sb = new StringBuilder();
        String dirPath = dir.getPath();
        sb.append("<!DOCTYPE html>\r\n");
        sb.append("<html><head><title>");
        sb.append(dirPath);
        sb.append(" dir\uff1a");
        sb.append("</title></head><body>\r\n");
        sb.append("<h3>");
        sb.append(dirPath).append(" dir\uff1a");
        sb.append("</h3>\r\n");
        sb.append("<ul>");
        sb.append("<li>Link\uff1a<a href=\"../\">..</a></li>\r\n");
        for (File f : dir.listFiles()) {
            String name;
            if (f.isHidden() || !f.canRead() || !ALLOWED_FILE_NAME.matcher(name = f.getName()).matches()) continue;
            sb.append("<li>Link\uff1a<a href=\"");
            sb.append(name);
            sb.append("\">");
            sb.append(name);
            sb.append("</a></li>\r\n");
        }
        sb.append("</ul></body></html>\r\n");
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)sb, (Charset)CharsetUtil.UTF_8);
        response.content().writeBytes(buffer);
        buffer.release();
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

