/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.ws.rs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MetaMatrixParam {
    public static final String MATRIX_REGEX_POSTFIX = "\\s*=\\s*(.*?)[;|/]";
    public static final String MATRIX_REGEX_POSTFIX_END = "\\s*=\\s*(.*?)$";
    private final String key;
    private final Pattern matrixParamPattern;
    private final Pattern matrixParamPatternEnd;

    public MetaMatrixParam(String key) {
        this.key = key;
        this.matrixParamPattern = Pattern.compile(key + MATRIX_REGEX_POSTFIX);
        this.matrixParamPatternEnd = Pattern.compile(key + MATRIX_REGEX_POSTFIX_END);
    }

    public String value(String path) {
        String v = null;
        Matcher fm = this.matrixParamPattern.matcher(path);
        if (fm.find()) {
            v = fm.group(1);
        } else {
            fm = this.matrixParamPatternEnd.matcher(path);
            if (fm.find()) {
                v = fm.group(1);
            }
        }
        return v == null ? null : v.trim();
    }

    public String getKey() {
        return this.key;
    }
}

