/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BeanUtil {
    private static boolean isToJsonIgnoreNull = true;
    private static boolean isToJsonPretty = false;
    private static boolean isFromJsonFailOnUnknownProperties = true;
    public static ObjectMapper JacksonMapper = new ObjectMapper();
    public static ObjectMapper JacksonMapperIgnoreNull = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    public static XmlMapper XMLMapper = new XmlMapper();
    public static final ValidatorFactory ValidatorFactory;

    public static void update(ObjectMapper objectMapper) {
        objectMapper.registerModules(new Module[]{new JavaTimeModule()});
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, isFromJsonFailOnUnknownProperties);
    }

    public static void init(boolean fromJsonFailOnUnknownProperties, boolean fromJsonCaseInsensitive, boolean toJsonPretty, boolean toJsonIgnoreNull) {
        isFromJsonFailOnUnknownProperties = fromJsonFailOnUnknownProperties;
        isToJsonPretty = toJsonPretty;
        isToJsonIgnoreNull = toJsonIgnoreNull;
        if (fromJsonCaseInsensitive) {
            JacksonMapper = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
            XMLMapper = (XmlMapper)((XmlMapper.Builder)XmlMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
        }
        BeanUtil.update(JacksonMapper);
        BeanUtil.update(JacksonMapperIgnoreNull);
        BeanUtil.update((ObjectMapper)XMLMapper);
    }

    public static <T> String toJson(T obj) throws JsonProcessingException {
        return BeanUtil.toJson(obj, isToJsonPretty, isToJsonIgnoreNull);
    }

    public static <T> String toJson(T obj, boolean pretty, boolean ignoreNull) throws JsonProcessingException {
        if (obj == null) {
            return "";
        }
        if (pretty) {
            if (ignoreNull) {
                return JacksonMapperIgnoreNull.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return JacksonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        if (ignoreNull) {
            return JacksonMapperIgnoreNull.writeValueAsString(obj);
        }
        return JacksonMapper.writeValueAsString(obj);
    }

    public static <T> T fromJson(Class<T> c, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JacksonMapper.readValue(json, c);
    }

    public static <T> T fromJson(JavaType javaType, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JacksonMapper.readValue(json, javaType);
    }

    public static <T> T fromJson(TypeReference<T> javaType, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JacksonMapper.readValue(json, javaType);
    }

    public static <R> R fromJson(Class<R> collectionClass, Class<?> genericClass, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        if (genericClass == null) {
            return BeanUtil.fromJson(collectionClass, json);
        }
        JavaType javaType = JacksonMapper.getTypeFactory().constructParametricType(collectionClass, new Class[]{genericClass});
        return (R)JacksonMapper.readValue(json, javaType);
    }

    public static <T> T fromXML(Class<T> targetClass, String xml) throws JsonProcessingException {
        return (T)XMLMapper.readValue(xml, targetClass);
    }

    public static String toXML(Object obj) throws JsonProcessingException {
        return XMLMapper.writeValueAsString(obj);
    }

    public static String getBeanValidationResult(Object bean) {
        if (bean == null) {
            return "missing data";
        }
        Set violations = ValidatorFactory.getValidator().validate(bean, new Class[0]);
        if (violations.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(bean.getClass().getSimpleName()).append(" Validation Failed: ");
        for (ConstraintViolation constViolation : violations) {
            sb.append(constViolation.getPropertyPath()).append("=").append(constViolation.getInvalidValue()).append(" - ").append(constViolation.getMessage()).append("; ");
        }
        return sb.toString();
    }

    static {
        BeanUtil.init(true, false, false, true);
        ValidatorFactory = Validation.buildDefaultValidatorFactory();
    }
}

