/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util.templateengine;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FreeMarker {
    private static Map<String, FreeMarker> POOL = new ConcurrentHashMap<String, FreeMarker>();
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_32);

    public static FreeMarker get(File directoryForTemplateLoading) throws IOException {
        String key = directoryForTemplateLoading.getAbsolutePath();
        FreeMarker fm = POOL.get(key);
        if (fm == null) {
            fm = new FreeMarker(directoryForTemplateLoading);
            POOL.put(key, fm);
        }
        return fm;
    }

    private FreeMarker(File directoryForTemplateLoading) throws IOException {
        this.cfg.setDirectoryForTemplateLoading(directoryForTemplateLoading);
        this.cfg.setDefaultEncoding(StandardCharsets.UTF_8.name());
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(false);
        this.cfg.setWrapUncheckedExceptions(true);
        this.cfg.setFallbackOnNullLoopVariable(false);
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public Template getTemplate(String templateName) throws IOException {
        return this.cfg.getTemplate(templateName, null, "UTF-8");
    }

    public String generate(String templateName, Converter converter, Object dto) throws IOException {
        Template template = this.getTemplate(templateName);
        return FreeMarker.generate(template, converter, dto);
    }

    public static String generate(Template template, Converter converter, Object dto) throws IOException {
        Object dataModel = converter.toDataModel(dto);
        return FreeMarker.generate(template, dataModel);
    }

    public static String generate(Template template, Object dataModel) throws IOException {
        String ret;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);){
            template.process(dataModel, (Writer)out);
            byte[] htmlData = baos.toByteArray();
            ret = new String(htmlData, StandardCharsets.UTF_8);
        }
        catch (TemplateException ex) {
            throw new IOException(ex);
        }
        return ret;
    }

    public static interface Converter<R, T> {
        public R toDataModel(T var1) throws IOException;
    }
}

