/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.smtp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;

public class SMTPClientConfig
extends BootConfig {
    public static final SMTPClientConfig cfg = new SMTPClientConfig();
    @JsonIgnore
    protected volatile Session mailSession;
    @ConfigHeader(title="1. SMTP Settings")
    @JsonIgnore
    @Config(key="mail.smtp.host", required=false, desc="The SMTP server to connect to. i.e. Gmail server: smtp.gmail.com")
    protected volatile String smtpHost;
    @JsonIgnore
    @Config(key="mail.smtp.port", defaultValue="25", desc="25: The original standard SMTP port\n587: The standard secure SMTP port")
    protected volatile int smtpPort = 25;
    @JsonIgnore
    @Config(key="mail.smtp.auth", desc="Whether to attempt to authenticate the user using the AUTH command")
    protected volatile Boolean smtpAuth;
    @JsonIgnore
    @Config(key="mail.smtp.starttls.enable", desc="To inform the email server that the email client wants to upgrade from an insecure connection to a secure one using TLS or SSL")
    protected volatile Boolean smtpStarttls;
    public static final String KEY_USER_ACCOUNT = "mail.smtp.user";
    @JsonIgnore
    @Config(key="mail.smtp.user", required=false, desc="Sender email account, also as default username for SMTP when display name is not provided")
    protected volatile String smtpUser;
    public static final String KEY_USER_DISPLAYNAME = "mail.smtp.user.displayname";
    @JsonIgnore
    @Config(key="mail.smtp.user.displayname", desc="Sender display name")
    protected volatile String smtpUserDisplayName;
    public static final String KEY_USER_PWD = "mail.smtp.user.passwrod";
    @JsonIgnore
    @Config(key="mail.smtp.user.passwrod", validate=Config.Validate.Encrypted)
    protected volatile String smtpPassword;
    @ConfigHeader(title="2. Alert Recipients", format="CSV format", example="johndoe@test.com, janedoe@test.com")
    public static final String KEY_MAILTO_APPSUPPORT = "email.to.AppSupport";
    @Config(key="email.to.AppSupport", validate=Config.Validate.EmailRecipients, desc="The default alert email recipients")
    protected volatile Set<String> emailToAppSupport;
    public static final String KEY_MAILTO_DEV = "email.to.Development";
    @Config(key="email.to.Development", validate=Config.Validate.EmailRecipients, desc="use AppSupport if not provided")
    protected volatile Set<String> emailToDevelopment;
    public static final String KEY_MAILTO_REPORT = "email.to.ReportViewer";
    @Config(key="email.to.ReportViewer", validate=Config.Validate.EmailRecipients, desc="use AppSupport if not provided")
    protected volatile Set<String> emailToReportViewer;
    public static final String KEY_DEBOUCING_INTERVAL = "debouncing.emailalert_minute";
    @Config(key="debouncing.emailalert_minute", desc="Alert message with the same title will not be sent out within this minutes")
    protected volatile int emailAlertDebouncingIntervalMinutes = 30;
    protected Properties mailSessionProp;

    public static void main(String[] args) {
        String t = SMTPClientConfig.generateTemplate(SMTPClientConfig.class);
        System.out.println(t);
    }

    protected SMTPClientConfig() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) {
        String error2;
        if (this.emailToAppSupport == null) {
            this.emailToAppSupport = new HashSet<String>();
        }
        if (this.emailToDevelopment == null) {
            this.emailToDevelopment = new HashSet<String>(this.emailToAppSupport);
        }
        if (this.emailToDevelopment.isEmpty()) {
            this.emailToDevelopment.addAll(this.emailToAppSupport);
        }
        if (this.emailToReportViewer == null) {
            this.emailToReportViewer = new HashSet<String>(this.emailToAppSupport);
        }
        if (this.emailToReportViewer.isEmpty()) {
            this.emailToReportViewer.addAll(this.emailToAppSupport);
        }
        if ((error2 = helper.getError()) != null) {
            throw new IllegalArgumentException(error2);
        }
        props.remove(KEY_USER_PWD);
        props.remove(KEY_MAILTO_APPSUPPORT);
        props.remove(KEY_MAILTO_DEV);
        props.remove(KEY_MAILTO_REPORT);
        props.remove(KEY_DEBOUCING_INTERVAL);
        Object displayName = props.get(KEY_USER_DISPLAYNAME);
        if (displayName == null) {
            displayName = props.get("mail.smtp.userName");
            if (displayName == null) {
                displayName = BackOffice.agent.getVersionShort();
            }
            if (displayName != null) {
                props.put(KEY_USER_DISPLAYNAME, displayName);
            }
        }
        this.mailSession = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SMTPClientConfig.this.smtpUser, SMTPClientConfig.this.smtpPassword);
            }
        });
        this.mailSessionProp = this.mailSession.getProperties();
    }

    public Session getMailSession() {
        return this.mailSession;
    }

    public Set<String> getEmailToAppSupport() {
        return this.emailToAppSupport;
    }

    public Set<String> getEmailToDevelopment() {
        return this.emailToDevelopment;
    }

    public Set<String> getEmailToReportViewer() {
        return this.emailToReportViewer;
    }

    public int getEmailAlertDebouncingIntervalMinutes() {
        return this.emailAlertDebouncingIntervalMinutes;
    }
}

