/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.quartz;

import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.listeners.JobListenerSupport;
import org.summerboot.jexpress.integration.quartz.QuartzUtil;

public class BootJobListener
extends JobListenerSupport {
    protected static final Logger log = LogManager.getLogger(BootJobListener.class);
    public static final String FIXED_DELAY_VALUE = "jExpress_FIXED_DELAY_VALUE";
    public static final String FIXED_DELAY_DESC = "jExpress_FIXED_DELAY_DESC";
    protected static final String JOB_LISTENER_NAME = BootJobListener.class.getSimpleName();

    public String getName() {
        return JOB_LISTENER_NAME;
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exception) {
        this.scheduleFixedDelayJob(context, exception);
        this.scheduleDSTDailyJob(context, exception);
        this.logNextFireTime(context, exception);
    }

    protected Date logNextFireTime(JobExecutionContext context, JobExecutionException exception) {
        Date nextFireTime = context.getNextFireTime();
        if (nextFireTime != null && log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Scheduled jobs next fire time by triggers: ");
            try {
                Scheduler scheduler = context.getScheduler();
                QuartzUtil.getNextFireTimes(scheduler, sb);
            }
            catch (Throwable ex) {
                sb.append(ex);
            }
            log.info(() -> sb.toString());
        }
        return nextFireTime;
    }

    protected void scheduleFixedDelayJob(JobExecutionContext context, JobExecutionException exception) {
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap jobData = jobDetail.getJobDataMap();
        if (!jobData.containsKey((Object)FIXED_DELAY_VALUE)) {
            log.info("Scheduled jobs next fire time by triggers: none");
            return;
        }
        TriggerKey currentTriggerKey = context.getTrigger().getKey();
        try {
            SimpleTrigger st;
            Scheduler scheduler = context.getScheduler();
            if (scheduler.isShutdown()) {
                return;
            }
            Trigger currentTrigger = context.getTrigger();
            if (currentTrigger instanceof SimpleTrigger && ((st = (SimpleTrigger)currentTrigger).getRepeatInterval() != 0L || st.getRepeatCount() != 0 || st.getTimesTriggered() != 1 || st.getNextFireTime() != null)) {
                return;
            }
            long fixedDelayMs = (Long)jobData.getWrappedMap().get(FIXED_DELAY_VALUE);
            String desc = (String)jobData.getWrappedMap().get(FIXED_DELAY_DESC);
            Date nextTime = new Date(System.currentTimeMillis() + fixedDelayMs);
            JobKey jobKey = jobDetail.getKey();
            Trigger nextTrigger = TriggerBuilder.newTrigger().forJob(jobKey).withDescription(desc).withIdentity(currentTriggerKey).startAt(nextTime).build();
            scheduler.rescheduleJob(currentTriggerKey, nextTrigger);
            log.info(desc + " scheduled@" + nextTime);
        }
        catch (SchedulerException ex) {
            log.error("failed to reschedule the job with triger: {}", (Object)currentTriggerKey, (Object)ex);
        }
    }

    protected void scheduleDSTDailyJob(JobExecutionContext context, JobExecutionException exception) {
    }
}

