/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Injector;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.annotation.Service;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioCounter;

public abstract class NioChannelInitializer
extends ChannelInitializer<SocketChannel> {
    protected static final Logger log = LogManager.getLogger((String)NioChannelInitializer.class.getName());
    protected Injector injector;
    protected SslContext nettySslContext;
    protected NioConfig nioCfg;
    protected Map<Service.ChannelHandlerType, Set<String>> channelHandlerNames;
    protected Set<String> namedReadIdle;
    protected Set<String> namedWriteIdle;
    protected Set<String> namedFileUpload;
    protected Set<String> namedWebsocket;
    protected Set<String> namedPing;
    protected Set<String> namedBusiness;

    public NioChannelInitializer init(Injector injector, Map<Service.ChannelHandlerType, Set<String>> channelHandlerNames) {
        this.injector = injector;
        this.channelHandlerNames = channelHandlerNames;
        this.namedReadIdle = channelHandlerNames.get((Object)Service.ChannelHandlerType.ReadIdle);
        if (this.namedReadIdle != null && this.namedReadIdle.isEmpty()) {
            this.namedReadIdle = null;
        }
        this.namedWriteIdle = channelHandlerNames.get((Object)Service.ChannelHandlerType.WriteIdle);
        if (this.namedWriteIdle != null && this.namedWriteIdle.isEmpty()) {
            this.namedWriteIdle = null;
        }
        this.namedFileUpload = channelHandlerNames.get((Object)Service.ChannelHandlerType.FileUpload);
        if (this.namedFileUpload != null && this.namedFileUpload.isEmpty()) {
            this.namedFileUpload = null;
        }
        this.namedWebsocket = channelHandlerNames.get((Object)Service.ChannelHandlerType.Websocket);
        if (this.namedWebsocket != null && this.namedWebsocket.isEmpty()) {
            this.namedWebsocket = null;
        }
        this.namedPing = channelHandlerNames.get((Object)Service.ChannelHandlerType.Ping);
        if (this.namedPing != null && this.namedPing.isEmpty()) {
            this.namedPing = null;
        }
        this.namedBusiness = channelHandlerNames.get((Object)Service.ChannelHandlerType.Business);
        if (this.namedBusiness != null && this.namedBusiness.isEmpty()) {
            this.namedBusiness = null;
        }
        return this;
    }

    public void initSSL(SslContext nettySslContext, NioConfig nioCfg) {
        this.nettySslContext = nettySslContext;
        this.nioCfg = nioCfg;
    }

    public void initChannel(SocketChannel socketChannel) {
        long tc = NioCounter.COUNTER_TOTAL_CHANNEL.incrementAndGet();
        log.debug(() -> tc + "[" + ((Object)((Object)this)).hashCode() + "]" + socketChannel);
        ChannelPipeline channelPipeline = socketChannel.pipeline();
        if (this.nettySslContext != null) {
            this.initSSL_OpenSSL(socketChannel, channelPipeline);
        }
        this.initChannelPipeline(channelPipeline, this.nioCfg);
    }

    protected void initSSL_OpenSSL(SocketChannel socketChannel, ChannelPipeline pipeline) {
        SslHandler sslHandler = this.nettySslContext.newHandler(socketChannel.alloc());
        if (this.nioCfg.isVerifyCertificateHost()) {
            SSLEngine sslEngine = sslHandler.engine();
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        }
        pipeline.addLast("ssl", (ChannelHandler)sslHandler);
    }

    protected abstract void initChannelPipeline(ChannelPipeline var1, NioConfig var2);
}

