/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.ws.rs;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.boot.annotation.Deamon;
import org.summerboot.jexpress.boot.annotation.Log;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.LoginVo;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.nio.server.domain.ServiceRequest;
import org.summerboot.jexpress.nio.server.ws.rs.PingController;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.security.auth.Authenticator;
import org.summerboot.jexpress.security.auth.Caller;

@Singleton
@OpenAPIDefinition(info=@Info(title="Default Admin API", version="jExpress 2.4.11", description="To change to yours, just add @OpenAPIDefinition.info", contact=@Contact(name="summerboot.org", email="")), servers={@Server(url="https://localhost:8211", description="Local Development server")})
@SecurityScheme(name="BearerAuth", scheme="bearer", type=SecuritySchemeType.HTTP, bearerFormat="Authorization: Bearer <token>")
public abstract class BootController
extends PingController {
    public static final String TAG_APP_ADMIN = "App Admin";
    public static final String TAG_USER_AUTH = "App User Authentication";
    public static final String DESC_400 = "All other 4xx code. The client cannot continue and should not re-try again with the request without modification.";
    public static final String DESC_401 = "Unauthorized. The client should sign-on again, but not retransmit the same request again";
    public static final String DESC_403 = "Client has  no permission. Client should not retransmit the same request again.";
    public static final String DESC_404 = "Not Found. The client should not retransmit the same request again.";
    public static final String DESC_429 = "Too Many Requests";
    public static final String DESC_500 = "All other 5xx code. Server errors due to unexpected failures. The client can continue and try again with the request without modification.";
    public static final String DESC_501 = "Not Implemented. The client can continue and try again with the request without modification.";
    public static final String DESC_503 = "Service Unavailable. The client can continue and try again with the request without modification.";
    public static final String DESC_504 = "Gateway Timeout. The client can continue and try again with the request without modification.";
    public static final String DESC_507 = "Insufficient Storage. The client should contact the system administrator. Do not try the request again.";
    @Inject
    protected AuthTokenCache authTokenCache;
    @Inject
    protected Authenticator auth;
    protected String version;

    @Operation(tags={"App Admin"}, summary="Check application version", description="get running application version information", responses={@ApiResponse(responseCode="200", description="running application version"), @ApiResponse(responseCode="400", description="All other 4xx code. The client cannot continue and should not re-try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The client should sign-on again, but not retransmit the same request again", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="403", description="Client has  no permission. Client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="404", description="Not Found. The client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="429", description="Too Many Requests", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="500", description="All other 5xx code. Server errors due to unexpected failures. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="501", description="Not Implemented. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="503", description="Service Unavailable. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="504", description="Gateway Timeout. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="507", description="Insufficient Storage. The client should contact the system administrator. Do not try the request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @GET
    @Path(value="/version")
    @Produces(value={"text/html"})
    @RolesAllowed(value={"AppAdmin"})
    @Deamon
    public void version(@Parameter(hidden=true) ServiceContext context) {
        context.txt(this.getVersion()).status(HttpResponseStatus.OK);
    }

    protected String getVersion() {
        if (this.version == null) {
            this.version = BackOffice.agent.getVersion();
        }
        return this.version;
    }

    @Operation(tags={"App Admin"}, summary="Run application self inspection", description="get running application health information", responses={@ApiResponse(responseCode="200", description="inspection success with current version"), @ApiResponse(responseCode="400", description="All other 4xx code. The client cannot continue and should not re-try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The client should sign-on again, but not retransmit the same request again", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="403", description="Client has  no permission. Client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="404", description="Not Found. The client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="429", description="Too Many Requests", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="500", description="All other 5xx code. Server errors due to unexpected failures. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="501", description="Not Implemented. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="503", description="Service Unavailable. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="504", description="Gateway Timeout. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="507", description="Insufficient Storage. The client should contact the system administrator. Do not try the request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @GET
    @Path(value="/inspection")
    @Produces(value={"text/html"})
    @RolesAllowed(value={"AppAdmin"})
    @Deamon
    public void inspect(@Parameter(hidden=true) ServiceContext context) {
        HealthMonitor.inspect();
    }

    @Operation(tags={"App Admin"}, summary="Graceful shutdown by changing service status", description="pause service if pause param is true, otherwise resume service", responses={@ApiResponse(responseCode="204", description="success"), @ApiResponse(responseCode="400", description="All other 4xx code. The client cannot continue and should not re-try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The client should sign-on again, but not retransmit the same request again", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="403", description="Client has  no permission. Client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="404", description="Not Found. The client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="429", description="Too Many Requests", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="500", description="All other 5xx code. Server errors due to unexpected failures. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="501", description="Not Implemented. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="503", description="Service Unavailable. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="504", description="Gateway Timeout. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="507", description="Insufficient Storage. The client should contact the system administrator. Do not try the request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @PUT
    @Path(value="/status")
    @RolesAllowed(value={"AppAdmin"})
    @Deamon
    public void pause(@QueryParam(value="pause") boolean pause, @Parameter(hidden=true) ServiceContext context) throws IOException {
        HealthMonitor.pauseService(pause, BootConstant.PAUSE_LOCK_CODE_VIAWEB, "request by " + context.caller());
        context.status(HttpResponseStatus.NO_CONTENT);
    }

    @Operation(tags={"App User Authentication"}, summary="User login", description="Accept Form based parameters for login", responses={@ApiResponse(responseCode="201", description="success and return JWT token in header X-AuthToken", headers={@Header(name="X-AuthToken", schema=@Schema(type="string"), description="Generated JWT")}, content={@Content(schema=@Schema(implementation=Caller.class))}), @ApiResponse(responseCode="400", description="All other 4xx code. The client cannot continue and should not re-try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The client should sign-on again, but not retransmit the same request again", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="403", description="Client has  no permission. Client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="404", description="Not Found. The client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="429", description="Too Many Requests", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="500", description="All other 5xx code. Server errors due to unexpected failures. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="501", description="Not Implemented. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="503", description="Service Unavailable. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="504", description="Gateway Timeout. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="507", description="Insufficient Storage. The client should contact the system administrator. Do not try the request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))})})
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/j_security_check")
    @Deamon
    @Log(requestBody=false, responseHeader=false)
    public Caller longin_jSecurityCheck(@Parameter(required=true) @Nonnull @FormParam(value="j_username") String userId, @FormParam(value="j_password") String password, @Parameter(hidden=true) ServiceContext context) throws IOException, NamingException {
        return BootController.login(this.auth, userId, password, context);
    }

    @Operation(tags={"App User Authentication"}, summary="User login", description="Accept JSON based parameters for login", responses={@ApiResponse(responseCode="201", description="success and return JWT token in header X-AuthToken", headers={@Header(name="X-AuthToken", schema=@Schema(type="string"), description="Generated JWT")}, content={@Content(schema=@Schema(implementation=Caller.class))}), @ApiResponse(responseCode="400", description="All other 4xx code. The client cannot continue and should not re-try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The client should sign-on again, but not retransmit the same request again", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="403", description="Client has  no permission. Client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="404", description="Not Found. The client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="429", description="Too Many Requests", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="500", description="All other 5xx code. Server errors due to unexpected failures. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="501", description="Not Implemented. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="503", description="Service Unavailable. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="504", description="Gateway Timeout. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="507", description="Insufficient Storage. The client should contact the system administrator. Do not try the request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/login")
    @Deamon
    @Log(requestBody=false, responseHeader=false)
    public Caller longin_JSON(@Nonnull LoginVo loginVo, @Parameter(hidden=true) ServiceContext context) throws IOException, NamingException {
        return BootController.login(this.auth, loginVo.getUsername(), loginVo.getPassword(), context);
    }

    public static Caller login(Authenticator auth, String userId, String password, ServiceContext context) throws NamingException {
        if (auth == null) {
            context.error(new Err<String>(BootErrorCode.ACCESS_BASE, null, null, null, "Authenticator not provided")).status(HttpResponseStatus.NOT_IMPLEMENTED);
            return null;
        }
        String jwt = auth.signJWT(userId, password, null, AuthConfig.cfg.getJwtTTLMinutes(), context);
        if (jwt == null) {
            context.status(HttpResponseStatus.UNAUTHORIZED);
        } else {
            context.responseHeader("X-AuthToken", jwt).status(HttpResponseStatus.CREATED);
        }
        return context.caller();
    }

    @Operation(tags={"App User Authentication"}, summary="User logout", description="User logout", responses={@ApiResponse(responseCode="204", description="success"), @ApiResponse(responseCode="400", description="All other 4xx code. The client cannot continue and should not re-try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The client should sign-on again, but not retransmit the same request again", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="403", description="Client has  no permission. Client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="404", description="Not Found. The client should not retransmit the same request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="429", description="Too Many Requests", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="500", description="All other 5xx code. Server errors due to unexpected failures. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="501", description="Not Implemented. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="503", description="Service Unavailable. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="504", description="Gateway Timeout. The client can continue and try again with the request without modification.", content={@Content(schema=@Schema(implementation=ServiceError.class))}), @ApiResponse(responseCode="507", description="Insufficient Storage. The client should contact the system administrator. Do not try the request again.", content={@Content(schema=@Schema(implementation=ServiceError.class))})}, security={@SecurityRequirement(name="BearerAuth")})
    @DELETE
    @Path(value="/login")
    @Deamon
    public void logout(@Parameter(hidden=true) ServiceRequest request, @Parameter(hidden=true) ServiceContext context) {
        if (this.auth == null) {
            context.error(new Err<String>(BootErrorCode.ACCESS_BASE, null, null, null, "Authenticator not provided")).status(HttpResponseStatus.NOT_IMPLEMENTED);
            return;
        }
        this.auth.logoutToken(request.getHttpHeaders(), this.authTokenCache, context);
        context.status(HttpResponseStatus.NO_CONTENT);
    }

    @Operation(hidden=true)
    @POST
    @Path(value="/loadtest")
    @RolesAllowed(value={"AppAdmin"})
    @Deamon
    public void loadTestBenchmarkPost1(ServiceRequest request, ServiceContext context, @QueryParam(value="delayMilsec") long wait) {
        if (wait > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(wait);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        context.status(HttpResponseStatus.OK).txt(request.getHttpRequestPath() + "?delayMilsec=" + wait + request.getHttpPostRequestBody());
    }

    @Operation(hidden=true)
    @POST
    @Path(value="/loadtest/{delayMilsec}")
    @Deamon
    public void loadTestBenchmarkPost2(ServiceRequest request, ServiceContext context, @PathParam(value="delayMilsec") long wait) {
        if (wait > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(wait);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        context.status(HttpResponseStatus.OK).txt(request.getHttpRequestPath() + request.getHttpPostRequestBody());
    }

    @Operation(hidden=true)
    @GET
    @Path(value="/loadtest")
    @RolesAllowed(value={"AppAdmin"})
    @Deamon
    public void loadTestBenchmarkGet1(ServiceRequest request, ServiceContext context, @QueryParam(value="delayMilsec") long wait) {
        if (wait > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(wait);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        context.status(HttpResponseStatus.OK).txt(request.getHttpRequestPath() + "?delayMilsec=" + wait);
    }

    @Operation(hidden=true)
    @GET
    @Path(value="/loadtest/{delayMilsec}")
    @Deamon
    public void loadTestBenchmarkGet2(ServiceRequest request, ServiceContext context, @PathParam(value="delayMilsec") long wait) {
        if (wait > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(wait);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        context.status(HttpResponseStatus.OK).txt(request.getHttpRequestPath());
    }

    public static interface Config {
        public static final String ROLE_ADMIN = "AppAdmin";
        public static final String CURRENT_VERSION = "";
        public static final String LOAD_BALANCER_HEALTH_CHECK = "/ping";
        public static final String API_NF_LOADTEST = "/loadtest";
        public static final String API_NF_JSECURITYCHECK = "/j_security_check";
        public static final String API_NF_LOGIN = "/login";
        public static final String API_ADMIN_VERSION = "/version";
        public static final String API_ADMIN_STATUS = "/status";
        public static final String API_ADMIN_INSPECTION = "/inspection";
        public static final String X_AUTH_TOKEN = "X-AuthToken";
    }
}

