/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.summerboot.jexpress.nio.grpc.GRPCClientConfig;

public abstract class GRPCClient<T extends GRPCClient<T>> {
    protected NettyChannelBuilder channelBuilder;
    protected ManagedChannel channel;
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.rwLock.readLock();
    protected Thread shutdownHook;

    public T withConfig(GRPCClientConfig cfg) {
        this.channelBuilder = cfg.getChannelBuilder();
        cfg.addConfigUpdateListener(this);
        return (T)this;
    }

    public T withNettyChannelBuilder(NettyChannelBuilder channelBuilder) {
        this.channelBuilder = channelBuilder;
        return (T)this;
    }

    protected void updateChannelBuilder(NettyChannelBuilder channelBuilder) {
        this.rwLock.writeLock().lock();
        this.channelBuilder = channelBuilder;
        this.rwLock.writeLock().unlock();
        this.onChannelBuilderUpdated();
    }

    protected void onChannelBuilderUpdated() {
        this.connect();
    }

    public T connect() {
        this.rwLock.writeLock().lock();
        try {
            this.disconnect(false);
            this.channel = this.channelBuilder.build();
            String info2 = this.channel.authority();
            this.shutdownHook = new Thread(() -> {
                try {
                    this.channel.shutdownNow();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, "GRPCClient.shutdown and disconnect from " + info2);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.onConnected(this.channel);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        return (T)this;
    }

    protected abstract void onConnected(ManagedChannel var1);

    public void disconnect() {
        this.disconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(boolean withLock) {
        block14: {
            if (withLock) {
                this.rwLock.writeLock().lock();
            }
            try {
                if (this.channel != null) {
                    try {
                        this.channel.shutdownNow();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.channel = null;
                    }
                }
                if (this.shutdownHook == null) break block14;
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                    this.shutdownHook = null;
                }
                catch (Throwable throwable) {
                    this.shutdownHook = null;
                }
                catch (Throwable throwable) {
                    this.shutdownHook = null;
                    throw throwable;
                }
            }
            finally {
                if (withLock) {
                    this.rwLock.writeLock().unlock();
                }
            }
        }
    }

    protected void lock() {
        this.readLock.lock();
    }

    protected boolean tryLock() {
        return this.readLock.tryLock();
    }

    protected boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.readLock.tryLock(time, unit);
    }

    protected void unlock() {
        this.readLock.unlock();
    }

    protected Lock getLock() {
        return this.readLock;
    }
}

