/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import java.lang.reflect.Array;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class BeanUtil {
    protected static boolean isToJsonIgnoreNull = true;
    protected static boolean isToJsonPretty = false;
    public static ObjectMapper JacksonMapper = new ObjectMapper();
    public static ObjectMapper JacksonMapperIgnoreNull = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    public static XmlMapper XMLMapper = new XmlMapper();
    public static final ValidatorFactory ValidatorFactory;

    public static void update(ObjectMapper objectMapper, TimeZone timeZone, boolean isFromJsonFailOnUnknownProperties) {
        objectMapper.registerModules(new Module[]{new JavaTimeModule()});
        objectMapper.setTimeZone(timeZone);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, isFromJsonFailOnUnknownProperties);
    }

    public static void init(TimeZone timeZone, boolean fromJsonFailOnUnknownProperties, boolean fromJsonCaseInsensitive, boolean toJsonPretty, boolean toJsonIgnoreNull) {
        isToJsonPretty = toJsonPretty;
        isToJsonIgnoreNull = toJsonIgnoreNull;
        if (fromJsonCaseInsensitive) {
            JacksonMapper = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
            XMLMapper = (XmlMapper)((XmlMapper.Builder)XmlMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
        }
        BeanUtil.update(JacksonMapper, timeZone, fromJsonFailOnUnknownProperties);
        BeanUtil.update(JacksonMapperIgnoreNull, timeZone, fromJsonFailOnUnknownProperties);
        BeanUtil.update((ObjectMapper)XMLMapper, timeZone, fromJsonFailOnUnknownProperties);
    }

    public static <T> String toJson(T obj) throws JsonProcessingException {
        return BeanUtil.toJson(obj, isToJsonPretty, isToJsonIgnoreNull);
    }

    public static <T> String toJson(T obj, boolean pretty, boolean ignoreNull) throws JsonProcessingException {
        if (obj == null) {
            return "";
        }
        if (pretty) {
            if (ignoreNull) {
                return JacksonMapperIgnoreNull.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return JacksonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        if (ignoreNull) {
            return JacksonMapperIgnoreNull.writeValueAsString(obj);
        }
        return JacksonMapper.writeValueAsString(obj);
    }

    public static <T> T fromJson(Class<T> c, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JacksonMapper.readValue(json, c);
    }

    public static <T> T fromJson(JavaType javaType, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JacksonMapper.readValue(json, javaType);
    }

    public static <T> T fromJson(TypeReference<T> javaType, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JacksonMapper.readValue(json, javaType);
    }

    public static <R> R fromJson(Class<R> collectionClass, Class<?> genericClass, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        if (genericClass == null) {
            return BeanUtil.fromJson(collectionClass, json);
        }
        JavaType javaType = JacksonMapper.getTypeFactory().constructParametricType(collectionClass, new Class[]{genericClass});
        return (R)JacksonMapper.readValue(json, javaType);
    }

    public static <T> T fromXML(Class<T> targetClass, String xml) throws JsonProcessingException {
        return (T)XMLMapper.readValue(xml, targetClass);
    }

    public static String toXML(Object obj) throws JsonProcessingException {
        return XMLMapper.writeValueAsString(obj);
    }

    public static String getBeanValidationResult(Object bean) {
        if (bean == null) {
            return "missing data";
        }
        Set violations = ValidatorFactory.getValidator().validate(bean, new Class[0]);
        if (violations.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(bean.getClass().getSimpleName()).append(" Validation Failed: ");
        for (ConstraintViolation constViolation : violations) {
            sb.append(constViolation.getPropertyPath()).append("=").append(constViolation.getInvalidValue()).append(" - ").append(constViolation.getMessage()).append("; ");
        }
        return sb.toString();
    }

    public static <T> T arrayMergeAndRemoveDuplicated(T array1, T array2) {
        Class<?> arrayType2;
        if (array1 == null) {
            return BeanUtil.arrayRemoveDuplicated(array2);
        }
        if (array2 == null) {
            return BeanUtil.arrayRemoveDuplicated(array1);
        }
        if (!array1.getClass().isArray() || !array2.getClass().isArray()) {
            throw new IllegalArgumentException("Both parameters must be array");
        }
        Class<?> arrayType1 = array1.getClass().getComponentType();
        if (!arrayType1.equals(arrayType2 = array2.getClass().getComponentType())) {
            throw new IllegalArgumentException("Two arrays have different types: " + arrayType1 + " and " + arrayType2);
        }
        int len1 = Array.getLength(array1);
        if (len1 == 0) {
            return BeanUtil.arrayRemoveDuplicated(array2);
        }
        int len2 = Array.getLength(array2);
        if (len2 == 0) {
            return BeanUtil.arrayRemoveDuplicated(array1);
        }
        Object result = Array.newInstance(arrayType1, len1 + len2);
        System.arraycopy(array1, 0, result, 0, len1);
        System.arraycopy(array2, 0, result, len1, len2);
        return (T)BeanUtil.arrayRemoveDuplicated(result);
    }

    public static <T> T arrayRemoveDuplicated(T array) {
        if (array == null) {
            return null;
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Parameter must be array");
        }
        int len = Array.getLength(array);
        if (len < 2) {
            return array;
        }
        Class<?> arrayType = array.getClass().getComponentType();
        Object noDuplicates = Array.newInstance(arrayType, len);
        int uniqueCount = 0;
        for (int i = 0; i < len; ++i) {
            Object element = Array.get(array, i);
            if (BeanUtil.isArrayElementPresent(noDuplicates, element)) continue;
            Array.set(noDuplicates, uniqueCount, element);
            ++uniqueCount;
        }
        Object truncatedArray = Array.newInstance(arrayType, uniqueCount);
        System.arraycopy(noDuplicates, 0, truncatedArray, 0, uniqueCount);
        return (T)truncatedArray;
    }

    public static <T> boolean isArrayElementPresent(T array, T element) {
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object e1 = Array.get(array, i);
            if (!Objects.equals(e1, element)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] arrayRemoveDuplicated(T[] array) {
        if (array == null || array.length < 2) {
            return array;
        }
        Class<?> arrayType = array.getClass().getComponentType();
        Object[] noDuplicates = (Object[])Array.newInstance(arrayType, array.length);
        int uniqueCount = 0;
        for (T element : array) {
            if (BeanUtil.isArrayElementPresent(noDuplicates, element)) continue;
            noDuplicates[uniqueCount] = element;
            ++uniqueCount;
        }
        Object[] truncatedArray = (Object[])Array.newInstance(arrayType, uniqueCount);
        System.arraycopy(noDuplicates, 0, truncatedArray, 0, uniqueCount);
        return truncatedArray;
    }

    public static <T> boolean isArrayElementPresent(T[] array, T element) {
        for (T el : array) {
            if (!Objects.equals(el, element)) continue;
            return true;
        }
        return false;
    }

    static {
        BeanUtil.init(TimeZone.getDefault(), true, false, false, true);
        ValidatorFactory = Validation.buildDefaultValidatorFactory();
    }
}

