/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.i18n;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.summerboot.jexpress.i18n.AppResourceCfg;
import org.summerboot.jexpress.i18n.I18nLabel;

public class AppResourceBundle
extends ResourceBundle {
    protected static final ConcurrentHashMap<String, AppResourceBundle> POOL = new ConcurrentHashMap();
    protected static AppResourceBundle defaultRB;
    protected final ConcurrentMap<String, String> translationsMap;
    protected final AppResourceCfg cfg;

    public static synchronized void clear() {
        POOL.clear();
    }

    public static synchronized void addLabels(List<AppResourceCfg> cfgs, Class i18nClass) {
        HashMap tempRbs = new HashMap();
        cfgs.stream().forEach(cfg1 -> {
            String key = cfg1.getLanguageTag();
            HashMap<String, String> translationsMap1 = new HashMap<String, String>();
            I18nLabel.buildTranslationsMap(null, i18nClass, cfg1.getI18nLabelIndex(), translationsMap1);
            AppResourceBundle arb = POOL.get(key);
            if (arb == null) {
                arb = new AppResourceBundle((AppResourceCfg)cfg1, (Map<String, String>)translationsMap1);
                POOL.put(key, arb);
            } else {
                arb.translationsMap.putAll(translationsMap1);
            }
            if (cfg1.getParent() == null) {
                defaultRB = arb;
            }
            tempRbs.put(cfg1.getLocale(), arb);
        });
        cfgs.stream().filter(dto -> dto.getParent() != null).forEach(dto -> {
            AppResourceBundle p = (AppResourceBundle)tempRbs.get(dto.getParent());
            AppResourceBundle i = (AppResourceBundle)tempRbs.get(dto.getLocale());
            i.setParent(p);
        });
        tempRbs.clear();
    }

    public static void dumpToFile(String folder, String filename) {
        ArrayList<String> sorted = new ArrayList<String>();
        Enumeration<String> enumKeys = defaultRB.getKeys();
        while (enumKeys.hasMoreElements()) {
            sorted.add(enumKeys.nextElement());
        }
        Collections.sort(sorted);
        POOL.forEach((languageTag, rb) -> {
            Path path = Paths.get(folder, languageTag + "_" + filename);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                for (String key : sorted) {
                    writer.write(key + " = " + rb.getString(key) + "\n");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    public static void update(String languageTag, String key, String value) {
        AppResourceBundle cachedRb = POOL.get(languageTag);
        if (cachedRb != null) {
            cachedRb.update(key, value);
        }
    }

    public static AppResourceBundle getAppBundle(String languageTag) {
        if (languageTag == null) {
            return defaultRB;
        }
        AppResourceBundle ret = POOL.get(languageTag);
        if (ret == null) {
            ret = defaultRB;
        }
        return ret;
    }

    protected AppResourceBundle(AppResourceCfg cfg, Map<String, String> translations) {
        this.cfg = cfg;
        this.translationsMap = new ConcurrentHashMap<String, String>(translations.size());
        this.translationsMap.putAll(translations);
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.translationsMap.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        return new IteratorEnumeration<String>(this.translationsMap.keySet().iterator());
    }

    @Override
    public String getBaseBundleName() {
        return this.cfg.getLanguageTag();
    }

    @Override
    public Locale getLocale() {
        return this.cfg.getLocale();
    }

    public ResourceBundle getParent() {
        return this.parent;
    }

    protected void update(String key, String value) {
        if (value != null && !value.trim().isEmpty()) {
            this.translationsMap.put(key, value);
        }
    }

    protected static class IteratorEnumeration<E>
    implements Enumeration<E> {
        protected final Iterator<E> iterator;

        public IteratorEnumeration(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }
    }
}

