/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.MacAlgorithm;
import io.jsonwebtoken.security.SecretKeyBuilder;
import io.jsonwebtoken.security.SignatureAlgorithm;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.summerboot.jexpress.security.EncryptorUtil;

public class JwtUtil {
    public static String buildSigningKey(MacAlgorithm signatureAlgorithm) {
        SecretKey key = (SecretKey)((SecretKeyBuilder)signatureAlgorithm.key()).build();
        return EncryptorUtil.keyToString(key);
    }

    public static Key parseSigningKey(String encodedKey) {
        byte[] decodedKey = Base64.getDecoder().decode(encodedKey);
        return Keys.hmacShaKeyFor((byte[])decodedKey);
    }

    public static KeyPair buildSigningParsingKeyPair(SignatureAlgorithm signatureAlgorithm) {
        return (KeyPair)signatureAlgorithm.keyPair().build();
    }

    public static String createJWT(String keyAlgorithm, String jwtSigningKey, int ttlSeconds, String id, String issuer, String subject, Collection<String> audience) {
        JwtBuilder builder = Jwts.builder().id(id).issuer(issuer).subject(subject);
        builder.audience().add(audience);
        return JwtUtil.createJWT(keyAlgorithm, jwtSigningKey, builder, Duration.ofSeconds(ttlSeconds));
    }

    public static String createJWT(String keyAlgorithm, String jwtSigningKey, JwtBuilder builder, Duration ttl) {
        byte[] key = Base64.getDecoder().decode(jwtSigningKey);
        return JwtUtil.createJWT(keyAlgorithm, key, builder, ttl);
    }

    public static String createJWT(String keyAlgorithm, byte[] jwtSigningKey, int ttlSeconds, String id, String issuer, String subject, Collection<String> audience) {
        JwtBuilder builder = Jwts.builder().id(id).issuer(issuer).subject(subject);
        builder.audience().add(audience);
        return JwtUtil.createJWT(keyAlgorithm, jwtSigningKey, builder, Duration.ofSeconds(ttlSeconds));
    }

    public static String createJWT(String keyAlgorithm, byte[] jwtSigningKey, JwtBuilder builder, Duration ttl) {
        SecretKeySpec privateKey = new SecretKeySpec(jwtSigningKey, 0, jwtSigningKey.length, keyAlgorithm);
        return JwtUtil.createJWT(privateKey, builder, ttl);
    }

    public static void setJwtExpireTime(JwtBuilder builder, Duration ttl) {
        long expireTimeMilsec;
        if (ttl == null || ttl.isZero() || ttl.isNegative()) {
            return;
        }
        long ttlMilsec = ttl.toMillis();
        if (ttlMilsec > 0L && (expireTimeMilsec = System.currentTimeMillis() + ttlMilsec) > 0L) {
            Date exp = new Date(expireTimeMilsec);
            builder.expiration(exp);
        }
    }

    public static String createJWT(Key privateKey, int ttlSeconds, String id, String issuer, String subject, Collection<String> audience) {
        JwtBuilder builder = Jwts.builder().id(id).issuer(issuer).subject(subject);
        builder.audience().add(audience);
        return JwtUtil.createJWT(privateKey, builder, Duration.ofSeconds(ttlSeconds));
    }

    public static String createJWT(Key privateKey, JwtBuilder builder, Duration ttl) {
        JwtUtil.setJwtExpireTime(builder, ttl);
        builder.issuedAt(new Date()).signWith(privateKey);
        return builder.compact();
    }

    public static Jws<Claims> parseJWT(Key verifyKey, String token) {
        if (verifyKey instanceof SecretKey) {
            return JwtUtil.parseJWT((SecretKey)verifyKey, token);
        }
        if (verifyKey instanceof PublicKey) {
            return JwtUtil.parseJWT((PublicKey)verifyKey, token);
        }
        throw new IllegalArgumentException("Unsupported Key type: " + verifyKey.getClass().getName());
    }

    public static Jws<Claims> parseJWT(SecretKey jwtRootSigningKey, String token) {
        JwtParser parser = Jwts.parser().verifyWith(jwtRootSigningKey).build();
        return JwtUtil.parseJWT(parser, token);
    }

    public static Jws<Claims> parseJWT(PublicKey publicKey, String token) {
        JwtParser parser = Jwts.parser().verifyWith(publicKey).build();
        return JwtUtil.parseJWT(parser, token);
    }

    public static Jws<Claims> parseJWT(JwtParser parser, String token) {
        return parser.parseSignedClaims((CharSequence)token);
    }
}

